#! /bin/sh

# Set the path to the proper `prqlc` binary:
ARCH=$(uname -m)
cd $(dirname "$0")/..

if [ "$ARCH" = "x86_64" ]; then
    export PATH="./Resources/x86:$PATH"
elif [ "$ARCH" = "arm64" ]; then
    export JAVA_HOME="./Resources/jdk-21.0.6+7-jre/Contents/Home"
    export PATH="./Resources/arm64:$JAVA_HOME/bin:$PATH"
else
    echo "Unknown architecture: $ARCH"
fi

# Check if Java is functional (detecting the version)
if [ "$ARCH" = "arm64" ]; then
     $JAVA_HOME/bin/java -jar "./Resources/qstudio.jar"  
elif java -version &> /dev/null; then
    java -jar "./Resources/qstudio.jar"
else
    echo "Java is not installed."
    stderr_output=$(java -version 2>&1 1>/dev/null)
    # osascript -e 'display alert "Java not installed" message "$stderr_output" as critical buttons {"OK"} default button "OK"'
    osascript -e "display alert \"Java is not installed\" message \"$stderr_output\" as critical buttons {\"OK\"} default button \"OK\""
fi
