/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.shaded.com.ongres.scram.common;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.postgresql.shaded.com.ongres.scram.common.AbstractCharAttributeValue;
import org.postgresql.shaded.com.ongres.scram.common.Gs2Attributes;
import org.postgresql.shaded.com.ongres.scram.common.util.Preconditions;

final class Gs2AttributeValue
extends AbstractCharAttributeValue<Gs2Attributes> {
    Gs2AttributeValue(@NotNull Gs2Attributes attribute, @Nullable String value) {
        super(attribute, value);
        if (attribute.isRequiredValue()) {
            Preconditions.checkNotNull(value, "value");
        }
    }

    @NotNull
    static Gs2AttributeValue parse(@NotNull String value) {
        if (value.isEmpty() || value.length() == 2 || value.length() > 2 && value.charAt(1) != '=') {
            throw new IllegalArgumentException("Invalid Gs2AttributeValue");
        }
        Gs2Attributes byChar = Gs2Attributes.byChar(value.charAt(0));
        String val2 = value.length() > 2 ? value.substring(2) : null;
        return new Gs2AttributeValue(byChar, val2);
    }
}

