/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt.editor;

import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.experimental.chart.swt.editor.SWTOtherEditor;
import org.jfree.experimental.chart.swt.editor.SWTPlotEditor;
import org.jfree.experimental.chart.swt.editor.SWTTitleEditor;

public class SWTChartEditor
implements ChartEditor {
    private Shell shell;
    private JFreeChart chart;
    private SWTTitleEditor titleEditor;
    private SWTPlotEditor plotEditor;
    private SWTOtherEditor otherEditor;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.editor.LocalizationBundle");

    public SWTChartEditor(Display display, JFreeChart chart2edit) {
        this.shell = new Shell(display, 2144);
        this.shell.setSize(400, 500);
        this.chart = chart2edit;
        this.shell.setText(ResourceBundleWrapper.getBundle("org.jfree.chart.LocalizationBundle").getString("Chart_Properties"));
        GridLayout layout = new GridLayout(2, true);
        layout.marginBottom = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.marginLeft = 5;
        this.shell.setLayout((Layout)layout);
        Composite main = new Composite((Composite)this.shell, 0);
        main.setLayout((Layout)new FillLayout());
        main.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TabFolder tab = new TabFolder(main, 2048);
        TabItem item1 = new TabItem(tab, 0);
        item1.setText(" " + localizationResources.getString("Title") + " ");
        this.titleEditor = new SWTTitleEditor((Composite)tab, 0, this.chart.getTitle());
        item1.setControl((Control)this.titleEditor);
        TabItem item2 = new TabItem(tab, 0);
        item2.setText(" " + localizationResources.getString("Plot") + " ");
        this.plotEditor = new SWTPlotEditor((Composite)tab, 0, this.chart.getPlot());
        item2.setControl((Control)this.plotEditor);
        TabItem item3 = new TabItem(tab, 0);
        item3.setText(" " + localizationResources.getString("Other") + " ");
        this.otherEditor = new SWTOtherEditor((Composite)tab, 0, this.chart);
        item3.setControl((Control)this.otherEditor);
        Button ok = new Button((Composite)this.shell, 40);
        ok.setText(" Ok ");
        ok.setLayoutData((Object)new GridData(4, 4, false, false));
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTChartEditor.this.updateChart(SWTChartEditor.this.chart);
                SWTChartEditor.this.shell.dispose();
            }
        });
        Button cancel = new Button((Composite)this.shell, 8);
        cancel.setText(" Cancel ");
        cancel.setLayoutData((Object)new GridData(4, 4, false, false));
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTChartEditor.this.shell.dispose();
            }
        });
    }

    public void open() {
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
    }

    @Override
    public void updateChart(JFreeChart chart) {
        this.titleEditor.setTitleProperties(chart);
        this.plotEditor.updatePlotProperties(chart.getPlot());
        this.otherEditor.updateChartProperties(chart);
    }
}

