/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.plot;

import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.CombinedDomainCategoryPlot;
import org.jfree.data.Range;

public class CombinedCategoryPlot
extends CombinedDomainCategoryPlot {
    public CombinedCategoryPlot(CategoryAxis domainAxis, ValueAxis rangeAxis) {
        super(domainAxis);
        super.setGap(10.0);
        super.setRangeAxis(rangeAxis);
    }

    @Override
    public void add(CategoryPlot subplot) {
        this.add(subplot, 1);
    }

    @Override
    public void add(CategoryPlot subplot, int weight) {
        super.add(subplot, weight);
        ValueAxis l_range = super.getRangeAxis();
        subplot.setRangeAxis(0, l_range, false);
        super.setRangeAxis(l_range);
        if (null == l_range) {
            return;
        }
        l_range.configure();
    }

    @Override
    public Range getDataRange(ValueAxis axis) {
        Range l_result = null;
        for (CategoryPlot l_subplot : this.getSubplots()) {
            l_result = Range.combine(l_result, l_subplot.getDataRange(axis));
        }
        return l_result;
    }

    @Override
    public void setRangeAxis(ValueAxis axis) {
        for (CategoryPlot l_subplot : this.getSubplots()) {
            l_subplot.setRangeAxis(0, axis, false);
        }
        super.setRangeAxis(axis);
        if (null == axis) {
            return;
        }
        axis.configure();
    }
}

