/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jdesktop.swingx.util.GraphicsUtilities;

public class PaintUtils {
    public static final GradientPaint BLUE_EXPERIENCE = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(168, 204, 241), new Point2D.Double(0.0, 1.0), new Color(44, 61, 146));
    public static final GradientPaint MAC_OSX_SELECTED = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(81, 141, 236), new Point2D.Double(0.0, 1.0), new Color(36, 96, 192));
    public static final GradientPaint MAC_OSX = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(167, 210, 250), new Point2D.Double(0.0, 1.0), new Color(99, 147, 206));
    public static final GradientPaint AERITH = new GradientPaint(new Point2D.Double(0.0, 0.0), Color.WHITE, new Point2D.Double(0.0, 1.0), new Color(64, 110, 161));
    public static final GradientPaint GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(226, 226, 226), new Point2D.Double(0.0, 1.0), new Color(250, 248, 248));
    public static final GradientPaint RED_XP = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(236, 81, 81), new Point2D.Double(0.0, 1.0), new Color(192, 36, 36));
    public static final GradientPaint NIGHT_GRAY = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(102, 111, 127), new Point2D.Double(0.0, 1.0), new Color(38, 45, 61));
    public static final GradientPaint NIGHT_GRAY_LIGHT = new GradientPaint(new Point2D.Double(0.0, 0.0), new Color(129, 138, 155), new Point2D.Double(0.0, 1.0), new Color(58, 66, 82));
    public static final Paint ORANGE_DELIGHT = new LinearGradientPaint(new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 0.0), new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(248, 192, 75), new Color(253, 152, 6), new Color(243, 133, 0), new Color(254, 124, 0)});
    public static final Paint BLACK_STAR = new LinearGradientPaint(new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 0.0), new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(54, 62, 78), new Color(32, 39, 55), new Color(74, 82, 96), new Color(123, 132, 145)});

    private PaintUtils() {
    }

    @Deprecated
    public static Rectangle getTextBounds(Graphics g, JLabel label) {
        FontMetrics fm = g.getFontMetrics();
        Rectangle2D r2d = fm.getStringBounds(label.getText(), g);
        Rectangle rect = r2d.getBounds();
        int xOffset = 0;
        switch (label.getHorizontalAlignment()) {
            case 4: 
            case 11: {
                xOffset = label.getBounds().width - rect.width;
                break;
            }
            case 0: {
                xOffset = (label.getBounds().width - rect.width) / 2;
                break;
            }
            default: {
                xOffset = 0;
            }
        }
        int yOffset = 0;
        switch (label.getVerticalAlignment()) {
            case 1: {
                yOffset = 0;
                break;
            }
            case 0: {
                yOffset = (label.getBounds().height - rect.height) / 2;
                break;
            }
            case 3: {
                yOffset = label.getBounds().height - rect.height;
            }
        }
        return new Rectangle(xOffset, yOffset, rect.width, rect.height);
    }

    @Deprecated
    public static void paintGradient(Graphics g, JComponent comp, Color color1, Color color2) {
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, color1, 0.0f, comp.getHeight(), color2, true);
        Graphics2D g2 = (Graphics2D)g;
        Paint oldPaint = g2.getPaint();
        g2.setPaint(paint);
        g2.fillRect(0, 0, comp.getWidth(), comp.getHeight());
        g2.setPaint(oldPaint);
    }

    public static Paint resizeGradient(Paint p, int width, int height) {
        if (p == null) {
            return p;
        }
        if (p instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)p;
            Point2D[] pts = new Point2D[]{gp.getPoint1(), gp.getPoint2()};
            pts = PaintUtils.adjustPoints(pts, width, height);
            return new GradientPaint(pts[0], gp.getColor1(), pts[1], gp.getColor2(), gp.isCyclic());
        }
        if ("java.awt.LinearGradientPaint".equals(p.getClass().getName()) || "org.apache.batik.ext.awt.LinearGradientPaint".equals(p.getClass().getName())) {
            return PaintUtils.resizeLinearGradient(p, width, height);
        }
        return p;
    }

    private static Paint resizeLinearGradient(Paint p, int width, int height) {
        try {
            Point2D[] pts = new Point2D[]{(Point2D)PaintUtils.invokeMethod(p, "getStartPoint"), (Point2D)PaintUtils.invokeMethod(p, "getEndPoint")};
            pts = PaintUtils.adjustPoints(pts, width, height);
            float[] fractions = (float[])PaintUtils.invokeMethod(p, "getFractions");
            Color[] colors = (Color[])PaintUtils.invokeMethod(p, "getColors");
            Constructor<?> con = p.getClass().getDeclaredConstructor(Point2D.class, Point2D.class, new float[0].getClass(), new Color[0].getClass());
            return (Paint)con.newInstance(pts[0], pts[1], fractions, colors);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return p;
        }
    }

    private static Object invokeMethod(Object p, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, SecurityException, IllegalAccessException {
        Method meth = p.getClass().getMethod(methodName, new Class[0]);
        return meth.invoke(p, new Object[0]);
    }

    private static Point2D[] adjustPoints(Point2D[] pts, int width, int height) {
        Point2D start = pts[0];
        Point2D end = pts[1];
        double angle = PaintUtils.calcAngle(start, end);
        double a2 = Math.toDegrees(angle);
        double e = 1.0;
        if (Math.abs(angle) < Math.toRadians(e) || Math.abs(angle) > Math.toRadians(360.0 - e)) {
            start = new Point2D.Float(0.0f, 0.0f);
            end = new Point2D.Float(PaintUtils.normalize(end.getX(), width), 0.0f);
        }
        if (PaintUtils.isNear(a2, 45.0, e)) {
            start = new Point2D.Float(0.0f, 0.0f);
            end = new Point2D.Float(PaintUtils.normalize(end.getX(), width), PaintUtils.normalize(end.getY(), height));
        }
        if (PaintUtils.isNear(a2, 90.0, e)) {
            start = new Point2D.Float(0.0f, 0.0f);
            end = new Point2D.Float(0.0f, PaintUtils.normalize(end.getY(), height));
        }
        if (PaintUtils.isNear(a2, 135.0, e)) {
            start = new Point2D.Float(PaintUtils.normalize(start.getX(), width), 0.0f);
            end = new Point2D.Float(0.0f, PaintUtils.normalize(end.getY(), height));
        }
        if (PaintUtils.isNear(a2, 180.0, e)) {
            start = new Point2D.Float(PaintUtils.normalize(start.getX(), width), 0.0f);
            end = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(a2, 225.0, e)) {
            start = new Point2D.Float(PaintUtils.normalize(start.getX(), width), PaintUtils.normalize(start.getY(), height));
            end = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(a2, 270.0, e)) {
            start = new Point2D.Float(0.0f, PaintUtils.normalize(start.getY(), height));
            end = new Point2D.Float(0.0f, 0.0f);
        }
        if (PaintUtils.isNear(a2, 315.0, e)) {
            start = new Point2D.Float(0.0f, PaintUtils.normalize(start.getY(), height));
            end = new Point2D.Float(PaintUtils.normalize(end.getX(), width), 0.0f);
        }
        return new Point2D[]{start, end};
    }

    private static boolean isNear(double angle, double target, double error) {
        return Math.abs(target - Math.abs(angle)) < error;
    }

    private static float normalize(double original, float target) {
        if (original < 1.0) {
            return target * (float)original;
        }
        return target;
    }

    private static double calcAngle(Point2D p1, Point2D p2) {
        double x_off = p2.getX() - p1.getX();
        double y_off = p2.getY() - p1.getY();
        double angle = Math.atan(y_off / x_off);
        if (x_off < 0.0) {
            angle += Math.PI;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (angle > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return angle;
    }

    public static Paint getCheckerPaint() {
        return PaintUtils.getCheckerPaint(Color.WHITE, Color.GRAY, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Paint getCheckerPaint(Paint c1, Paint c2, int size) {
        BufferedImage img = GraphicsUtilities.createCompatibleTranslucentImage(size, size);
        Graphics2D g = img.createGraphics();
        try {
            g.setPaint(c1);
            g.fillRect(0, 0, size, size);
            g.setPaint(c2);
            g.fillRect(0, 0, size / 2, size / 2);
            g.fillRect(size / 2, size / 2, size / 2, size / 2);
        }
        finally {
            g.dispose();
        }
        return new TexturePaint(img, new Rectangle(0, 0, size, size));
    }

    public static String toHexString(Color color) {
        return "#" + Integer.toHexString(color.getRGB() | 0xFF000000).substring(2);
    }

    public static Color removeAlpha(Color color) {
        return PaintUtils.setAlpha(color, 255);
    }

    public static Color setAlpha(Color color, int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("invalid alpha value");
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color setSaturation(Color color, float saturation) {
        if (saturation < 0.0f || saturation > 1.0f) {
            throw new IllegalArgumentException("invalid saturation value");
        }
        int alpha = color.getAlpha();
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color c2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        return PaintUtils.setAlpha(c2, alpha);
    }

    public static Color setBrightness(Color color, float brightness) {
        if (brightness < 0.0f || brightness > 1.0f) {
            throw new IllegalArgumentException("invalid brightness value");
        }
        int alpha = color.getAlpha();
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color c2 = Color.getHSBColor(hsb[0], hsb[1], brightness);
        return PaintUtils.setAlpha(c2, alpha);
    }

    public static Color blend(Color origin, Color over) {
        if (over == null) {
            return origin;
        }
        if (origin == null) {
            return over;
        }
        int a = over.getAlpha();
        int rb = (over.getRGB() & 0xFF00FF) * (a + 1) + (origin.getRGB() & 0xFF00FF) * (255 - a) & 0xFF00FF00;
        int g = (over.getRGB() & 0xFF00) * (a + 1) + (origin.getRGB() & 0xFF00) * (255 - a) & 0xFF0000;
        return new Color(over.getRGB() & 0xFF000000 | (rb | g) >> 8);
    }

    public static Color interpolate(Color b, Color a, float t) {
        float[] acomp = a.getRGBComponents(null);
        float[] bcomp = b.getRGBComponents(null);
        float[] ccomp = new float[4];
        for (int i = 0; i < 4; ++i) {
            ccomp[i] = acomp[i] + (bcomp[i] - acomp[i]) * t;
        }
        return new Color(ccomp[0], ccomp[1], ccomp[2], ccomp[3]);
    }

    public static Color computeForeground(Color bg) {
        float[] rgb = bg.getRGBColorComponents(null);
        float y = 0.3f * rgb[0] + 0.59f * rgb[1] + 0.11f * rgb[2];
        return y > 0.5f ? Color.BLACK : Color.WHITE;
    }
}

