/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.renderer.CellContext;

public class TreeCellContext
extends CellContext {
    protected Icon leafIcon;
    protected Icon closedIcon;
    protected Icon openIcon;
    private Border treeFocusBorder;

    public void installContext(JTree component, Object value, int row, int column, boolean selected, boolean focused, boolean expanded, boolean leaf) {
        this.component = component;
        this.installState(value, row, column, selected, focused, expanded, leaf);
        this.dropOn = this.checkDropOnState();
    }

    private boolean checkDropOnState() {
        if (this.getComponent() == null) {
            return false;
        }
        JTree.DropLocation dropLocation = this.getComponent().getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && this.getComponent().getRowForPath(dropLocation.getPath()) == this.row;
    }

    @Override
    public JTree getComponent() {
        return (JTree)super.getComponent();
    }

    public TreePath getTreePath() {
        if (this.getComponent() == null) {
            return null;
        }
        if (this.row < 0 || this.row >= this.getComponent().getRowCount()) {
            return null;
        }
        return this.getComponent().getPathForRow(this.row);
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    protected Color getSelectionBackground() {
        Color selection = null;
        if (this.isDropOn() && (selection = this.getDropCellBackground()) != null) {
            return selection;
        }
        if (this.getComponent() instanceof JXTree) {
            return ((JXTree)this.getComponent()).getSelectionBackground();
        }
        return UIManager.getColor("Tree.selectionBackground");
    }

    @Override
    protected Color getSelectionForeground() {
        Color selection = null;
        if (this.isDropOn() && (selection = this.getDropCellForeground()) != null) {
            return selection;
        }
        if (this.getComponent() instanceof JXTree) {
            return ((JXTree)this.getComponent()).getSelectionForeground();
        }
        return UIManager.getColor("Tree.selectionForeground");
    }

    @Override
    protected String getUIPrefix() {
        return "Tree.";
    }

    protected Icon getLeafIcon() {
        return this.leafIcon != null ? this.leafIcon : UIManager.getIcon(this.getUIKey("leafIcon"));
    }

    protected Icon getOpenIcon() {
        return this.openIcon != null ? this.openIcon : UIManager.getIcon(this.getUIKey("openIcon"));
    }

    protected Icon getClosedIcon() {
        return this.closedIcon != null ? this.closedIcon : UIManager.getIcon(this.getUIKey("closedIcon"));
    }

    @Override
    public Icon getIcon() {
        if (this.isLeaf()) {
            return this.getLeafIcon();
        }
        if (this.isExpanded()) {
            return this.getOpenIcon();
        }
        return this.getClosedIcon();
    }

    @Override
    protected Border getFocusBorder() {
        if (this.treeFocusBorder == null) {
            this.treeFocusBorder = new TreeFocusBorder();
        }
        return this.treeFocusBorder;
    }

    public class TreeFocusBorder
    extends LineBorder {
        private Color treeBackground;
        private Color focusColor;

        public TreeFocusBorder() {
            super(Color.BLACK);
            this.treeBackground = TreeCellContext.this.getBackground();
            if (this.treeBackground != null) {
                this.focusColor = new Color(~this.treeBackground.getRGB());
            }
        }

        @Override
        public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
            Color color = UIManager.getColor("Tree.selectionBorderColor");
            if (color != null) {
                this.lineColor = color;
            }
            if (this.isDashed()) {
                if (this.treeBackground != c2.getBackground()) {
                    this.treeBackground = c2.getBackground();
                    this.focusColor = new Color(~this.treeBackground.getRGB());
                }
                Color old = g.getColor();
                g.setColor(this.focusColor);
                BasicGraphicsUtils.drawDashedRect(g, x, y, width, height);
                g.setColor(old);
            } else {
                super.paintBorder(c2, g, x, y, width, height);
            }
        }

        private boolean isDashed() {
            return Boolean.TRUE.equals(UIManager.get("Tree.drawDashedFocusIndicator"));
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

