/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.windows;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.plaf.basic.BasicStatusBarUI;

public class WindowsStatusBarUI
extends BasicStatusBarUI {
    private static final Logger log = Logger.getLogger(WindowsStatusBarUI.class.getName());
    private BufferedImage leftImage;
    private BufferedImage middleImage;
    private BufferedImage rightImage;

    public WindowsStatusBarUI() {
        try {
            this.leftImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.leftImage")));
            this.middleImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.middleImage")));
            this.rightImage = ImageIO.read(WindowsStatusBarUI.class.getResource(UIManagerExt.getString("StatusBar.rightImage")));
        }
        catch (Exception e) {
            log.log(Level.FINE, e.getLocalizedMessage(), e);
        }
    }

    public static ComponentUI createUI(JComponent c2) {
        return new WindowsStatusBarUI();
    }

    @Override
    protected void paintBackground(Graphics2D g, JXStatusBar statusBar) {
        if (this.leftImage == null || this.middleImage == null || this.rightImage == null) {
            log.severe("Failed to initialize necessary assets. Set logging to FINE to see more details.");
            return;
        }
        g.drawImage(this.leftImage, 0, 0, this.leftImage.getWidth(), statusBar.getHeight(), null);
        if (statusBar.isResizeHandleEnabled()) {
            g.drawImage(this.middleImage, this.leftImage.getWidth(), 0, statusBar.getWidth() - this.leftImage.getWidth() - this.rightImage.getWidth(), statusBar.getHeight(), null);
            g.drawImage(this.rightImage, statusBar.getWidth() - this.rightImage.getWidth(), 0, this.rightImage.getWidth(), statusBar.getHeight(), null);
        } else {
            g.drawImage(this.middleImage, this.leftImage.getWidth(), 0, statusBar.getWidth() - this.leftImage.getWidth(), statusBar.getHeight(), null);
        }
    }

    @Override
    protected Insets getSeparatorInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = 1;
        insets.left = 4;
        insets.bottom = 0;
        insets.right = 4;
        return insets;
    }
}

