/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.util.PaintUtils;

public class GradientThumbRenderer
extends JComponent
implements ThumbRenderer {
    private Image thumb_black;
    private Image thumb_gray;
    private boolean selected;

    public GradientThumbRenderer() {
        try {
            this.thumb_black = ImageIO.read(GradientThumbRenderer.class.getResourceAsStream("/icons/thumb_black.png"));
            this.thumb_gray = ImageIO.read(GradientThumbRenderer.class.getResourceAsStream("/icons/thumb_gray.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        GradientThumbRenderer thumb = this;
        int w = thumb.getWidth();
        g.setColor(this.getForeground());
        g.fillRect(0, 0, w - 1, w - 1);
        if (this.selected) {
            g.drawImage(this.thumb_black, 0, 0, null);
        } else {
            g.drawImage(this.thumb_gray, 0, 0, null);
        }
    }

    @Override
    public JComponent getThumbRendererComponent(JXMultiThumbSlider slider, int index, boolean selected) {
        Color c2 = (Color)slider.getModel().getThumbAt(index).getObject();
        c2 = PaintUtils.removeAlpha(c2);
        this.setForeground(c2);
        this.selected = selected;
        return this;
    }
}

