/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import org.jdesktop.swingx.AbstractLayoutManager;
import org.jdesktop.swingx.util.Separator;

public class VerticalLayout
extends AbstractLayoutManager {
    private static final long serialVersionUID = 5342270033773736441L;
    private int gap;

    public VerticalLayout() {
        this(0);
    }

    public VerticalLayout(int gap) {
        this.gap = gap;
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension pref = new Dimension(0, 0);
        Separator<Integer> sep = new Separator<Integer>(0, this.gap);
        int c2 = parent.getComponentCount();
        for (int i = 0; i < c2; ++i) {
            Component m = parent.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension componentPreferredSize = parent.getComponent(i).getPreferredSize();
            pref.height += componentPreferredSize.height + sep.get();
            pref.width = Math.max(pref.width, componentPreferredSize.width);
        }
        Insets insets = parent.getInsets();
        pref.width += insets.left + insets.right;
        pref.height += insets.top + insets.bottom;
        return pref;
    }

    @Override
    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int width = size.width - insets.left - insets.right;
        int height = insets.top;
        int c2 = parent.getComponentCount();
        for (int i = 0; i < c2; ++i) {
            Component m = parent.getComponent(i);
            if (!m.isVisible()) continue;
            m.setBounds(insets.left, height, width, m.getPreferredSize().height);
            height += m.getSize().height + this.gap;
        }
    }
}

