/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.UIManager;

public class MultiSplitLayout
implements LayoutManager,
Serializable {
    public static final int DEFAULT_LAYOUT = 0;
    public static final int NO_MIN_SIZE_LAYOUT = 1;
    public static final int USER_MIN_SIZE_LAYOUT = 2;
    private final Map<String, Component> childMap = new HashMap<String, Component>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Node model;
    private int dividerSize;
    private boolean floatingDividers = true;
    private boolean removeDividers = true;
    private boolean layoutByWeight = false;
    private int layoutMode;
    private int userMinSize = 20;

    public MultiSplitLayout() {
        this(new Leaf("default"));
    }

    public MultiSplitLayout(boolean layoutByWeight) {
        this(new Leaf("default"));
        this.layoutByWeight = layoutByWeight;
    }

    public void layoutByWeight(Container parent) {
        this.doLayoutByWeight(parent);
        this.layoutContainer(parent);
    }

    private void doLayoutByWeight(Container parent) {
        Dimension size = parent.getSize();
        Insets insets = parent.getInsets();
        int width = size.width - (insets.left + insets.right);
        int height = size.height - (insets.top + insets.bottom);
        Rectangle bounds = new Rectangle(insets.left, insets.top, width, height);
        if (this.model instanceof Leaf) {
            this.model.setBounds(bounds);
        } else if (this.model instanceof Split) {
            this.doLayoutByWeight(this.model, bounds);
        }
    }

    private void doLayoutByWeight(Node node, Rectangle bounds) {
        int width = bounds.width;
        int height = bounds.height;
        Split split = (Split)node;
        List<Node> splitChildren = split.getChildren();
        double distributableWeight = 1.0;
        int unweightedComponents = 0;
        int dividerSpace = 0;
        for (Node splitChild : splitChildren) {
            if (!splitChild.isVisible()) continue;
            if (splitChild instanceof Divider) {
                dividerSpace += this.dividerSize;
                continue;
            }
            double weight = splitChild.getWeight();
            if (weight > 0.0) {
                distributableWeight -= weight;
                continue;
            }
            ++unweightedComponents;
        }
        if (split.isRowLayout()) {
            double distributableWidth = (double)(width -= dividerSpace) * distributableWeight;
            for (Node splitChild : splitChildren) {
                if (!splitChild.isVisible() || splitChild instanceof Divider) continue;
                double weight = splitChild.getWeight();
                Rectangle splitChildBounds = splitChild.getBounds();
                splitChildBounds = weight >= 0.0 ? new Rectangle(splitChildBounds.x, splitChildBounds.y, (int)((double)width * weight), height) : new Rectangle(splitChildBounds.x, splitChildBounds.y, (int)(distributableWidth / (double)unweightedComponents), height);
                if (this.layoutMode == 2) {
                    splitChildBounds.setSize(Math.max(splitChildBounds.width, this.userMinSize), splitChildBounds.height);
                }
                splitChild.setBounds(splitChildBounds);
                if (splitChild instanceof Split) {
                    this.doLayoutByWeight(splitChild, splitChildBounds);
                    continue;
                }
                Component comp = this.getComponentForNode(splitChild);
                if (comp == null) continue;
                comp.setPreferredSize(splitChildBounds.getSize());
            }
        } else {
            double distributableHeight = (double)(height -= dividerSpace) * distributableWeight;
            for (Node splitChild : splitChildren) {
                if (!splitChild.isVisible() || splitChild instanceof Divider) continue;
                double weight = splitChild.getWeight();
                Rectangle splitChildBounds = splitChild.getBounds();
                splitChildBounds = weight >= 0.0 ? new Rectangle(splitChildBounds.x, splitChildBounds.y, width, (int)((double)height * weight)) : new Rectangle(splitChildBounds.x, splitChildBounds.y, width, (int)(distributableHeight / (double)unweightedComponents));
                if (this.layoutMode == 2) {
                    splitChildBounds.setSize(splitChildBounds.width, Math.max(splitChildBounds.height, this.userMinSize));
                }
                splitChild.setBounds(splitChildBounds);
                if (splitChild instanceof Split) {
                    this.doLayoutByWeight(splitChild, splitChildBounds);
                    continue;
                }
                Component comp = this.getComponentForNode(splitChild);
                if (comp == null) continue;
                comp.setPreferredSize(splitChildBounds.getSize());
            }
        }
    }

    public Component getComponentForNode(Node n) {
        String name = ((Leaf)n).getName();
        return name != null ? this.childMap.get(name) : null;
    }

    public Node getNodeForComponent(Component comp) {
        return this.getNodeForName(this.getNameForComponent(comp));
    }

    public Node getNodeForName(String name) {
        if (this.model instanceof Split) {
            Split split = (Split)this.model;
            return this.getNodeForName(split, name);
        }
        return null;
    }

    public String getNameForComponent(Component child) {
        String name = null;
        for (Map.Entry<String, Component> kv : this.childMap.entrySet()) {
            if (kv.getValue() != child) continue;
            name = kv.getKey();
            break;
        }
        return name;
    }

    public Node getNodeForComponent(Split split, Component comp) {
        return this.getNodeForName(split, this.getNameForComponent(comp));
    }

    public Node getNodeForName(Split split, String name) {
        for (Node n : split.getChildren()) {
            Node n1;
            if (n instanceof Leaf) {
                if (!((Leaf)n).getName().equals(name)) continue;
                return n;
            }
            if (!(n instanceof Split) || (n1 = this.getNodeForName((Split)n, name)) == null) continue;
            return n1;
        }
        return null;
    }

    public boolean hasModel() {
        return this.model != null;
    }

    public MultiSplitLayout(Node model) {
        this.model = model;
        this.dividerSize = UIManager.getInt("SplitPane.dividerSize");
        if (this.dividerSize == 0) {
            this.dividerSize = 7;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    private void firePCS(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Node getModel() {
        return this.model;
    }

    public void setModel(Node model) {
        if (model == null || model instanceof Divider) {
            throw new IllegalArgumentException("invalid model");
        }
        Node oldModel = this.getModel();
        this.model = model;
        this.firePCS("model", oldModel, this.getModel());
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int dividerSize) {
        if (dividerSize < 0) {
            throw new IllegalArgumentException("invalid dividerSize");
        }
        int oldDividerSize = this.dividerSize;
        this.dividerSize = dividerSize;
        this.firePCS("dividerSize", new Integer(oldDividerSize), new Integer(dividerSize));
    }

    public boolean getFloatingDividers() {
        return this.floatingDividers;
    }

    public void setFloatingDividers(boolean floatingDividers) {
        boolean oldFloatingDividers = this.floatingDividers;
        this.floatingDividers = floatingDividers;
        this.firePCS("floatingDividers", new Boolean(oldFloatingDividers), new Boolean(floatingDividers));
    }

    public boolean getRemoveDividers() {
        return this.removeDividers;
    }

    public void setRemoveDividers(boolean removeDividers) {
        boolean oldRemoveDividers = this.removeDividers;
        this.removeDividers = removeDividers;
        this.firePCS("removeDividers", new Boolean(oldRemoveDividers), new Boolean(removeDividers));
    }

    @Override
    public void addLayoutComponent(String name, Component child) {
        if (name == null) {
            throw new IllegalArgumentException("name not specified");
        }
        this.childMap.put(name, child);
    }

    @Override
    public void removeLayoutComponent(Component child) {
        String name = this.getNameForComponent(child);
        if (name != null) {
            this.childMap.remove(name);
        }
    }

    public void removeLayoutNode(String name) {
        if (name != null) {
            Node n = !(this.model instanceof Split) ? this.model : this.getNodeForName(name);
            this.childMap.remove(name);
            if (n != null) {
                Split s = n.getParent();
                s.remove(n);
                if (this.removeDividers) {
                    while (s.getChildren().size() < 2) {
                        Split p = s.getParent();
                        if (p == null) {
                            this.model = s.getChildren().size() > 0 ? s.getChildren().get(0) : null;
                            return;
                        }
                        if (s.getChildren().size() == 1) {
                            Node next = s.getChildren().get(0);
                            p.replace(s, next);
                            next.setParent(p);
                        } else {
                            p.remove(s);
                        }
                        s = p;
                    }
                }
            } else {
                this.childMap.remove(name);
            }
        }
    }

    public void displayNode(String name, boolean visible) {
        Node node = this.getNodeForName(name);
        if (node != null) {
            Component comp = this.getComponentForNode(node);
            comp.setVisible(visible);
            node.setVisible(visible);
            Split p = node.getParent();
            if (!visible) {
                p.hide(node);
                if (!p.isVisible()) {
                    p.getParent().hide(p);
                }
                p.checkDividers(p);
                while (!p.isVisible() && (p = p.getParent()) != null) {
                    p.checkDividers(p);
                }
            } else {
                p.restoreDividers(p);
            }
        }
        this.setFloatingDividers(false);
    }

    private Component childForNode(Node node) {
        if (node instanceof Leaf) {
            Leaf leaf = (Leaf)node;
            String name = leaf.getName();
            return name != null ? this.childMap.get(name) : null;
        }
        return null;
    }

    private Dimension preferredComponentSize(Node node) {
        if (this.layoutMode == 1) {
            return new Dimension(0, 0);
        }
        Component child = this.childForNode(node);
        return child != null && child.isVisible() ? child.getPreferredSize() : new Dimension(0, 0);
    }

    private Dimension minimumComponentSize(Node node) {
        if (this.layoutMode == 1) {
            return new Dimension(0, 0);
        }
        Component child = this.childForNode(node);
        return child != null && child.isVisible() ? child.getMinimumSize() : new Dimension(0, 0);
    }

    private Dimension preferredNodeSize(Node root) {
        if (root instanceof Leaf) {
            return this.preferredComponentSize(root);
        }
        if (root instanceof Divider) {
            if (!((Divider)root).isVisible()) {
                return new Dimension(0, 0);
            }
            int divSize = this.getDividerSize();
            return new Dimension(divSize, divSize);
        }
        Split split = (Split)root;
        List<Node> splitChildren = split.getChildren();
        int width = 0;
        int height = 0;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                if (!splitChild.isVisible()) continue;
                Dimension size = this.preferredNodeSize(splitChild);
                width += size.width;
                height = Math.max(height, size.height);
            }
        } else {
            for (Node splitChild : splitChildren) {
                if (!splitChild.isVisible()) continue;
                Dimension size = this.preferredNodeSize(splitChild);
                width = Math.max(width, size.width);
                height += size.height;
            }
        }
        return new Dimension(width, height);
    }

    public Dimension minimumNodeSize(Node root) {
        assert (root.isVisible);
        if (root instanceof Leaf) {
            if (this.layoutMode == 1) {
                return new Dimension(0, 0);
            }
            Component child = this.childForNode(root);
            return child != null && child.isVisible() ? child.getMinimumSize() : new Dimension(0, 0);
        }
        if (root instanceof Divider) {
            if (!((Divider)root).isVisible()) {
                return new Dimension(0, 0);
            }
            int divSize = this.getDividerSize();
            return new Dimension(divSize, divSize);
        }
        Split split = (Split)root;
        List<Node> splitChildren = split.getChildren();
        int width = 0;
        int height = 0;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                if (!splitChild.isVisible()) continue;
                Dimension size = this.minimumNodeSize(splitChild);
                width += size.width;
                height = Math.max(height, size.height);
            }
        } else {
            for (Node splitChild : splitChildren) {
                if (!splitChild.isVisible()) continue;
                Dimension size = this.minimumNodeSize(splitChild);
                width = Math.max(width, size.width);
                height += size.height;
            }
        }
        return new Dimension(width, height);
    }

    public Dimension maximumNodeSize(Node root) {
        assert (root.isVisible);
        if (root instanceof Leaf) {
            Component child = this.childForNode(root);
            return child != null && child.isVisible() ? child.getMaximumSize() : new Dimension(0, 0);
        }
        if (root instanceof Divider) {
            if (!((Divider)root).isVisible()) {
                return new Dimension(0, 0);
            }
            int divSize = this.getDividerSize();
            return new Dimension(divSize, divSize);
        }
        Split split = (Split)root;
        List<Node> splitChildren = split.getChildren();
        int width = Integer.MAX_VALUE;
        int height = Integer.MAX_VALUE;
        if (split.isRowLayout()) {
            for (Node splitChild : splitChildren) {
                if (!splitChild.isVisible()) continue;
                Dimension size = this.maximumNodeSize(splitChild);
                width += size.width;
                height = Math.min(height, size.height);
            }
        } else {
            for (Node splitChild : splitChildren) {
                if (!splitChild.isVisible()) continue;
                Dimension size = this.maximumNodeSize(splitChild);
                width = Math.min(width, size.width);
                height += size.height;
            }
        }
        return new Dimension(width, height);
    }

    private Dimension sizeWithInsets(Container parent, Dimension size) {
        Insets insets = parent.getInsets();
        int width = size.width + insets.left + insets.right;
        int height = size.height + insets.top + insets.bottom;
        return new Dimension(width, height);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension size = this.preferredNodeSize(this.getModel());
        return this.sizeWithInsets(parent, size);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension size = this.minimumNodeSize(this.getModel());
        return this.sizeWithInsets(parent, size);
    }

    private Rectangle boundsWithYandHeight(Rectangle bounds, double y, double height) {
        Rectangle r = new Rectangle();
        r.setBounds((int)bounds.getX(), (int)y, (int)bounds.getWidth(), (int)height);
        return r;
    }

    private Rectangle boundsWithXandWidth(Rectangle bounds, double x, double width) {
        Rectangle r = new Rectangle();
        r.setBounds((int)x, (int)bounds.getY(), (int)width, (int)bounds.getHeight());
        return r;
    }

    private void minimizeSplitBounds(Split split, Rectangle bounds) {
        assert (split.isVisible());
        Rectangle splitBounds = new Rectangle(bounds.x, bounds.y, 0, 0);
        List<Node> splitChildren = split.getChildren();
        Node lastChild = null;
        int lastVisibleChildIdx = splitChildren.size();
        do {
            lastChild = splitChildren.get(--lastVisibleChildIdx);
        } while (lastVisibleChildIdx > 0 && !lastChild.isVisible());
        if (!lastChild.isVisible()) {
            return;
        }
        if (lastVisibleChildIdx >= 0) {
            Rectangle lastChildBounds = lastChild.getBounds();
            if (split.isRowLayout()) {
                int lastChildMaxX = lastChildBounds.x + lastChildBounds.width;
                splitBounds.add(lastChildMaxX, bounds.y + bounds.height);
            } else {
                int lastChildMaxY = lastChildBounds.y + lastChildBounds.height;
                splitBounds.add(bounds.x + bounds.width, lastChildMaxY);
            }
        }
        split.setBounds(splitBounds);
    }

    private void layoutShrink(Split split, Rectangle bounds) {
        Rectangle splitBounds = split.getBounds();
        ListIterator<Node> splitChildren = split.getChildren().listIterator();
        Node lastWeightedChild = split.lastWeightedChild();
        if (split.isRowLayout()) {
            boolean onlyShrinkWeightedComponents;
            double extraWidth;
            int totalWidth = 0;
            int minWeightedWidth = 0;
            int totalWeightedWidth = 0;
            for (Node splitChild : split.getChildren()) {
                if (!splitChild.isVisible()) continue;
                int nodeWidth = splitChild.getBounds().width;
                int nodeMinWidth = 0;
                if (this.layoutMode == 2 && !(splitChild instanceof Divider)) {
                    nodeMinWidth = this.userMinSize;
                } else if (this.layoutMode == 0) {
                    nodeMinWidth = Math.min(nodeWidth, this.minimumNodeSize((Node)splitChild).width);
                }
                totalWidth += nodeWidth;
                if (!(splitChild.getWeight() > 0.0)) continue;
                minWeightedWidth += nodeMinWidth;
                totalWeightedWidth += nodeWidth;
            }
            double x = bounds.getX();
            double availableWidth = extraWidth = splitBounds.getWidth() - bounds.getWidth();
            boolean bl = onlyShrinkWeightedComponents = (double)(totalWeightedWidth - minWeightedWidth) > extraWidth;
            while (splitChildren.hasNext()) {
                Rectangle newSplitChildBounds;
                double splitChildWeight;
                Node splitChild = splitChildren.next();
                if (!splitChild.isVisible()) {
                    if (!splitChildren.hasNext()) continue;
                    splitChildren.next();
                    continue;
                }
                Rectangle splitChildBounds = splitChild.getBounds();
                double minSplitChildWidth = 0.0;
                if (this.layoutMode == 2 && !(splitChild instanceof Divider)) {
                    minSplitChildWidth = this.userMinSize;
                } else if (this.layoutMode == 0) {
                    minSplitChildWidth = this.minimumNodeSize(splitChild).getWidth();
                }
                double d = splitChildWeight = onlyShrinkWeightedComponents ? splitChild.getWeight() : splitChildBounds.getWidth() / (double)totalWidth;
                if (!splitChildren.hasNext()) {
                    double newWidth = Math.max(minSplitChildWidth, bounds.getMaxX() - x);
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                if (!splitChild.isVisible()) continue;
                if (availableWidth > 0.0 && splitChildWeight > 0.0) {
                    double newWidth;
                    double oldWidth = splitChildBounds.getWidth();
                    if (splitChild instanceof Divider) {
                        newWidth = this.dividerSize;
                    } else {
                        double allocatedWidth = Math.rint(splitChildWeight * extraWidth);
                        newWidth = Math.max(minSplitChildWidth, oldWidth - allocatedWidth);
                    }
                    Rectangle newSplitChildBounds2 = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds2);
                    availableWidth -= oldWidth - splitChild.getBounds().getWidth();
                } else {
                    double existingWidth = splitChildBounds.getWidth();
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, existingWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                x = splitChild.getBounds().getMaxX();
            }
        } else {
            boolean onlyShrinkWeightedComponents;
            double extraHeight;
            int totalHeight = 0;
            int minWeightedHeight = 0;
            int totalWeightedHeight = 0;
            for (Node splitChild : split.getChildren()) {
                if (!splitChild.isVisible()) continue;
                int nodeHeight = splitChild.getBounds().height;
                int nodeMinHeight = 0;
                if (this.layoutMode == 2 && !(splitChild instanceof Divider)) {
                    nodeMinHeight = this.userMinSize;
                } else if (this.layoutMode == 0) {
                    nodeMinHeight = Math.min(nodeHeight, this.minimumNodeSize((Node)splitChild).height);
                }
                totalHeight += nodeHeight;
                if (!(splitChild.getWeight() > 0.0)) continue;
                minWeightedHeight += nodeMinHeight;
                totalWeightedHeight += nodeHeight;
            }
            double y = bounds.getY();
            double availableHeight = extraHeight = splitBounds.getHeight() - bounds.getHeight();
            boolean bl = onlyShrinkWeightedComponents = (double)(totalWeightedHeight - minWeightedHeight) > extraHeight;
            while (splitChildren.hasNext()) {
                Rectangle newSplitChildBounds;
                double splitChildWeight;
                Node splitChild = splitChildren.next();
                if (!splitChild.isVisible()) {
                    if (!splitChildren.hasNext()) continue;
                    splitChildren.next();
                    continue;
                }
                Rectangle splitChildBounds = splitChild.getBounds();
                double minSplitChildHeight = 0.0;
                if (this.layoutMode == 2 && !(splitChild instanceof Divider)) {
                    minSplitChildHeight = this.userMinSize;
                } else if (this.layoutMode == 0) {
                    minSplitChildHeight = this.minimumNodeSize(splitChild).getHeight();
                }
                double d = splitChildWeight = onlyShrinkWeightedComponents ? splitChild.getWeight() : splitChildBounds.getHeight() / (double)totalHeight;
                if (!this.hasMoreVisibleSiblings(splitChild)) {
                    double oldHeight = splitChildBounds.getHeight();
                    double newHeight = splitChild instanceof Divider ? (double)this.dividerSize : Math.max(minSplitChildHeight, bounds.getMaxY() - y);
                    newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= oldHeight - splitChild.getBounds().getHeight();
                } else if (availableHeight > 0.0 && splitChildWeight > 0.0) {
                    double newHeight;
                    double oldHeight = splitChildBounds.getHeight();
                    if (splitChild instanceof Divider) {
                        newHeight = this.dividerSize;
                    } else {
                        double allocatedHeight = Math.rint(splitChildWeight * extraHeight);
                        newHeight = Math.max(minSplitChildHeight, oldHeight - allocatedHeight);
                    }
                    newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= oldHeight - splitChild.getBounds().getHeight();
                } else {
                    double existingHeight = splitChildBounds.getHeight();
                    Rectangle newSplitChildBounds3 = this.boundsWithYandHeight(bounds, y, existingHeight);
                    this.layout2(splitChild, newSplitChildBounds3);
                }
                y = splitChild.getBounds().getMaxY();
            }
        }
        this.minimizeSplitBounds(split, bounds);
    }

    private boolean hasMoreVisibleSiblings(Node splitChild) {
        Node next = splitChild.nextSibling();
        if (next == null) {
            return false;
        }
        do {
            if (!next.isVisible()) continue;
            return true;
        } while ((next = next.nextSibling()) != null);
        return false;
    }

    private void layoutGrow(Split split, Rectangle bounds) {
        Rectangle splitBounds = split.getBounds();
        ListIterator<Node> splitChildren = split.getChildren().listIterator();
        Node lastWeightedChild = split.lastWeightedChild();
        if (split.isRowLayout()) {
            double extraWidth;
            double x = bounds.getX();
            double availableWidth = extraWidth = bounds.getWidth() - splitBounds.getWidth();
            while (splitChildren.hasNext()) {
                Rectangle newSplitChildBounds;
                Node splitChild = splitChildren.next();
                if (!splitChild.isVisible()) continue;
                Rectangle splitChildBounds = splitChild.getBounds();
                double splitChildWeight = splitChild.getWeight();
                if (!this.hasMoreVisibleSiblings(splitChild)) {
                    double newWidth = bounds.getMaxX() - x;
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableWidth > 0.0 && splitChildWeight > 0.0) {
                    double allocatedWidth = splitChild.equals(lastWeightedChild) ? availableWidth : Math.rint(splitChildWeight * extraWidth);
                    double newWidth = splitChildBounds.getWidth() + allocatedWidth;
                    Rectangle newSplitChildBounds2 = this.boundsWithXandWidth(bounds, x, newWidth);
                    this.layout2(splitChild, newSplitChildBounds2);
                    availableWidth -= allocatedWidth;
                } else {
                    double existingWidth = splitChildBounds.getWidth();
                    newSplitChildBounds = this.boundsWithXandWidth(bounds, x, existingWidth);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                x = splitChild.getBounds().getMaxX();
            }
        } else {
            double extraHeight;
            double y = bounds.getY();
            double availableHeight = extraHeight = bounds.getHeight() - splitBounds.getHeight();
            while (splitChildren.hasNext()) {
                Node splitChild = splitChildren.next();
                if (!splitChild.isVisible()) continue;
                Rectangle splitChildBounds = splitChild.getBounds();
                double splitChildWeight = splitChild.getWeight();
                if (!splitChildren.hasNext()) {
                    double newHeight = bounds.getMaxY() - y;
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                } else if (availableHeight > 0.0 && splitChildWeight > 0.0) {
                    double allocatedHeight = splitChild.equals(lastWeightedChild) ? availableHeight : Math.rint(splitChildWeight * extraHeight);
                    double newHeight = splitChildBounds.getHeight() + allocatedHeight;
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, newHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                    availableHeight -= allocatedHeight;
                } else {
                    double existingHeight = splitChildBounds.getHeight();
                    Rectangle newSplitChildBounds = this.boundsWithYandHeight(bounds, y, existingHeight);
                    this.layout2(splitChild, newSplitChildBounds);
                }
                y = splitChild.getBounds().getMaxY();
            }
        }
    }

    private void layout2(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            Component child = this.childForNode(root);
            if (child != null) {
                child.setBounds(bounds);
            }
            root.setBounds(bounds);
        } else if (root instanceof Divider) {
            root.setBounds(bounds);
        } else if (root instanceof Split) {
            boolean grow;
            Split split = (Split)root;
            boolean bl = split.isRowLayout() ? split.getBounds().width <= bounds.width : (grow = split.getBounds().height <= bounds.height);
            if (grow) {
                this.layoutGrow(split, bounds);
                root.setBounds(bounds);
            } else {
                this.layoutShrink(split, bounds);
            }
        }
    }

    private void layout1(Node root, Rectangle bounds) {
        if (root instanceof Leaf) {
            root.setBounds(bounds);
        } else if (root instanceof Split) {
            Split split = (Split)root;
            Iterator<Node> splitChildren = split.getChildren().iterator();
            Rectangle childBounds = null;
            int divSize = this.getDividerSize();
            boolean initSplit = false;
            if (split.isRowLayout()) {
                double x = bounds.getX();
                while (splitChildren.hasNext()) {
                    Node splitChild = splitChildren.next();
                    if (!splitChild.isVisible()) {
                        if (!splitChildren.hasNext()) continue;
                        splitChildren.next();
                        continue;
                    }
                    Divider dividerChild = splitChildren.hasNext() ? (Divider)splitChildren.next() : null;
                    double childWidth = 0.0;
                    if (this.getFloatingDividers()) {
                        childWidth = this.preferredNodeSize(splitChild).getWidth();
                    } else if (dividerChild != null && dividerChild.isVisible()) {
                        double cw = dividerChild.getBounds().getX() - x;
                        if (cw > 0.0) {
                            childWidth = cw;
                        } else {
                            childWidth = this.preferredNodeSize(splitChild).getWidth();
                            initSplit = true;
                        }
                    } else {
                        childWidth = split.getBounds().getMaxX() - x;
                    }
                    childBounds = this.boundsWithXandWidth(bounds, x, childWidth);
                    this.layout1(splitChild, childBounds);
                    if ((initSplit || this.getFloatingDividers()) && dividerChild != null && dividerChild.isVisible()) {
                        double dividerX = childBounds.getMaxX();
                        Rectangle dividerBounds = this.boundsWithXandWidth(bounds, dividerX, divSize);
                        dividerChild.setBounds(dividerBounds);
                    }
                    if (dividerChild == null || !dividerChild.isVisible()) continue;
                    x = dividerChild.getBounds().getMaxX();
                }
            } else {
                double y = bounds.getY();
                while (splitChildren.hasNext()) {
                    Node splitChild = splitChildren.next();
                    if (!splitChild.isVisible()) {
                        if (!splitChildren.hasNext()) continue;
                        splitChildren.next();
                        continue;
                    }
                    Divider dividerChild = splitChildren.hasNext() ? (Divider)splitChildren.next() : null;
                    double childHeight = 0.0;
                    if (this.getFloatingDividers()) {
                        childHeight = this.preferredNodeSize(splitChild).getHeight();
                    } else if (dividerChild != null && dividerChild.isVisible()) {
                        double cy = dividerChild.getBounds().getY() - y;
                        if (cy > 0.0) {
                            childHeight = cy;
                        } else {
                            childHeight = this.preferredNodeSize(splitChild).getHeight();
                            initSplit = true;
                        }
                    } else {
                        childHeight = split.getBounds().getMaxY() - y;
                    }
                    childBounds = this.boundsWithYandHeight(bounds, y, childHeight);
                    this.layout1(splitChild, childBounds);
                    if ((initSplit || this.getFloatingDividers()) && dividerChild != null && dividerChild.isVisible()) {
                        double dividerY = childBounds.getMaxY();
                        Rectangle dividerBounds = this.boundsWithYandHeight(bounds, dividerY, divSize);
                        dividerChild.setBounds(dividerBounds);
                    }
                    if (dividerChild == null || !dividerChild.isVisible()) continue;
                    y = dividerChild.getBounds().getMaxY();
                }
            }
            this.minimizeSplitBounds(split, bounds);
        }
    }

    public int getLayoutMode() {
        return this.layoutMode;
    }

    public void setLayoutMode(int layoutMode) {
        this.layoutMode = layoutMode;
    }

    public int getUserMinSize() {
        return this.userMinSize;
    }

    public void setUserMinSize(int minSize) {
        this.userMinSize = minSize;
    }

    public boolean getLayoutByWeight() {
        return this.layoutByWeight;
    }

    public void setLayoutByWeight(boolean state) {
        this.layoutByWeight = state;
    }

    private void throwInvalidLayout(String msg, Node node) {
        throw new InvalidLayoutException(msg, node);
    }

    private void checkLayout(Node root) {
        if (root instanceof Split) {
            Split split = (Split)root;
            if (split.getChildren().size() <= 2) {
                this.throwInvalidLayout("Split must have > 2 children", root);
            }
            Iterator<Node> splitChildren = split.getChildren().iterator();
            double weight = 0.0;
            while (splitChildren.hasNext()) {
                Node dividerChild;
                Node splitChild = splitChildren.next();
                if (!splitChild.isVisible()) {
                    if (!splitChildren.hasNext()) continue;
                    splitChildren.next();
                    continue;
                }
                if (splitChild instanceof Divider) continue;
                if (splitChildren.hasNext() && !((dividerChild = splitChildren.next()) instanceof Divider)) {
                    this.throwInvalidLayout("expected a Divider Node", dividerChild);
                }
                weight += splitChild.getWeight();
                this.checkLayout(splitChild);
            }
            if (weight > 1.0) {
                this.throwInvalidLayout("Split children's total weight > 1.0", root);
            }
        }
    }

    @Override
    public void layoutContainer(Container parent) {
        if (this.layoutByWeight && this.floatingDividers) {
            this.doLayoutByWeight(parent);
        }
        this.checkLayout(this.getModel());
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        int width = size.width - (insets.left + insets.right);
        int height = size.height - (insets.top + insets.bottom);
        Rectangle bounds = new Rectangle(insets.left, insets.top, width, height);
        this.layout1(this.getModel(), bounds);
        this.layout2(this.getModel(), bounds);
    }

    private Divider dividerAt(Node root, int x, int y) {
        if (root instanceof Divider) {
            Divider divider = (Divider)root;
            return divider.getBounds().contains(x, y) ? divider : null;
        }
        if (root instanceof Split) {
            Split split = (Split)root;
            for (Node child : split.getChildren()) {
                if (!child.isVisible() || !child.getBounds().contains(x, y)) continue;
                return this.dividerAt(child, x, y);
            }
        }
        return null;
    }

    public Divider dividerAt(int x, int y) {
        return this.dividerAt(this.getModel(), x, y);
    }

    private boolean nodeOverlapsRectangle(Node node, Rectangle r2) {
        Rectangle r1 = node.getBounds();
        return r1.x <= r2.x + r2.width && r1.x + r1.width >= r2.x && r1.y <= r2.y + r2.height && r1.y + r1.height >= r2.y;
    }

    private List<Divider> dividersThatOverlap(Node root, Rectangle r) {
        if (this.nodeOverlapsRectangle(root, r) && root instanceof Split) {
            ArrayList<Divider> dividers = new ArrayList<Divider>();
            for (Node child : ((Split)root).getChildren()) {
                if (child instanceof Divider) {
                    if (!this.nodeOverlapsRectangle(child, r)) continue;
                    dividers.add((Divider)child);
                    continue;
                }
                if (!(child instanceof Split)) continue;
                dividers.addAll(this.dividersThatOverlap(child, r));
            }
            return dividers;
        }
        return Collections.emptyList();
    }

    public List<Divider> dividersThatOverlap(Rectangle r) {
        if (r == null) {
            throw new IllegalArgumentException("null Rectangle");
        }
        return this.dividersThatOverlap(this.getModel(), r);
    }

    private static void throwParseException(StreamTokenizer st2, String msg) throws Exception {
        throw new Exception("MultiSplitLayout.parseModel Error: " + msg);
    }

    private static void parseAttribute(String name, StreamTokenizer st2, Node node) throws Exception {
        if (st2.nextToken() != 61) {
            MultiSplitLayout.throwParseException(st2, "expected '=' after " + name);
        }
        if (name.equalsIgnoreCase("WEIGHT")) {
            if (st2.nextToken() == -2) {
                node.setWeight(st2.nval);
            } else {
                MultiSplitLayout.throwParseException(st2, "invalid weight");
            }
        } else if (name.equalsIgnoreCase("NAME")) {
            if (st2.nextToken() == -3) {
                if (node instanceof Leaf) {
                    ((Leaf)node).setName(st2.sval);
                } else if (node instanceof Split) {
                    ((Split)node).setName(st2.sval);
                } else {
                    MultiSplitLayout.throwParseException(st2, "can't specify name for " + node);
                }
            } else {
                MultiSplitLayout.throwParseException(st2, "invalid name");
            }
        } else {
            MultiSplitLayout.throwParseException(st2, "unrecognized attribute \"" + name + "\"");
        }
    }

    private static void addSplitChild(Split parent, Node child) {
        ArrayList<Node> children = new ArrayList<Node>(parent.getChildren());
        if (children.size() == 0) {
            children.add(child);
        } else {
            children.add(new Divider());
            children.add(child);
        }
        parent.setChildren(children);
    }

    private static void parseLeaf(StreamTokenizer st2, Split parent) throws Exception {
        int token;
        Leaf leaf = new Leaf();
        while ((token = st2.nextToken()) != -1 && token != 41) {
            if (token == -3) {
                MultiSplitLayout.parseAttribute(st2.sval, st2, leaf);
                continue;
            }
            MultiSplitLayout.throwParseException(st2, "Bad Leaf: " + leaf);
        }
        MultiSplitLayout.addSplitChild(parent, leaf);
    }

    private static void parseSplit(StreamTokenizer st2, Split parent) throws Exception {
        int token;
        while ((token = st2.nextToken()) != -1 && token != 41) {
            String nodeType;
            if (token == -3) {
                if (st2.sval.equalsIgnoreCase("WEIGHT")) {
                    MultiSplitLayout.parseAttribute(st2.sval, st2, parent);
                    continue;
                }
                if (st2.sval.equalsIgnoreCase("NAME")) {
                    MultiSplitLayout.parseAttribute(st2.sval, st2, parent);
                    continue;
                }
                MultiSplitLayout.addSplitChild(parent, new Leaf(st2.sval));
                continue;
            }
            if (token != 40) continue;
            token = st2.nextToken();
            if (token != -3) {
                MultiSplitLayout.throwParseException(st2, "invalid node type");
            }
            if ((nodeType = st2.sval.toUpperCase()).equals("LEAF")) {
                MultiSplitLayout.parseLeaf(st2, parent);
                continue;
            }
            if (nodeType.equals("ROW") || nodeType.equals("COLUMN")) {
                Split split = new Split();
                split.setRowLayout(nodeType.equals("ROW"));
                MultiSplitLayout.addSplitChild(parent, split);
                MultiSplitLayout.parseSplit(st2, split);
                continue;
            }
            MultiSplitLayout.throwParseException(st2, "unrecognized node type '" + nodeType + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node parseModel(Reader r) {
        StreamTokenizer st2 = new StreamTokenizer(r);
        try {
            Split root = new Split();
            MultiSplitLayout.parseSplit(st2, root);
            Node node = root.getChildren().get(0);
            return node;
        }
        catch (Exception e) {
            System.err.println(e);
        }
        finally {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static Node parseModel(String s) {
        return MultiSplitLayout.parseModel(new StringReader(s));
    }

    private static void printModel(String indent, Node root) {
        if (root instanceof Split) {
            Split split = (Split)root;
            System.out.println(indent + split);
            for (Node child : split.getChildren()) {
                MultiSplitLayout.printModel(indent + "  ", child);
            }
        } else {
            System.out.println(indent + root);
        }
    }

    public static void printModel(Node root) {
        MultiSplitLayout.printModel("", root);
    }

    public static class Divider
    extends Node {
        public final boolean isVertical() {
            Split parent = this.getParent();
            return parent != null ? parent.isRowLayout() : false;
        }

        @Override
        public void setWeight(double weight) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "MultiSplitLayout.Divider " + this.getBounds().toString();
        }
    }

    public static class Leaf
    extends Node {
        private String name = "";

        public Leaf() {
        }

        public Leaf(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("MultiSplitLayout.Leaf");
            sb.append(" \"");
            sb.append(this.getName());
            sb.append("\"");
            sb.append(" weight=");
            sb.append(this.getWeight());
            sb.append(" ");
            sb.append(this.getBounds());
            return sb.toString();
        }
    }

    public static class Split
    extends Node {
        private List<Node> children = Collections.emptyList();
        private boolean rowLayout = true;
        private String name;

        public Split(Node ... children) {
            this.setChildren(children);
        }

        public Split() {
        }

        @Override
        public boolean isVisible() {
            for (Node child : this.children) {
                if (!child.isVisible() || child instanceof Divider) continue;
                return true;
            }
            return false;
        }

        public boolean isRowLayout() {
            return this.rowLayout;
        }

        public void setRowLayout(boolean rowLayout) {
            this.rowLayout = rowLayout;
        }

        public List<Node> getChildren() {
            return new ArrayList<Node>(this.children);
        }

        public void remove(Node n) {
            if (n.nextSibling() instanceof Divider) {
                this.children.remove(n.nextSibling());
            } else if (n.previousSibling() instanceof Divider) {
                this.children.remove(n.previousSibling());
            }
            this.children.remove(n);
        }

        public void replace(Node target, Node replacement) {
            int idx = this.children.indexOf(target);
            this.children.remove(target);
            this.children.add(idx, replacement);
            replacement.setParent(this);
            target.setParent(this);
        }

        public void hide(Node target) {
            Node next = target.nextSibling();
            if (next instanceof Divider) {
                next.setVisible(false);
            } else {
                Node prev = target.previousSibling();
                if (prev instanceof Divider) {
                    prev.setVisible(false);
                }
            }
            target.setVisible(false);
        }

        public void checkDividers(Split split) {
            ListIterator<Node> splitChildren = split.getChildren().listIterator();
            while (splitChildren.hasNext()) {
                Node splitChild = splitChildren.next();
                if (!splitChild.isVisible() || !splitChildren.hasNext()) continue;
                Node dividerChild = splitChildren.next();
                if (dividerChild instanceof Divider) {
                    if (!splitChildren.hasNext()) continue;
                    Node rightChild = splitChildren.next();
                    while (!rightChild.isVisible()) {
                        if ((rightChild = rightChild.nextSibling()) != null) continue;
                        dividerChild.setVisible(false);
                        break;
                    }
                    if (rightChild == null || !(rightChild instanceof Divider)) continue;
                    dividerChild.setVisible(false);
                    continue;
                }
                if (!(splitChild instanceof Divider) || !(dividerChild instanceof Divider)) continue;
                splitChild.setVisible(false);
            }
        }

        public void restoreDividers(Split split) {
            boolean nextDividerVisible = false;
            ListIterator<Node> splitChildren = split.getChildren().listIterator();
            block0: while (splitChildren.hasNext()) {
                Node prev;
                Node splitChild = splitChildren.next();
                if (!(splitChild instanceof Divider) || !(prev = splitChild.previousSibling()).isVisible()) continue;
                for (Node next = splitChild.nextSibling(); next != null; next = next.nextSibling()) {
                    if (!next.isVisible()) continue;
                    splitChild.setVisible(true);
                    continue block0;
                }
            }
            if (split.getParent() != null) {
                this.restoreDividers(split.getParent());
            }
        }

        public void setChildren(List<Node> children) {
            if (children == null) {
                throw new IllegalArgumentException("children must be a non-null List");
            }
            for (Node child : this.children) {
                child.setParent(null);
            }
            this.children = new ArrayList<Node>(children);
            for (Node child : this.children) {
                child.setParent(this);
            }
        }

        public void setChildren(Node ... children) {
            this.setChildren(children == null ? null : Arrays.asList(children));
        }

        public final Node lastWeightedChild() {
            List<Node> kids = this.getChildren();
            Node weightedChild = null;
            for (Node child : kids) {
                if (!child.isVisible() || !(child.getWeight() > 0.0)) continue;
                weightedChild = child;
            }
            return weightedChild;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
        }

        public String toString() {
            int nChildren = this.getChildren().size();
            StringBuffer sb = new StringBuffer("MultiSplitLayout.Split");
            sb.append(" \"");
            sb.append(this.getName());
            sb.append("\"");
            sb.append(this.isRowLayout() ? " ROW [" : " COLUMN [");
            sb.append(nChildren + (nChildren == 1 ? " child" : " children"));
            sb.append("] ");
            sb.append(this.getBounds());
            return sb.toString();
        }
    }

    public static class ColSplit
    extends Split {
        public ColSplit() {
        }

        public ColSplit(Node ... children) {
            this.setChildren(children);
        }

        @Override
        public final boolean isRowLayout() {
            return false;
        }
    }

    public static class RowSplit
    extends Split {
        public RowSplit() {
        }

        public RowSplit(Node ... children) {
            this.setChildren(children);
        }

        @Override
        public final boolean isRowLayout() {
            return true;
        }
    }

    public static abstract class Node
    implements Serializable {
        private Split parent = null;
        private Rectangle bounds = new Rectangle();
        private double weight = 0.0;
        private boolean isVisible = true;

        public void setVisible(boolean b) {
            this.isVisible = b;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public Split getParent() {
            return this.parent;
        }

        public void setParent(Split parent) {
            this.parent = parent;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.bounds);
        }

        public void setBounds(Rectangle bounds) {
            if (bounds == null) {
                throw new IllegalArgumentException("null bounds");
            }
            this.bounds = new Rectangle(bounds);
        }

        public double getWeight() {
            return this.weight;
        }

        public void setWeight(double weight) {
            if (weight < 0.0 || weight > 1.0) {
                throw new IllegalArgumentException("invalid weight");
            }
            this.weight = weight;
        }

        private Node siblingAtOffset(int offset) {
            Split p = this.getParent();
            if (p == null) {
                return null;
            }
            List<Node> siblings = p.getChildren();
            int index = siblings.indexOf(this);
            if (index == -1) {
                return null;
            }
            return (index += offset) > -1 && index < siblings.size() ? siblings.get(index) : null;
        }

        public Node nextSibling() {
            return this.siblingAtOffset(1);
        }

        public Node previousSibling() {
            return this.siblingAtOffset(-1);
        }
    }

    public static class InvalidLayoutException
    extends RuntimeException {
        private final Node node;

        public InvalidLayoutException(String msg, Node node) {
            super(msg);
            this.node = node;
        }

        public Node getNode() {
            return this.node;
        }
    }
}

