/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.compare;

import java.util.function.Predicate;

public class ComparableUtils {
    public static <A extends Comparable<A>> Predicate<A> between(A b, A c2) {
        return a -> ComparableUtils.is(a).between(b, c2);
    }

    public static <A extends Comparable<A>> Predicate<A> betweenExclusive(A b, A c2) {
        return a -> ComparableUtils.is(a).betweenExclusive(b, c2);
    }

    public static <A extends Comparable<A>> Predicate<A> ge(A b) {
        return a -> ComparableUtils.is(a).greaterThanOrEqualTo(b);
    }

    public static <A extends Comparable<A>> Predicate<A> gt(A b) {
        return a -> ComparableUtils.is(a).greaterThan(b);
    }

    public static <A extends Comparable<A>> ComparableCheckBuilder<A> is(A a) {
        return new ComparableCheckBuilder(a, null);
    }

    public static <A extends Comparable<A>> Predicate<A> le(A b) {
        return a -> ComparableUtils.is(a).lessThanOrEqualTo(b);
    }

    public static <A extends Comparable<A>> Predicate<A> lt(A b) {
        return a -> ComparableUtils.is(a).lessThan(b);
    }

    private ComparableUtils() {
    }

    public static class ComparableCheckBuilder<A extends Comparable<A>> {
        private final A a;

        private ComparableCheckBuilder(A a) {
            this.a = a;
        }

        public boolean between(A b, A c2) {
            return this.betweenOrdered(b, c2) || this.betweenOrdered(c2, b);
        }

        public boolean betweenExclusive(A b, A c2) {
            return this.betweenOrderedExclusive(b, c2) || this.betweenOrderedExclusive(c2, b);
        }

        private boolean betweenOrdered(A b, A c2) {
            return this.greaterThanOrEqualTo(b) && this.lessThanOrEqualTo(c2);
        }

        private boolean betweenOrderedExclusive(A b, A c2) {
            return this.greaterThan(b) && this.lessThan(c2);
        }

        public boolean equalTo(A b) {
            return this.a.compareTo(b) == 0;
        }

        public boolean greaterThan(A b) {
            return this.a.compareTo(b) > 0;
        }

        public boolean greaterThanOrEqualTo(A b) {
            return this.a.compareTo(b) >= 0;
        }

        public boolean lessThan(A b) {
            return this.a.compareTo(b) < 0;
        }

        public boolean lessThanOrEqualTo(A b) {
            return this.a.compareTo(b) <= 0;
        }

        /* synthetic */ ComparableCheckBuilder(Comparable x0, 1 x1) {
            this(x0);
        }
    }
}

