/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.AbstractKeyedHandler;
import org.apache.commons.dbutils.handlers.ArrayHandler;

public class KeyedHandler<K>
extends AbstractKeyedHandler<K, Map<String, Object>> {
    protected final RowProcessor convert;
    protected final int columnIndex;
    protected final String columnName;

    public KeyedHandler() {
        this(ArrayHandler.ROW_PROCESSOR, 1, null);
    }

    public KeyedHandler(RowProcessor convert) {
        this(convert, 1, null);
    }

    public KeyedHandler(int columnIndex) {
        this(ArrayHandler.ROW_PROCESSOR, columnIndex, null);
    }

    public KeyedHandler(String columnName) {
        this(ArrayHandler.ROW_PROCESSOR, 1, columnName);
    }

    private KeyedHandler(RowProcessor convert, int columnIndex, String columnName) {
        this.convert = convert;
        this.columnIndex = columnIndex;
        this.columnName = columnName;
    }

    @Override
    protected K createKey(ResultSet rs2) throws SQLException {
        return (K)(this.columnName == null ? rs2.getObject(this.columnIndex) : rs2.getObject(this.columnName));
    }

    @Override
    protected Map<String, Object> createRow(ResultSet rs2) throws SQLException {
        return this.convert.toMap(rs2);
    }
}

