/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.path;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.path.Path;

public class ObjectFieldPath
implements Path {
    public final String key;
    private final Path parent;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static ObjectFieldPath chainIfNotNull(Path parent, String key) {
        if (parent == null) {
            return null;
        }
        return new ObjectFieldPath(parent, key);
    }

    public ObjectFieldPath(Path parent, String key) {
        if (parent == null) {
            throw new NullPointerException("parent must not be null");
        }
        this.parent = parent;
        this.key = key;
    }

    @Override
    public void toJsonNode(ArrayNode out) throws JsonQueryException {
        this.parent.toJsonNode(out);
        out.add(new TextNode(this.key));
    }

    @Override
    public void get(JsonNode in, Path ipath, PathOutput output, boolean permissive) throws JsonQueryException {
        this.parent.get(in, ipath, (parent, ppath) -> ObjectFieldPath.resolve(parent, ppath, output, this.key, permissive), permissive);
    }

    @Override
    public JsonNode mutate(JsonNode in, Path.Mutation mutation, boolean makeParent) throws JsonQueryException {
        return this.parent.mutate(in, oldval -> ObjectFieldPath.mutate(oldval, this.key, mutation, makeParent), makeParent);
    }

    private static JsonNode mutate(JsonNode in, String key, Path.Mutation mutation, boolean makeParent) throws JsonQueryException {
        if (in == null || in.isNull()) {
            if (!makeParent) {
                return in;
            }
            in = MAPPER.createObjectNode();
        }
        if (in.isObject()) {
            ObjectNode newobj = MAPPER.createObjectNode();
            Iterator<Map.Entry<String, JsonNode>> iter = in.fields();
            while (iter.hasNext()) {
                Map.Entry<String, JsonNode> entry = iter.next();
                newobj.set(entry.getKey(), entry.getValue());
            }
            JsonNode newval = mutation.apply(newobj.get(key));
            if (newval != null) {
                newobj.set(key, newval);
            }
            return newobj;
        }
        throw new JsonQueryException(String.format("Cannot index %s with string \"%s\"", JsonNodeUtils.typeOf(in), key));
    }

    public static void resolve(JsonNode pobj, Path ppath, PathOutput output, String key, boolean permissive) throws JsonQueryException {
        if (pobj.isNull()) {
            output.emit(NullNode.getInstance(), ObjectFieldPath.chainIfNotNull(ppath, key));
        } else if (pobj.isObject()) {
            JsonNode n = pobj.get(key);
            output.emit(n == null ? NullNode.getInstance() : n, ObjectFieldPath.chainIfNotNull(ppath, key));
        } else if (!permissive) {
            throw new JsonQueryException(String.format("Cannot index %s with string \"%s\"", JsonNodeUtils.typeOf(pobj), key));
        }
    }
}

