/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.path.Path;

public class VariableAccess
implements Expression {
    private final String name;
    private final String moduleName;

    public VariableAccess(String moduleName, String name) {
        this.moduleName = moduleName;
        this.name = name;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path path, PathOutput output, boolean requirePath) throws JsonQueryException {
        JsonNode data;
        if (this.moduleName != null) {
            data = null;
            if (this.moduleName.equals(this.name)) {
                data = scope.getImportedData(this.name);
            }
            if (data == null) {
                throw new JsonQueryException(String.format("$%s::%s is not defined", this.moduleName, this.name));
            }
        } else {
            Scope.ValueWithPath value = scope.getValueWithPath(this.name);
            if (value != null) {
                output.emit(value.value(), null);
                return;
            }
            JsonNode data2 = scope.getImportedData(this.name);
            if (data2 != null) {
                output.emit(data2, null);
                return;
            }
            throw new JsonQueryException(String.format("$%s is not defined", this.name));
        }
        output.emit(data, null);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('$');
        if (this.moduleName != null) {
            s.append(this.moduleName);
            s.append("::");
        }
        s.append(this.name);
        return s.toString();
    }
}

