/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Stack;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryBreakException;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.AssignPipeComponent;
import net.thisptr.jackson.jq.internal.tree.LabelPipeComponent;
import net.thisptr.jackson.jq.internal.tree.PipeComponent;
import net.thisptr.jackson.jq.internal.tree.TransformPipeComponent;
import net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;
import net.thisptr.jackson.jq.path.Path;

public class PipedQuery
implements Expression {
    private List<PipeComponent> components;

    public PipedQuery(List<PipeComponent> components) {
        this.components = components;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path path, PathOutput output, boolean requirePath) throws JsonQueryException {
        PipedQuery.pathRecursive(scope, in, path, output, this.components, requirePath);
    }

    private static void pathRecursive(Scope scope, JsonNode in, Path path, PathOutput output, List<PipeComponent> components, boolean requirePath) throws JsonQueryException {
        if (components.isEmpty()) {
            output.emit(in, path);
            return;
        }
        PipeComponent head = components.get(0);
        List<PipeComponent> tail = components.subList(1, components.size());
        if (head instanceof AssignPipeComponent) {
            Scope childScope = Scope.newChildScope(scope);
            ((AssignPipeComponent)head).expr.apply(scope, in, o -> {
                Stack<PatternMatcher.MatchWithPath> accumulate = new Stack<PatternMatcher.MatchWithPath>();
                ((AssignPipeComponent)head).matcher.matchWithPath(scope, o, path, vars -> {
                    for (int i = vars.size() - 1; i >= 0; --i) {
                        PatternMatcher.MatchWithPath var2 = (PatternMatcher.MatchWithPath)vars.get(i);
                        childScope.setValueWithPath(var2.name, var2.value, var2.path);
                    }
                    PipedQuery.pathRecursive(childScope, in, path, output, tail, requirePath);
                }, accumulate);
            });
        } else if (head instanceof TransformPipeComponent) {
            ((TransformPipeComponent)head).expr.apply(scope, in, path, (pobj, ppath) -> PipedQuery.pathRecursive(scope, pobj, ppath, output, tail, requirePath), requirePath);
        } else if (head instanceof LabelPipeComponent) {
            try {
                PipedQuery.pathRecursive(scope, in, path, output, tail, requirePath);
            }
            catch (JsonQueryBreakException e) {
                if (((LabelPipeComponent)head).name.equals(e.name())) {
                    return;
                }
                throw e;
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("(");
        String sep = "";
        for (PipeComponent component : this.components) {
            builder.append(sep);
            builder.append(component.toString());
            sep = " | ";
        }
        builder.append(")");
        return builder.toString();
    }
}

