/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Stack;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;
import net.thisptr.jackson.jq.path.Path;

public class ForeachExpression
implements Expression {
    private Expression iterExpr;
    private Expression updateExpr;
    private Expression initExpr;
    private Expression extractExpr;
    private PatternMatcher matcher;

    public ForeachExpression(PatternMatcher matcher, Expression initExpr, Expression updateExpr, Expression extractExpr, Expression iterExpr) {
        this.matcher = matcher;
        this.initExpr = initExpr;
        this.updateExpr = updateExpr;
        this.extractExpr = extractExpr;
        this.iterExpr = iterExpr;
    }

    @Override
    public void apply(Scope scope, JsonNode in, Path ipath, PathOutput output, boolean requirePath) throws JsonQueryException {
        this.initExpr.apply(scope, in, ipath, (accumulator, accumulatorPath) -> {
            JsonNode[] accumulators = new JsonNode[]{accumulator};
            Path[] accumulatorPaths = new Path[]{accumulatorPath};
            Scope childScope = Scope.newChildScope(scope);
            this.iterExpr.apply(scope, in, ipath, (item, itemPath) -> {
                Stack<PatternMatcher.MatchWithPath> stack = new Stack<PatternMatcher.MatchWithPath>();
                this.matcher.matchWithPath(scope, item, itemPath, vars -> {
                    for (int i = vars.size() - 1; i >= 0; --i) {
                        PatternMatcher.MatchWithPath var2 = (PatternMatcher.MatchWithPath)vars.get(i);
                        childScope.setValueWithPath(var2.name, var2.value, var2.path);
                    }
                    this.updateExpr.apply(childScope, accumulators[0], accumulatorPaths[0], (newaccumulator, newaccumulatorPath) -> {
                        if (this.extractExpr != null) {
                            this.extractExpr.apply(childScope, newaccumulator, newaccumulatorPath, output, requirePath);
                        } else {
                            output.emit(newaccumulator, newaccumulatorPath);
                        }
                        accumulators[0] = newaccumulator;
                        accumulatorPaths[0] = newaccumulatorPath;
                    }, this.extractExpr != null ? false : requirePath);
                }, stack);
            }, requirePath);
        }, false);
    }

    public String toString() {
        if (this.extractExpr == null) {
            return String.format("(foreach %s as %s (%s; %s))", this.iterExpr, this.matcher, this.initExpr, this.updateExpr);
        }
        return String.format("(foreach %s as %s (%s; %s; %s))", this.iterExpr, this.matcher, this.initExpr, this.updateExpr, this.extractExpr);
    }
}

