/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.misc;

import com.fasterxml.jackson.databind.JsonNode;

public class Range {
    public final long start;
    public final long end;

    public Range(long start, long end) {
        this.start = start;
        this.end = end;
    }

    private static double resolveToPositiveIndex(JsonNode value, long size) {
        double index = value.asDouble();
        if (index < 0.0) {
            return index + (double)size;
        }
        return index;
    }

    public static Range resolve(JsonNode startNode, JsonNode endNode, long size) {
        double end;
        assert (startNode.isNull() || startNode.isNumber());
        assert (endNode.isNull() || endNode.isNumber());
        double start = startNode.isNumber() ? Range.resolveToPositiveIndex(startNode, size) : 0.0;
        double d = end = endNode.isNumber() ? Range.resolveToPositiveIndex(endNode, size) : (double)size;
        if (start >= (double)size) {
            return new Range(size, size);
        }
        if (start < 0.0) {
            start = 0.0;
        }
        if (end > (double)size) {
            end = size;
        }
        if (start > end) {
            return new Range((long)start, (long)start);
        }
        return new Range((long)start, (long)Math.ceil(end));
    }
}

