/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.node.TextNode;
import com.google.auto.service.AutoService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import net.thisptr.jackson.jq.BuiltinFunction;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.functions.AbstractAtFormattingFunction;

@BuiltinFunction(value={"@base64d/0"}, version="[1.6, )")
@AutoService(value={Function.class})
public class AtBase64dFunction
extends AbstractAtFormattingFunction {
    @Override
    public String convert(String text) throws JsonQueryException {
        try {
            return new String(Base64.getDecoder().decode(text), StandardCharsets.UTF_8);
        }
        catch (Throwable th) {
            throw new JsonQueryException("%s is not valid base64 data: %s", TextNode.valueOf(text), th.getMessage());
        }
    }
}

