/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.internal.misc.JsonQueryJacksonModule;
import net.thisptr.jackson.jq.internal.module.loaders.NullModuleLoader;
import net.thisptr.jackson.jq.module.Module;
import net.thisptr.jackson.jq.module.ModuleLoader;
import net.thisptr.jackson.jq.path.Path;

public class Scope {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper().registerModule(JsonQueryJacksonModule.getInstance());
    @JsonProperty(value="parent")
    private Scope parentScope;
    @JsonIgnore
    private Map<String, Function> functions;
    @JsonIgnore
    private Map<String, LinkedList<Module>> importedModules;
    @JsonIgnore
    private Map<String, JsonNode> importedData;
    @JsonIgnore
    private ModuleLoader moduleLoader;
    @JsonProperty(value="variables")
    private Map<String, ValueWithPath> values;
    @JsonIgnore
    private ObjectMapper mapper = DEFAULT_MAPPER;
    private Module currentModule;

    @JsonProperty(value="functions")
    private Map<String, String> debugFunctions() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry<String, Function> f : this.functions.entrySet()) {
            result.put(f.getKey(), f.getValue().toString());
        }
        return result;
    }

    private Scope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public static Scope newEmptyScope() {
        return new Scope(null);
    }

    public static Scope newChildScope(Scope scope) {
        return new Scope(scope);
    }

    public void addFunction(String name, int n, Function q) {
        this.addFunction(name + "/" + n, q);
    }

    public void addFunction(String name, Function q) {
        if (this.functions == null) {
            this.functions = new HashMap<String, Function>();
        }
        this.functions.put(name, q);
    }

    public Function getFunction(String name, int nargs) {
        Function f = this.getFunctionRecursive(name + "/" + nargs);
        if (f != null) {
            return f;
        }
        return this.getFunctionRecursive(name);
    }

    public Map<String, Function> getLocalFunctions() {
        if (this.functions == null) {
            return new HashMap<String, Function>();
        }
        return new HashMap<String, Function>(this.functions);
    }

    public Scope getParentScope() {
        return this.parentScope;
    }

    private Function getFunctionRecursive(String name) {
        Function q;
        if (this.functions != null && (q = this.functions.get(name)) != null) {
            return q;
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getFunctionRecursive(name);
    }

    public void setValue(String name, JsonNode value) {
        this.setValueWithPath(name, value, null);
    }

    public void setValueWithPath(String name, JsonNode value, Path path) {
        if (this.values == null) {
            this.values = new HashMap<String, ValueWithPath>();
        }
        this.values.put(name, new ValueWithPathImpl(value, path));
    }

    public ValueWithPath getValueWithPath(String name) {
        ValueWithPath value;
        if (this.values != null && (value = this.values.get(name)) != null) {
            return value;
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getValueWithPath(name);
    }

    public JsonNode getValue(String name) {
        ValueWithPath value = this.getValueWithPath(name);
        if (value == null) {
            return null;
        }
        return value.value();
    }

    @JsonIgnore
    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }

    public void setImportedData(String name, JsonNode data) {
        if (this.importedData == null) {
            this.importedData = new HashMap<String, JsonNode>();
        }
        this.importedData.put(name, data);
    }

    public JsonNode getImportedData(String name) {
        JsonNode data;
        if (this.importedData != null && (data = this.importedData.get(name)) != null) {
            return data;
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getImportedData(name);
    }

    public void addImportedModule(String name, Module module) {
        if (this.importedModules == null) {
            this.importedModules = new HashMap<String, LinkedList<Module>>();
        }
        this.importedModules.computeIfAbsent(name, dummy -> new LinkedList()).addFirst(module);
    }

    public List<Module> getImportedModules(String name) {
        ArrayList<Module> modules = new ArrayList<Module>();
        this.getImportedModules(modules, name);
        return modules;
    }

    private void getImportedModules(List<Module> modules, String name) {
        List localModules;
        if (this.importedModules != null && (localModules = (List)this.importedModules.get(name)) != null) {
            modules.addAll(localModules);
        }
        if (this.parentScope == null) {
            return;
        }
        this.parentScope.getImportedModules(modules, name);
    }

    public void setModuleLoader(ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
    }

    public ModuleLoader getModuleLoader() {
        if (this.moduleLoader != null) {
            return this.moduleLoader;
        }
        if (this.parentScope == null) {
            return NullModuleLoader.getInstance();
        }
        return this.parentScope.getModuleLoader();
    }

    public Module getCurrentModule() {
        if (this.currentModule != null) {
            return this.currentModule;
        }
        if (this.parentScope == null) {
            return null;
        }
        return this.parentScope.getCurrentModule();
    }

    public void setCurrentModule(Module module) {
        this.currentModule = module;
    }

    private static class ValueWithPathImpl
    implements ValueWithPath {
        @JsonProperty(value="value")
        private final JsonNode value;
        @JsonProperty(value="path")
        private final Path path;

        public ValueWithPathImpl(JsonNode value, Path path) {
            this.value = value;
            this.path = path;
        }

        @Override
        public JsonNode value() {
            return this.value;
        }

        @Override
        public Path path() {
            return this.path;
        }
    }

    public static interface ValueWithPath {
        public JsonNode value();

        public Path path();
    }
}

