/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.swing.provider;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.tree.TreeNode;
import net.sf.jtreemap.swing.ColorProvider;
import net.sf.jtreemap.swing.DefaultValue;
import net.sf.jtreemap.swing.JTreeMap;
import net.sf.jtreemap.swing.TreeMapNode;
import net.sf.jtreemap.swing.Value;

public class HSBTreeMapColorProvider
extends ColorProvider {
    private static final int HSBVAL_SIZE = 3;
    private static final long serialVersionUID = 5009655580804320847L;
    private JTreeMap jTreeMap;
    private JPanel legend;
    private Value maxValue;
    private Value minValue;
    private float positiveHue;
    private float negativeHue;
    private float positiveSaturation = 1.0f;
    private float negativeSaturation = 1.0f;
    private ColorDistributionTypes colorDistribution = ColorDistributionTypes.Linear;

    public HSBTreeMapColorProvider(JTreeMap treeMap, Color color) {
        this(treeMap, ColorDistributionTypes.Linear, color, color);
    }

    public HSBTreeMapColorProvider(JTreeMap treeMap, ColorDistributionTypes colorDistribution, Color color) {
        this(treeMap, colorDistribution, color, color);
    }

    public HSBTreeMapColorProvider(JTreeMap treeMap, Color positiveColor, Color negativeColor) {
        this(treeMap, ColorDistributionTypes.Linear, positiveColor, negativeColor);
    }

    public HSBTreeMapColorProvider(JTreeMap treeMap, ColorDistributionTypes colorDistribution, Color positiveColor, Color negativeColor) {
        this.jTreeMap = treeMap;
        this.colorDistribution = colorDistribution;
        this.adjustColor(positiveColor, negativeColor);
    }

    public HSBTreeMapColorProvider(JTreeMap treeMap, float hue, float saturation) {
        this(treeMap, ColorDistributionTypes.Linear, hue, saturation, hue, saturation);
    }

    public HSBTreeMapColorProvider(JTreeMap treeMap, ColorDistributionTypes colorDistribution, float hue, float saturation) {
        this(treeMap, colorDistribution, hue, saturation, hue, saturation);
    }

    public HSBTreeMapColorProvider(JTreeMap treeMap, float positiveHue, float positiveSaturation, float negativeHue, float negativeSaturation) {
        this(treeMap, ColorDistributionTypes.Linear, positiveHue, positiveSaturation, negativeHue, negativeSaturation);
    }

    public HSBTreeMapColorProvider(JTreeMap treeMap, ColorDistributionTypes colorDistribution, float positiveHue, float positiveSaturation, float negativeHue, float negativeSaturation) {
        this.jTreeMap = treeMap;
        this.colorDistribution = colorDistribution;
        this.adjustColor(positiveHue, positiveSaturation, negativeHue, negativeSaturation);
    }

    public JPanel getLegendPanel() {
        if (this.legend == null) {
            this.legend = new Legend();
        }
        return this.legend;
    }

    public void adjustColor(Color color) {
        this.adjustColor(color, color);
    }

    public void adjustColor(Color positiveColor, Color negativeColor) {
        float[] hsbvals = new float[3];
        hsbvals = Color.RGBtoHSB(positiveColor.getRed(), positiveColor.getGreen(), positiveColor.getBlue(), hsbvals);
        this.positiveHue = hsbvals[0];
        this.positiveSaturation = 1.0f;
        hsbvals = Color.RGBtoHSB(negativeColor.getRed(), negativeColor.getGreen(), negativeColor.getBlue(), hsbvals);
        this.negativeHue = hsbvals[0];
        this.negativeSaturation = 1.0f;
    }

    public void adjustColor(float hue, float saturation) {
        this.adjustColor(hue, saturation, hue, saturation);
    }

    public void adjustColor(float posHue, float posSaturation, float negHue, float negSaturation) {
        this.positiveHue = posHue;
        this.positiveSaturation = posSaturation;
        this.negativeHue = negHue;
        this.negativeSaturation = negSaturation;
    }

    public Color getColor(Value value) {
        double val2;
        if (this.maxValue == null || this.minValue == null) {
            this.setValues(this.jTreeMap.getRoot());
        }
        double max = this.maxValue.getValue();
        double min = this.minValue.getValue();
        double d = val2 = value != null ? value.getValue() : 0.0;
        if (val2 >= 0.0) {
            double range = max - Math.max(0.0, min);
            range = this.adjustValue(range);
            return Color.getHSBColor(this.positiveHue, this.positiveSaturation, (float)(this.adjustValue(val2 -= Math.max(0.0, min)) / range));
        }
        double range = Math.abs(min - Math.min(0.0, max));
        val2 += Math.min(0.0, max);
        val2 = Math.abs(val2);
        range = this.adjustValue(range);
        return Color.getHSBColor(this.negativeHue, this.negativeSaturation, (float)(this.adjustValue(val2) / range));
    }

    private double adjustValue(double value) {
        double ret = value;
        switch (this.colorDistribution) {
            case Log: {
                ret = Math.log1p(value);
                break;
            }
            case Exp: {
                ret = Math.exp(value);
                break;
            }
            case SquareRoot: {
                ret = Math.sqrt(value);
                break;
            }
            case CubicRoot: {
                ret = Math.cbrt(value);
                break;
            }
            default: {
                ret = value;
            }
        }
        return ret;
    }

    private void setValues(TreeMapNode root) {
        if (root.isLeaf()) {
            Class<?> c2;
            Value value = root.getValue();
            if (value == null) {
                return;
            }
            if (this.maxValue == null || value.getValue() >= this.maxValue.getValue()) {
                try {
                    c2 = value.getClass();
                    if (this.maxValue == null) {
                        this.maxValue = (Value)c2.newInstance();
                    }
                    this.maxValue.setValue(value.getValue());
                }
                catch (IllegalAccessException iae) {
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                }
            }
            if (this.minValue == null || value.getValue() <= this.minValue.getValue()) {
                try {
                    c2 = value.getClass();
                    if (this.minValue == null) {
                        this.minValue = (Value)c2.newInstance();
                    }
                    this.minValue.setValue(value.getValue());
                }
                catch (IllegalAccessException iae) {
                }
                catch (InstantiationException ie) {
                    ie.printStackTrace();
                }
            }
        } else {
            Enumeration<TreeNode> e = root.children();
            while (e.hasMoreElements()) {
                TreeMapNode node = (TreeMapNode)e.nextElement();
                this.setValues(node);
            }
        }
    }

    private class Legend
    extends JPanel {
        private static final int Y_INSET = 7;
        private static final int X_INSET = 15;
        private static final long serialVersionUID = 6371342387871103592L;
        private static final int HEIGHT = 20;
        private static final int WIDTH = 120;
        private static final int X = 20;
        private static final int Y = 25;

        public Legend() {
            this.setSize(new Dimension(160, 70));
            this.setPreferredSize(new Dimension(160, 70));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (HSBTreeMapColorProvider.this.minValue == null || HSBTreeMapColorProvider.this.maxValue == null) {
                HSBTreeMapColorProvider.this.setValues(HSBTreeMapColorProvider.this.jTreeMap.getRoot());
            }
            Value min = HSBTreeMapColorProvider.this.minValue;
            Value max = HSBTreeMapColorProvider.this.maxValue;
            g.setColor(Color.black);
            if (min != null && max != null) {
                g.drawString(min.getLabel(), 5, 18);
                g.drawString(max.getLabel(), 125, 18);
                double step = (max.getValue() - min.getValue()) / 120.0;
                DefaultValue value = new DefaultValue(min.getValue());
                for (int i = 0; i < 120; ++i) {
                    g.setColor(HSBTreeMapColorProvider.this.getColor(value));
                    g.fillRect(20 + i, 25, 1, 20);
                    ((Value)value).setValue(((Value)value).getValue() + step);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColorDistributionTypes {
        Linear,
        Log,
        Exp,
        SquareRoot,
        CubicRoot;

    }
}

