/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.swing.example;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.tree.TreeNode;
import net.sf.jtreemap.swing.DefaultValue;
import net.sf.jtreemap.swing.TreeMapNode;
import net.sf.jtreemap.swing.TreeMapNodeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderTM3
implements Serializable {
    private static final long serialVersionUID = -991159075093937695L;
    public static final String DATE = "DATE";
    public static final String FLOAT = "FLOAT";
    public static final String INTEGER = "INTEGER";
    public static final String STRING = "STRING";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy");
    private static final LinkedList<String> FIELD_NAMES = new LinkedList();
    private static final LinkedList<String> FIELD_TYPES = new LinkedList();
    private final HashMap<TreeMapNode, HashMap<String, Object>> values = new HashMap();
    private TreeMapNodeBuilder builder = new TreeMapNodeBuilder();

    public BuilderTM3(File tm3File) throws IOException {
        this.parse(new BufferedReader(new FileReader(tm3File)));
    }

    public BuilderTM3(BufferedReader reader) throws IOException {
        this.parse(reader);
    }

    public String[] getNumberFields() {
        TreeSet<String> result = new TreeSet<String>();
        for (int i = 0; i < FIELD_NAMES.size(); ++i) {
            String type = FIELD_TYPES.get(i);
            if (!INTEGER.equals(type) && !FLOAT.equals(type)) continue;
            result.add(FIELD_NAMES.get(i));
        }
        return result.toArray(new String[1]);
    }

    public TreeMapNode getRoot() {
        return this.builder.getRoot();
    }

    public void setValues(String fieldName) {
        if ("".equals(fieldName)) {
            for (TreeMapNode node : this.values.keySet()) {
                node.setValue(new DefaultValue(0.0));
            }
        } else {
            for (TreeMapNode node : this.values.keySet()) {
                HashMap<String, Object> mapNodeValues = this.values.get(node);
                Object value = mapNodeValues.get(fieldName);
                if (value instanceof Number) {
                    Number number = (Number)value;
                    node.setValue(new DefaultValue(number.doubleValue()));
                    continue;
                }
                if (!(value instanceof Date)) continue;
                Date date = (Date)value;
                node.setValue(new DefaultValue(date.getTime()));
            }
        }
    }

    public void setWeights(String fieldName) {
        if ("".equals(fieldName)) {
            for (TreeMapNode node : this.values.keySet()) {
                node.setWeight(1.0);
            }
        } else {
            for (TreeMapNode node : this.values.keySet()) {
                HashMap<String, Object> mapNodeValues = this.values.get(node);
                Object value = mapNodeValues.get(fieldName);
                if (value instanceof Number) {
                    Number number = (Number)value;
                    node.setWeight(number.doubleValue());
                    continue;
                }
                if (!(value instanceof Date)) continue;
                Date date = (Date)value;
                node.setWeight(date.getTime());
            }
        }
    }

    private void createNodes(StringTokenizer st2, HashMap<String, Object> mapNodeValues) {
        LinkedList<String> hierarchyPath = new LinkedList<String>();
        while (st2.hasMoreTokens()) {
            hierarchyPath.add(st2.nextToken());
        }
        TreeMapNode node = this.builder.getRoot();
        if (node == null) {
            node = this.builder.buildBranch((String)hierarchyPath.get(0), null);
        }
        for (int i = 1; i < hierarchyPath.size() - 1; ++i) {
            boolean found = false;
            TreeMapNode child = null;
            Enumeration<TreeNode> iter = node.children();
            while (iter.hasMoreElements()) {
                child = (TreeMapNode)iter.nextElement();
                if (!child.getLabel().equals(hierarchyPath.get(i))) continue;
                found = true;
                break;
            }
            node = found ? child : this.builder.buildBranch((String)hierarchyPath.get(i), node);
        }
        TreeMapNode leaf = this.builder.buildLeaf((String)hierarchyPath.getLast(), 1.0, new DefaultValue(), node);
        this.values.put(leaf, mapNodeValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(BufferedReader reader) throws IOException {
        try {
            String line = "";
            line = reader.readLine();
            StringTokenizer st2 = new StringTokenizer(line, "\t");
            FIELD_NAMES.clear();
            while (st2.hasMoreTokens()) {
                FIELD_NAMES.add(st2.nextToken());
            }
            line = reader.readLine();
            st2 = new StringTokenizer(line, "\t");
            FIELD_TYPES.clear();
            while (st2.hasMoreTokens()) {
                FIELD_TYPES.add(st2.nextToken());
            }
            this.values.clear();
            while ((line = reader.readLine()) != null) {
                st2 = new StringTokenizer(line, "\t");
                HashMap<String, Object> mapNodeValues = new HashMap<String, Object>();
                for (int i = 0; i < FIELD_NAMES.size(); ++i) {
                    Object value;
                    if (FLOAT.equals(FIELD_TYPES.get(i))) {
                        value = new Double(Double.parseDouble(st2.nextToken()));
                    } else if (INTEGER.equals(FIELD_TYPES.get(i))) {
                        value = new Integer(Integer.parseInt(st2.nextToken()));
                    } else if (DATE.equals(FIELD_TYPES.get(i))) {
                        try {
                            value = DATE_FORMAT.parse(st2.nextToken());
                        }
                        catch (ParseException e) {
                            value = null;
                        }
                    } else {
                        value = st2.nextToken();
                    }
                    mapNodeValues.put(FIELD_NAMES.get(i), value);
                }
                if (!st2.hasMoreTokens()) {
                    throw new IOException("the file didn't contains the hierarchy path");
                }
                this.createNodes(st2, mapNodeValues);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

