/*
 * Decompiled with CFR 0.152.
 */
package kx;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.timestored.qstudio.kdb.KdbHelper;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DecimalFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.UUID;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class c
implements AutoCloseable {
    private static String encoding = "ISO-8859-1";
    protected int sync = 0;
    public static final LocalTime LOCAL_TIME_NULL = LocalTime.ofNanoOfDay(1L);
    public Socket s;
    protected DataInputStream inStream;
    protected OutputStream outStream;
    protected byte[] rBuff;
    protected int rBuffPos;
    byte[] wBuff;
    int wBuffPos;
    int ipcVersion;
    protected boolean isLittleEndian;
    boolean isLoopback;
    boolean zip;
    public String host;
    public int port;
    private static final char[][] FUNC_1;
    private static final char[][] FUNC_2;
    private static final String[] ADVERBS;
    static int ni;
    static long nj;
    static double nf;
    static final int DAYS_BETWEEN_1970_2000 = 10957;
    static final long MILLS_IN_DAY = 86400000L;
    static final long MILLS_BETWEEN_1970_2000 = 946684800000L;
    static final long NANOS_IN_SEC = 1000000000L;
    static int[] nt;
    private MsgHandler msgHandler = null;
    private boolean collectResponseAsync;
    public static final Object[] NULL;

    public static void setEncoding(String encoding) throws UnsupportedEncodingException {
        c.encoding = encoding;
    }

    private static char[][] toChars(String[] monadics) {
        char[][] a = new char[monadics.length][];
        for (int i = 0; i < a.length; ++i) {
            a[i] = monadics[i] == null ? null : monadics[i].toCharArray();
        }
        return a;
    }

    public void zip(boolean b) {
        this.zip = b;
    }

    void io(Socket x) throws IOException {
        this.s = x;
        this.s.setTcpNoDelay(true);
        InetAddress addr = this.s.getInetAddress();
        this.isLoopback = addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        this.inStream = new DataInputStream(this.s.getInputStream());
        this.outStream = this.s.getOutputStream();
        this.s.setKeepAlive(true);
    }

    @Override
    public void close() throws IOException {
        if (null != this.s) {
            this.s.close();
            this.s = null;
        }
        if (null != this.inStream) {
            this.inStream.close();
            this.inStream = null;
        }
        if (null != this.outStream) {
            this.outStream.close();
            this.outStream = null;
        }
    }

    public c(Socket s, IAuthenticate a) throws IOException {
        this.io(s);
        this.rBuff = new byte[99];
        int bytesRead = this.inStream.read(this.rBuff);
        if (a != null && !a.authenticate(new String(this.rBuff, 0, bytesRead > 1 ? bytesRead - 2 : 0))) {
            this.close();
            throw new IOException("access");
        }
        this.ipcVersion = bytesRead > 1 ? this.rBuff[bytesRead - 2] : 0;
        this.rBuff[0] = (byte)(this.ipcVersion < 3 ? this.ipcVersion : 3);
        this.outStream.write(this.rBuff, 0, 1);
    }

    public c(Socket s) throws IOException {
        this(s, null);
    }

    public c(String host, int port, String usernamepassword) throws KException, IOException {
        this(host, port, usernamepassword, false);
    }

    public c(String host, int port, String usernamepassword, boolean useTLS) throws KException, IOException {
        this.host = host;
        this.port = port;
        this.wBuff = new byte[2 + c.ns(usernamepassword)];
        this.s = new Socket(host, port);
        if (useTLS) {
            try {
                this.s = ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(this.s, host, port, true);
                ((SSLSocket)this.s).startHandshake();
            }
            catch (Exception e) {
                this.s.close();
                throw e;
            }
        }
        this.io(this.s);
        this.wBuffPos = 0;
        this.w(usernamepassword + "\u0003");
        this.outStream.write(this.wBuff);
        if (1 != this.inStream.read(this.wBuff, 0, 1)) {
            this.close();
            throw new KException("access");
        }
        this.ipcVersion = Math.min(this.wBuff[0], 3);
    }

    public c(String host, int port) throws KException, IOException {
        this(host, port, System.getProperty("user.name"));
    }

    public c() {
        this.ipcVersion = 3;
        this.isLoopback = false;
        this.inStream = new DataInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                throw new UnsupportedOperationException("nyi");
            }
        });
        this.outStream = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                throw new UnsupportedOperationException("nyi");
            }
        };
    }

    private void compress() {
        int c2;
        int i = 0;
        int origSize = this.wBuffPos;
        boolean f = false;
        int h0 = 0;
        int h = 0;
        byte[] y = this.wBuff;
        this.wBuff = new byte[y.length / 2];
        int d = c2 = 12;
        int e = this.wBuff.length;
        int p = 0;
        int s0 = 0;
        int s = 8;
        int t = this.wBuffPos;
        int[] a = new int[256];
        System.arraycopy(y, 0, this.wBuff, 0, 4);
        this.wBuff[2] = 1;
        this.wBuffPos = 8;
        this.w(origSize);
        while (s < t) {
            boolean g;
            if (0 == i) {
                if (d > e - 17) {
                    this.wBuffPos = origSize;
                    this.wBuff = y;
                    return;
                }
                i = 1;
                this.wBuff[c2] = (byte)(f ? 1 : 0);
                c2 = d++;
                f = false;
            }
            boolean bl = g = s > t - 3 || 0 == (p = a[h = 0xFF & (y[s] ^ y[s + 1])]) || 0 != (y[s] ^ y[p]);
            if (0 < s0) {
                a[h0] = s0;
                s0 = 0;
            }
            if (g) {
                h0 = h;
                s0 = s;
                this.wBuff[d++] = y[s++];
            } else {
                a[h] = s;
                f |= i;
                p += 2;
                int r = s += 2;
                int q = Math.min(s + 255, t);
                while (y[p] == y[s] && ++s < q) {
                    ++p;
                }
                this.wBuff[d++] = (byte)h;
                this.wBuff[d++] = (byte)(s - r);
            }
            i = (byte)(i * 2);
        }
        this.wBuff[c2] = (byte)(f ? 1 : 0);
        this.wBuffPos = 4;
        this.w(d);
        this.wBuffPos = d;
        this.wBuff = Arrays.copyOf(this.wBuff, this.wBuffPos);
    }

    private void uncompress() {
        int s;
        int n = 0;
        int r = 0;
        int f = 0;
        int p = s = 8;
        int i = 0;
        byte[] dst = new byte[this.ri()];
        int d = this.rBuffPos;
        int[] aa = new int[256];
        while (s < dst.length) {
            if (i == 0) {
                f = 0xFF & this.rBuff[d++];
                i = 1;
            }
            if (f & i) {
                r = aa[0xFF & this.rBuff[d++]];
                dst[s++] = dst[r++];
                dst[s++] = dst[r++];
                n = 0xFF & this.rBuff[d++];
                for (int m = 0; m < n; ++m) {
                    dst[s + m] = dst[r + m];
                }
            } else {
                dst[s++] = this.rBuff[d++];
            }
            while (p < s - 1) {
                aa[0xFF & dst[p] ^ 0xFF & dst[p + 1]] = p++;
            }
            if ((f & i) != 0) {
                p = s += n;
            }
            if ((i = (int)((short)(i * 2))) != 256) continue;
            i = 0;
        }
        this.rBuff = dst;
        this.rBuffPos = 8;
    }

    void w(byte x) {
        this.wBuff[this.wBuffPos++] = x;
    }

    boolean rb() {
        return 1 == this.rBuff[this.rBuffPos++];
    }

    void w(boolean x) {
        this.w((byte)(x ? 1 : 0));
    }

    char rc() {
        return (char)(this.rBuff[this.rBuffPos++] & 0xFF);
    }

    void w(char c2) {
        this.w((byte)c2);
    }

    short rh() {
        byte x = this.rBuff[this.rBuffPos++];
        byte y = this.rBuff[this.rBuffPos++];
        return (short)(this.isLittleEndian ? x & 0xFF | y << 8 : x << 8 | y & 0xFF);
    }

    void w(short h) {
        this.w((byte)(h >> 8));
        this.w((byte)h);
    }

    int ri() {
        short x = this.rh();
        short y = this.rh();
        return this.isLittleEndian ? x & 0xFFFF | y << 16 : x << 16 | y & 0xFFFF;
    }

    void w(int i) {
        this.w((short)(i >> 16));
        this.w((short)i);
    }

    UUID rg() {
        boolean oa = this.isLittleEndian;
        this.isLittleEndian = false;
        UUID g = new UUID(this.rj(), this.rj());
        this.isLittleEndian = oa;
        return g;
    }

    void w(UUID uuid) {
        if (this.ipcVersion < 3) {
            throw new RuntimeException("Guid not valid pre kdb+3.0");
        }
        this.w(uuid.getMostSignificantBits());
        this.w(uuid.getLeastSignificantBits());
    }

    long rj() {
        int x = this.ri();
        int y = this.ri();
        return this.isLittleEndian ? (long)x & 0xFFFFFFFFL | (long)y << 32 : (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    void w(long j) {
        this.w((int)(j >> 32));
        this.w((int)j);
    }

    float re() {
        return Float.intBitsToFloat(this.ri());
    }

    void w(float e) {
        this.w(Float.floatToIntBits(e));
    }

    double rf() {
        return Double.longBitsToDouble(this.rj());
    }

    void w(double f) {
        this.w(Double.doubleToLongBits(f));
    }

    Month rm() {
        return new Month(this.ri());
    }

    void w(Month m) {
        this.w(m.i);
    }

    Minute ru() {
        return new Minute(this.ri());
    }

    void w(Minute u) {
        this.w(u.i);
    }

    Second rv() {
        return new Second(this.ri());
    }

    void w(Second v) {
        this.w(v.i);
    }

    Timespan rn() {
        return new Timespan(this.rj());
    }

    void w(Timespan n) {
        if (this.ipcVersion < 1) {
            throw new RuntimeException("Timespan not valid pre kdb+2.6");
        }
        this.w(n.j);
    }

    LocalDate rd() {
        int dateAsInt = this.ri();
        return dateAsInt == ni ? LocalDate.MIN : LocalDate.ofEpochDay(10957L + (long)dateAsInt);
    }

    void w(LocalDate d) {
        if (d == LocalDate.MIN) {
            this.w(ni);
            return;
        }
        long daysSince2000 = d.toEpochDay() - 10957L;
        if (daysSince2000 < Integer.MIN_VALUE || daysSince2000 > Integer.MAX_VALUE) {
            throw new RuntimeException("LocalDate epoch day since 2000 must be >= Integer.MIN_VALUE and <= Integer.MAX_VALUE");
        }
        this.w((int)daysSince2000);
    }

    LocalTime rt() {
        int timeAsInt = this.ri();
        return timeAsInt == ni ? LOCAL_TIME_NULL : LocalDateTime.ofInstant(Instant.ofEpochMilli(timeAsInt), ZoneId.of("UTC")).toLocalTime();
    }

    private static long toEpochSecond(LocalTime t, LocalDate d, ZoneOffset o) {
        long epochDay = d.toEpochDay();
        long secs = epochDay * 86400L + (long)t.toSecondOfDay();
        return secs -= (long)o.getTotalSeconds();
    }

    void w(LocalTime t) {
        this.w(t == LOCAL_TIME_NULL ? ni : (int)((c.toEpochSecond(t, LocalDate.of(1970, 1, 1), ZoneOffset.UTC) * 1000L + (long)(t.getNano() / 1000000)) % 86400000L));
    }

    LocalDateTime rz() {
        double f = this.rf();
        if (Double.isNaN(f)) {
            return LocalDateTime.MIN;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(946684800000L + Math.round(8.64E7 * f)), ZoneId.of("UTC"));
    }

    void w(LocalDateTime z) {
        this.w(z == LocalDateTime.MIN ? nf : (double)(z.toInstant(ZoneOffset.UTC).toEpochMilli() - 946684800000L) / 8.64E7);
    }

    Instant rp() {
        long timeAsLong = this.rj();
        if (timeAsLong == nj) {
            return Instant.MIN;
        }
        long d = timeAsLong < 0L ? (timeAsLong + 1L) / 1000000000L - 1L : timeAsLong / 1000000000L;
        return Instant.ofEpochMilli(946684800000L + 1000L * d).plusNanos((int)(timeAsLong - 1000000000L * d));
    }

    void w(Instant p) {
        if (this.ipcVersion < 1) {
            throw new RuntimeException("Instant not valid pre kdb+2.6");
        }
        this.w(p == Instant.MIN ? nj : 1000000L * (p.toEpochMilli() - 946684800000L) + (long)(p.getNano() % 1000000));
    }

    String rs() throws UnsupportedEncodingException {
        int startPos = this.rBuffPos;
        while (this.rBuff[this.rBuffPos++] != 0) {
        }
        return startPos == this.rBuffPos - 1 ? "" : new String(this.rBuff, startPos, this.rBuffPos - 1 - startPos, encoding);
    }

    void w(String s) throws UnsupportedEncodingException {
        if (s != null) {
            int byteLen = c.ns(s);
            byte[] bytes = s.getBytes(encoding);
            for (int idx = 0; idx < byteLen; ++idx) {
                this.w(bytes[idx]);
            }
        }
        this.wBuff[this.wBuffPos++] = 0;
    }

    Object r() throws UnsupportedEncodingException {
        byte t;
        int i = 0;
        if ((t = this.rBuff[this.rBuffPos++]) < 0) {
            switch (t) {
                case -1: {
                    return this.rb();
                }
                case -2: {
                    return this.rg();
                }
                case -4: {
                    return this.rBuff[this.rBuffPos++];
                }
                case -5: {
                    return this.rh();
                }
                case -6: {
                    return this.ri();
                }
                case -7: {
                    return this.rj();
                }
                case -8: {
                    return Float.valueOf(this.re());
                }
                case -9: {
                    return this.rf();
                }
                case -10: {
                    return Character.valueOf(this.rc());
                }
                case -11: {
                    return this.rs();
                }
                case -12: {
                    return this.rp();
                }
                case -13: {
                    return this.rm();
                }
                case -14: {
                    return this.rd();
                }
                case -15: {
                    return this.rz();
                }
                case -16: {
                    return this.rn();
                }
                case -17: {
                    return this.ru();
                }
                case -18: {
                    return this.rv();
                }
                case -19: {
                    return this.rt();
                }
            }
        }
        if (t > 99) {
            if (t == 100) {
                this.rs();
                return this.r();
            }
            if (t == 102 || t == 101) {
                char[][] funcs;
                byte p = this.rBuff[this.rBuffPos];
                char[][] cArray = funcs = t == 101 ? FUNC_1 : FUNC_2;
                if (p < funcs.length && p >= 0) {
                    ++this.rBuffPos;
                    return funcs[p];
                }
            } else if (t >= 106 && t <= 111) {
                String adverb = ADVERBS[t - 106];
                Object def = this.r();
                if (def instanceof char[]) {
                    return (new String((char[])def) + adverb).toCharArray();
                }
                return null;
            }
            if (t == 104) {
                String s = "";
                boolean first = true;
                int n = this.ri();
                while (i < n) {
                    Object o = this.r();
                    if (o instanceof char[]) {
                        o = new String((char[])o);
                    }
                    s = s + o;
                    if (first) {
                        first = false;
                        s = s + "[";
                    } else {
                        s = i != n - 1 ? s + ";" : s + "]";
                    }
                    ++i;
                }
                return s.toCharArray();
            }
            if (t == 101 && this.rBuff[this.rBuffPos] == -1) {
                ++this.rBuffPos;
                return "";
            }
            if (t == 127) {
                return new Dict(this.r(), this.r());
            }
            if (t < 104) {
                return this.rBuff[this.rBuffPos++] == 0 && t == 101 ? null : "func";
            }
            if (t > 105) {
                this.r();
            } else {
                int n = this.ri();
                while (i < n) {
                    this.r();
                    ++i;
                }
            }
            return "func";
        }
        if (t == 99) {
            return new Dict(this.r(), this.r());
        }
        ++this.rBuffPos;
        if (t == 98) {
            return new Flip((Dict)this.r());
        }
        int n = this.ri();
        switch (t) {
            case 0: {
                Object[] objArr = new Object[n];
                while (i < n) {
                    objArr[i] = this.r();
                    ++i;
                }
                return objArr;
            }
            case 1: {
                boolean[] boolArr = new boolean[n];
                while (i < n) {
                    boolArr[i] = this.rb();
                    ++i;
                }
                return boolArr;
            }
            case 2: {
                UUID[] uuidArr = new UUID[n];
                while (i < n) {
                    uuidArr[i] = this.rg();
                    ++i;
                }
                return uuidArr;
            }
            case 4: {
                byte[] byteArr = new byte[n];
                while (i < n) {
                    byteArr[i] = this.rBuff[this.rBuffPos++];
                    ++i;
                }
                return byteArr;
            }
            case 5: {
                short[] shortArr = new short[n];
                while (i < n) {
                    shortArr[i] = this.rh();
                    ++i;
                }
                return shortArr;
            }
            case 6: {
                int[] intArr = new int[n];
                while (i < n) {
                    intArr[i] = this.ri();
                    ++i;
                }
                return intArr;
            }
            case 7: {
                long[] longArr = new long[n];
                while (i < n) {
                    longArr[i] = this.rj();
                    ++i;
                }
                return longArr;
            }
            case 8: {
                float[] floatArr = new float[n];
                while (i < n) {
                    floatArr[i] = this.re();
                    ++i;
                }
                return floatArr;
            }
            case 9: {
                double[] doubleArr = new double[n];
                while (i < n) {
                    doubleArr[i] = this.rf();
                    ++i;
                }
                return doubleArr;
            }
            case 10: {
                char[] charArr = new String(this.rBuff, this.rBuffPos, n, encoding).toCharArray();
                this.rBuffPos += n;
                return charArr;
            }
            case 11: {
                String[] stringArr = new String[n];
                while (i < n) {
                    stringArr[i] = this.rs();
                    ++i;
                }
                return stringArr;
            }
            case 12: {
                Instant[] timestampArr = new Instant[n];
                while (i < n) {
                    timestampArr[i] = this.rp();
                    ++i;
                }
                return timestampArr;
            }
            case 13: {
                Month[] monthArr = new Month[n];
                while (i < n) {
                    monthArr[i] = this.rm();
                    ++i;
                }
                return monthArr;
            }
            case 14: {
                LocalDate[] dateArr = new LocalDate[n];
                while (i < n) {
                    dateArr[i] = this.rd();
                    ++i;
                }
                return dateArr;
            }
            case 15: {
                LocalDateTime[] dateUtilArr = new LocalDateTime[n];
                while (i < n) {
                    dateUtilArr[i] = this.rz();
                    ++i;
                }
                return dateUtilArr;
            }
            case 16: {
                Timespan[] timespanArr = new Timespan[n];
                while (i < n) {
                    timespanArr[i] = this.rn();
                    ++i;
                }
                return timespanArr;
            }
            case 17: {
                Minute[] minArr = new Minute[n];
                while (i < n) {
                    minArr[i] = this.ru();
                    ++i;
                }
                return minArr;
            }
            case 18: {
                Second[] secArr = new Second[n];
                while (i < n) {
                    secArr[i] = this.rv();
                    ++i;
                }
                return secArr;
            }
            case 19: {
                LocalTime[] timeArr = new LocalTime[n];
                while (i < n) {
                    timeArr[i] = this.rt();
                    ++i;
                }
                return timeArr;
            }
        }
        return null;
    }

    public static int t(Object x) {
        if (x instanceof Boolean) {
            return -1;
        }
        if (x instanceof UUID) {
            return -2;
        }
        if (x instanceof Byte) {
            return -4;
        }
        if (x instanceof Short) {
            return -5;
        }
        if (x instanceof Integer) {
            return -6;
        }
        if (x instanceof Long) {
            return -7;
        }
        if (x instanceof Float) {
            return -8;
        }
        if (x instanceof Double) {
            return -9;
        }
        if (x instanceof Character) {
            return -10;
        }
        if (x instanceof String) {
            return -11;
        }
        if (x instanceof LocalDate) {
            return -14;
        }
        if (x instanceof LocalTime) {
            return -19;
        }
        if (x instanceof Instant) {
            return -12;
        }
        if (x instanceof LocalDateTime) {
            return -15;
        }
        if (x instanceof Timespan) {
            return -16;
        }
        if (x instanceof Month) {
            return -13;
        }
        if (x instanceof Minute) {
            return -17;
        }
        if (x instanceof Second) {
            return -18;
        }
        if (x instanceof boolean[]) {
            return 1;
        }
        if (x instanceof UUID[]) {
            return 2;
        }
        if (x instanceof byte[]) {
            return 4;
        }
        if (x instanceof short[]) {
            return 5;
        }
        if (x instanceof int[]) {
            return 6;
        }
        if (x instanceof long[]) {
            return 7;
        }
        if (x instanceof float[]) {
            return 8;
        }
        if (x instanceof double[]) {
            return 9;
        }
        if (x instanceof char[]) {
            return 10;
        }
        if (x instanceof String[]) {
            return 11;
        }
        if (x instanceof LocalDate[]) {
            return 14;
        }
        if (x instanceof LocalTime[]) {
            return 19;
        }
        if (x instanceof Instant[]) {
            return 12;
        }
        if (x instanceof LocalDateTime[]) {
            return 15;
        }
        if (x instanceof Timespan[]) {
            return 16;
        }
        if (x instanceof Month[]) {
            return 13;
        }
        if (x instanceof Minute[]) {
            return 17;
        }
        if (x instanceof Second[]) {
            return 18;
        }
        if (x instanceof Flip) {
            return 98;
        }
        if (x instanceof Dict) {
            return 99;
        }
        return 0;
    }

    static int ns(String s) throws UnsupportedEncodingException {
        if (s == null) {
            return 0;
        }
        int i = s.indexOf(0);
        if (-1 < i) {
            s = s.substring(0, i);
        }
        return s.getBytes(encoding).length;
    }

    public static int n(Object x) throws UnsupportedEncodingException {
        if (x instanceof Dict) {
            return c.n(((Dict)x).x);
        }
        if (x instanceof Flip) {
            return c.n(((Flip)x).y[0]);
        }
        return x instanceof char[] ? new String((char[])x).getBytes(encoding).length : Array.getLength(x);
    }

    public int nx(Object x) throws UnsupportedEncodingException {
        int type = c.t(x);
        if (type == 99) {
            return 1 + this.nx(((Dict)x).x) + this.nx(((Dict)x).y);
        }
        if (type == 98) {
            return 3 + this.nx(((Flip)x).x) + this.nx(((Flip)x).y);
        }
        if (type < 0) {
            return type == -11 ? 2 + c.ns((String)x) : 1 + nt[-type];
        }
        int numBytes = 6;
        int numElements = c.n(x);
        if (type == 0 || type == 11) {
            for (int idx = 0; idx < numElements; ++idx) {
                numBytes += type == 0 ? this.nx(((Object[])x)[idx]) : 1 + c.ns(((String[])x)[idx]);
            }
        } else {
            numBytes += numElements * nt[type];
        }
        return numBytes;
    }

    void w(Object x) throws UnsupportedEncodingException {
        int i = 0;
        int type = c.t(x);
        this.w((byte)type);
        if (type < 0) {
            switch (type) {
                case -1: {
                    this.w((Boolean)x);
                    return;
                }
                case -2: {
                    this.w((UUID)x);
                    return;
                }
                case -4: {
                    this.w((Byte)x);
                    return;
                }
                case -5: {
                    this.w((Short)x);
                    return;
                }
                case -6: {
                    this.w((Integer)x);
                    return;
                }
                case -7: {
                    this.w((Long)x);
                    return;
                }
                case -8: {
                    this.w(((Float)x).floatValue());
                    return;
                }
                case -9: {
                    this.w((Double)x);
                    return;
                }
                case -10: {
                    this.w(((Character)x).charValue());
                    return;
                }
                case -11: {
                    this.w((String)x);
                    return;
                }
                case -12: {
                    this.w((Instant)x);
                    return;
                }
                case -13: {
                    this.w((Month)x);
                    return;
                }
                case -14: {
                    this.w((LocalDate)x);
                    return;
                }
                case -15: {
                    this.w((LocalDateTime)x);
                    return;
                }
                case -16: {
                    this.w((Timespan)x);
                    return;
                }
                case -17: {
                    this.w((Minute)x);
                    return;
                }
                case -18: {
                    this.w((Second)x);
                    return;
                }
                case -19: {
                    this.w((LocalTime)x);
                    return;
                }
            }
        }
        if (type == 99) {
            Dict r = (Dict)x;
            this.w(r.x);
            this.w(r.y);
            return;
        }
        this.wBuff[this.wBuffPos++] = 0;
        if (type == 98) {
            Flip r = (Flip)x;
            this.wBuff[this.wBuffPos++] = 99;
            this.w(r.x);
            this.w(r.y);
            return;
        }
        int n = c.n(x);
        this.w(n);
        if (type == 10) {
            byte[] b = new String((char[])x).getBytes(encoding);
            while (i < b.length) {
                this.w(b[i++]);
            }
        } else {
            while (i < n) {
                if (type == 0) {
                    this.w(((Object[])x)[i]);
                } else if (type == 1) {
                    this.w(((boolean[])x)[i]);
                } else if (type == 2) {
                    this.w(((UUID[])x)[i]);
                } else if (type == 4) {
                    this.w(((byte[])x)[i]);
                } else if (type == 5) {
                    this.w(((short[])x)[i]);
                } else if (type == 6) {
                    this.w(((int[])x)[i]);
                } else if (type == 7) {
                    this.w(((long[])x)[i]);
                } else if (type == 8) {
                    this.w(((float[])x)[i]);
                } else if (type == 9) {
                    this.w(((double[])x)[i]);
                } else if (type == 11) {
                    this.w(((String[])x)[i]);
                } else if (type == 12) {
                    this.w(((Instant[])x)[i]);
                } else if (type == 13) {
                    this.w(((Month[])x)[i]);
                } else if (type == 14) {
                    this.w(((LocalDate[])x)[i]);
                } else if (type == 15) {
                    this.w(((LocalDateTime[])x)[i]);
                } else if (type == 16) {
                    this.w(((Timespan[])x)[i]);
                } else if (type == 17) {
                    this.w(((Minute[])x)[i]);
                } else if (type == 18) {
                    this.w(((Second[])x)[i]);
                } else {
                    this.w(((LocalTime[])x)[i]);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(int msgType, Object x, boolean zip) throws IOException {
        int length = 8 + this.nx(x);
        OutputStream outputStream = this.outStream;
        synchronized (outputStream) {
            this.wBuff = new byte[length];
            this.wBuff[0] = 0;
            this.wBuff[1] = (byte)msgType;
            this.wBuffPos = 4;
            this.w(length);
            this.w(x);
            if (zip && this.wBuffPos > 2000 && !this.isLoopback) {
                this.compress();
            }
            return this.wBuff;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(byte[] buffer) throws KException, UnsupportedEncodingException {
        DataInputStream dataInputStream = this.inStream;
        synchronized (dataInputStream) {
            this.rBuff = buffer;
            this.isLittleEndian = this.rBuff[0] == 1;
            boolean compressed = this.rBuff[2] == 1;
            this.rBuffPos = 8;
            if (compressed) {
                this.uncompress();
            }
            if (this.rBuff[8] == -128) {
                this.rBuffPos = 9;
                throw new KException(this.rs());
            }
            return this.r();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void w(int msgType, Object x) throws IOException {
        OutputStream outputStream = this.outStream;
        synchronized (outputStream) {
            byte[] buffer = this.serialize(msgType, x, this.zip);
            this.outStream.write(buffer, 0, buffer.length);
        }
    }

    public void kr(Object obj) throws IOException {
        if (this.sync == 0) {
            throw new IOException("Unexpected response msg");
        }
        --this.sync;
        this.w(2, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ke(String text) throws IOException {
        if (this.sync == 0) {
            throw new IOException("Unexpected error msg");
        }
        --this.sync;
        int n = 2 + c.ns(text) + 8;
        OutputStream outputStream = this.outStream;
        synchronized (outputStream) {
            this.wBuff = new byte[n];
            this.wBuff[0] = 0;
            this.wBuff[1] = 2;
            this.wBuffPos = 4;
            this.w(n);
            this.w((byte)-128);
            this.w(text);
            this.outStream.write(this.wBuff);
        }
    }

    public void ks(String expr) throws IOException {
        this.w(0, expr.toCharArray());
    }

    public void ks(Object obj) throws IOException {
        this.w(0, obj);
    }

    public void ks(String s, Object x) throws IOException {
        Object[] a = new Object[]{s.toCharArray(), x};
        this.w(0, a);
    }

    public void ks(String s, Object x, Object y) throws IOException {
        Object[] a = new Object[]{s.toCharArray(), x, y};
        this.w(0, a);
    }

    public void ks(String s, Object x, Object y, Object z) throws IOException {
        Object[] a = new Object[]{s.toCharArray(), x, y, z};
        this.w(0, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] readMsg() throws KException, IOException, UnsupportedEncodingException {
        DataInputStream dataInputStream = this.inStream;
        synchronized (dataInputStream) {
            this.rBuff = new byte[8];
            this.inStream.readFully(this.rBuff);
            boolean bl = this.isLittleEndian = this.rBuff[0] == 1;
            if (this.rBuff[1] == 1) {
                ++this.sync;
            }
            this.rBuffPos = 4;
            this.rBuff = Arrays.copyOf(this.rBuff, this.ri());
            this.inStream.readFully(this.rBuff, 8, this.rBuff.length - 8);
            return new Object[]{this.rBuff[1], this.deserialize(this.rBuff)};
        }
    }

    public Object k() throws KException, IOException, UnsupportedEncodingException {
        return this.readMsg()[1];
    }

    public void setMsgHandler(MsgHandler handler) {
        this.msgHandler = handler;
    }

    public MsgHandler getMsgHandler() {
        return this.msgHandler;
    }

    public void setCollectResponseAsync(boolean b) {
        this.collectResponseAsync = b;
    }

    public synchronized Object k(Object x) throws KException, IOException {
        this.w(1, x);
        if (this.collectResponseAsync) {
            return null;
        }
        while (true) {
            Object[] msg = this.readMsg();
            if (this.msgHandler == null || (Byte)msg[0] == 2) {
                return msg[1];
            }
            this.msgHandler.processMsg(this, (Byte)msg[0], msg[1]);
        }
    }

    public Object k(String expr) throws KException, IOException {
        return this.k(expr.toCharArray());
    }

    public Object k(String s, Object x) throws KException, IOException {
        Object[] a = new Object[]{s.toCharArray(), x};
        return this.k(a);
    }

    public Object k(String s, Object x, Object y) throws KException, IOException {
        Object[] a = new Object[]{s.toCharArray(), x, y};
        return this.k(a);
    }

    public Object k(String s, Object x, Object y, Object z) throws KException, IOException {
        Object[] a = new Object[]{s.toCharArray(), x, y, z};
        return this.k(a);
    }

    public static Object NULL(char c2) {
        return NULL[" bg xhijefcspmdznuvt".indexOf(c2)];
    }

    public static boolean qn(Object x) {
        int t = -c.t(x);
        return (t == 2 || t > 4) && x.equals(NULL[t]);
    }

    public static Object at(Object x, int i) {
        return c.qn(x = Array.get(x, i)) ? null : x;
    }

    public static void set(Object x, int i, Object y) {
        Array.set(x, i, null == y ? NULL[c.t(x)] : y);
    }

    static int find(String[] x, String y) {
        int i;
        for (i = 0; i < x.length && !x[i].equals(y); ++i) {
        }
        return i;
    }

    public static Flip td(Object tbl) throws UnsupportedEncodingException {
        if (tbl instanceof Flip) {
            return (Flip)tbl;
        }
        Dict d = (Dict)tbl;
        Flip a = (Flip)d.x;
        Flip b = (Flip)d.y;
        int m = c.n(a.x);
        int n = c.n(b.x);
        String[] x = new String[m + n];
        System.arraycopy(a.x, 0, x, 0, m);
        System.arraycopy(b.x, 0, x, m, n);
        Object[] y = new Object[m + n];
        System.arraycopy(a.y, 0, y, 0, m);
        System.arraycopy(b.y, 0, y, m, n);
        return new Flip(new Dict(x, y));
    }

    static String i2(int i) {
        return new DecimalFormat("00").format(i);
    }

    static String i9(int i) {
        return new DecimalFormat("000000000").format(i);
    }

    static {
        ADVERBS = new String[]{"'", "/", "\\", "':", "/:", "\\:"};
        String[] monadics = new String[]{null, "+:", "-:", "*:", "%:", "&:", "|:", "^:", "=:", "<:", ">:", "$:", ",:", "#:", "_:", "~:", "!:", "?:", "@:", ".:", "0::", "1::", "2::", "avg", "last", "sum", "prd", "min", "max", "exit", "getenv", "abs", "sqrt", "log", "exp", "sin", "asin", "cos", "acos", "tan", "atan", "enlist", "var", "dev", "hopen"};
        FUNC_1 = c.toChars(monadics);
        String[] dyads = new String[]{":", "+", "-", "*", "%", "&", "|", "^", "=", "<", ">", "$", ",", "#", "_", "~", "!", "?", "@", ".", "0:", "1:", "2:", "in", "within", "like", "bin", "ss", "insert", "wsum", "wavg", "div", "xexp", "setenv", "binr", "cov", "cor"};
        FUNC_2 = c.toChars(dyads);
        ni = Integer.MIN_VALUE;
        nj = Long.MIN_VALUE;
        nf = Double.NaN;
        nt = new int[]{0, 1, 16, 0, 1, 2, 4, 8, 4, 8, 1, 0, 8, 4, 4, 8, 8, 4, 4, 4};
        NULL = new Object[]{null, false, new UUID(0L, 0L), null, (byte)0, (short)Short.MIN_VALUE, ni, nj, Float.valueOf((float)nf), nf, Character.valueOf(' '), "", Instant.MIN, new Month(ni), LocalDate.MIN, LocalDateTime.MIN, new Timespan(nj), new Minute(ni), new Second(ni), LOCAL_TIME_NULL};
    }

    public static interface MsgHandler {
        default public void processMsg(c c2, byte msgType, Object msg) throws IOException {
            switch (msgType) {
                case 0: {
                    System.err.println("discarded unexpected incoming async msg!");
                    break;
                }
                case 1: {
                    c2.ke("unable to process sync requests");
                    break;
                }
                default: {
                    throw new IOException("Invalid message type received: " + msgType);
                }
            }
        }
    }

    public static class KException
    extends Exception {
        private final String title;
        private final String stackMessage;

        public KException(String title, String stackMessage) {
            super(title);
            this.title = Preconditions.checkNotNull(title);
            this.stackMessage = Preconditions.checkNotNull(stackMessage);
        }

        public KException(String title) {
            this(title, "");
        }

        public String getTitle() {
            return this.title;
        }

        public String getStackMessage() {
            StringBuilder sb = new StringBuilder(this.title);
            if (this.stackMessage.length() > 0) {
                sb.append("\r\n").append(this.stackMessage);
            }
            return sb.toString();
        }
    }

    public static class Flip {
        public String[] x;
        public Object[] y;

        public Flip(Dict dict) {
            this.x = (String[])dict.x;
            this.y = (Object[])dict.y;
        }

        public Object at(String s) {
            return this.y[c.find(this.x, s)];
        }

        public String toString() {
            return "([] " + Joiner.on("; ").join(this.x) + ")";
        }
    }

    public static class Dict {
        public Object x;
        public Object y;

        public Dict(Object keys, Object vals) {
            this.x = keys;
            this.y = vals;
        }

        public String toString() {
            if (this.x instanceof Flip && this.y instanceof Flip) {
                return "([" + Joiner.on("; ").join(((Flip)this.x).x) + "] " + Joiner.on("; ").join(((Flip)this.y).x) + ")";
            }
            return KdbHelper.asLine(this.x) + "!" + KdbHelper.asLine(this.y);
        }
    }

    public static class Timespan
    implements Comparable<Timespan> {
        public long j;

        public Timespan(long x) {
            this.j = x;
        }

        public Timespan() {
            this(TimeZone.getTimeZone("UTC"));
        }

        public Timespan(TimeZone tz) {
            Calendar c2 = Calendar.getInstance(tz);
            long now = c2.getTimeInMillis();
            c2.set(11, 0);
            c2.set(12, 0);
            c2.set(13, 0);
            c2.set(14, 0);
            this.j = (now - c2.getTimeInMillis()) * 1000000L;
        }

        public String toString() {
            if (this.j == nj) {
                return "";
            }
            if (this.j == Long.MAX_VALUE) {
                return "0W";
            }
            if (this.j == nj + 1L) {
                return "-0W";
            }
            String s = this.j < 0L ? "-" : "";
            long jj = this.j < 0L ? -this.j : this.j;
            int d = (int)(jj / 86400000000000L);
            if (d != 0) {
                s = s + d + "D";
            }
            return s + c.i2((int)(jj % 86400000000000L / 3600000000000L)) + ":" + c.i2((int)(jj % 3600000000000L / 60000000000L)) + ":" + c.i2((int)(jj % 60000000000L / 1000000000L)) + "." + c.i9((int)(jj % 1000000000L));
        }

        @Override
        public int compareTo(Timespan t) {
            if (this.j > t.j) {
                return 1;
            }
            return this.j < t.j ? -1 : 0;
        }

        public boolean equals(Object o) {
            return o instanceof Timespan && ((Timespan)o).j == this.j;
        }

        public int hashCode() {
            return (int)(this.j ^ this.j >>> 32);
        }
    }

    public static class Second
    implements Comparable<Second> {
        public int i;

        public Second(int x) {
            this.i = x;
        }

        public String toString() {
            return this.i == ni ? "" : (this.i == Integer.MAX_VALUE ? "0W" : (this.i == ni + 1 ? "-0W" : new Minute(this.i / 60).toString() + ':' + c.i2(this.i % 60)));
        }

        public boolean equals(Object o) {
            return o instanceof Second && ((Second)o).i == this.i;
        }

        public int hashCode() {
            return this.i;
        }

        @Override
        public int compareTo(Second s) {
            return this.i - s.i;
        }
    }

    public static class Minute
    implements Comparable<Minute> {
        public int i;

        public Minute(int x) {
            this.i = x;
        }

        public String toString() {
            return this.i == ni ? "" : (this.i == Integer.MAX_VALUE ? "0W" : (this.i == ni + 1 ? "-0W" : c.i2(this.i / 60) + ":" + c.i2(this.i % 60)));
        }

        public boolean equals(Object o) {
            return o instanceof Minute && ((Minute)o).i == this.i;
        }

        public int hashCode() {
            return this.i;
        }

        @Override
        public int compareTo(Minute m) {
            return this.i - m.i;
        }
    }

    public static class Month
    implements Comparable<Month> {
        public int i;

        public Month(int x) {
            this.i = x;
        }

        public String toString() {
            int m = this.i + 24000;
            int y = m / 12;
            return this.i == ni ? "" : (this.i == Integer.MAX_VALUE ? "0W" : (this.i == ni + 1 ? "-0W" : c.i2(y / 100) + c.i2(y % 100) + "." + c.i2(1 + m % 12)));
        }

        public boolean equals(Object o) {
            return o instanceof Month && ((Month)o).i == this.i;
        }

        public int hashCode() {
            return this.i;
        }

        @Override
        public int compareTo(Month m) {
            return this.i - m.i;
        }
    }

    public static interface IAuthenticate {
        public boolean authenticate(String var1);
    }
}

