/*
 * Decompiled with CFR 0.152.
 */
package jdbc.utils;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import jdbc.client.structures.query.RedisQuery;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.util.SafeEncoder;

public class Utils {
    private Utils() {
    }

    public static boolean isNullOrEmpty(@Nullable String value) {
        return value == null || value.isEmpty();
    }

    @NotNull
    public static String toLowerCase(@NotNull String value) {
        return value.toLowerCase(Locale.ENGLISH);
    }

    @NotNull
    public static String toUpperCase(@NotNull String value) {
        return value.toUpperCase(Locale.ENGLISH);
    }

    @NotNull
    public static String toCapitalized(@NotNull String value) {
        return value.isEmpty() ? value : Utils.toUpperCase(value.substring(0, 1)) + Utils.toLowerCase(value.substring(1));
    }

    @Nullable
    public static String getFirst(@NotNull String[] elements) {
        return elements.length > 0 ? elements[0] : null;
    }

    @Nullable
    public static String getLast(@NotNull String[] elements) {
        return elements.length > 0 ? elements[elements.length - 1] : null;
    }

    @Nullable
    public static Integer getIndex(@NotNull String[] elements, @NotNull Predicate<String> predicate) {
        for (int i = 0; i < elements.length; ++i) {
            if (!predicate.test(elements[i])) continue;
            return i;
        }
        return null;
    }

    public static String getString(Map<?, ?> map, String name, String defaultValue) {
        return Utils.getObject(map, name, defaultValue, Object::toString);
    }

    public static int getInt(Map<?, ?> map, String name, int defaultValue) {
        return Utils.getObject(map, name, defaultValue, Integer::parseInt);
    }

    public static boolean getBoolean(Map<?, ?> map, String name, boolean defaultValue) {
        return Utils.getObject(map, name, defaultValue, Boolean::parseBoolean);
    }

    public static <K, V> Map<K, V> getMap(Map<?, ?> map, String name, @NotNull Function<String, K> keyParser, @NotNull Function<String, V> valueParser) {
        return Utils.getObject(map, name, null, o -> Utils.parseMap(keyParser, valueParser, o));
    }

    @NotNull
    private static <K, V> Map<K, V> parseMap(@NotNull Function<String, K> keyParser, @NotNull Function<String, V> valueParser, @NotNull String map) {
        String[] elements;
        HashMap<K, V> result = new HashMap<K, V>();
        String content = map.trim();
        if (!content.startsWith("{") || !content.endsWith("}")) {
            throw new IllegalArgumentException(String.format("Incorrect map: %s", map));
        }
        String body = content.substring(1, content.length() - 1).trim();
        if (body.isEmpty()) {
            return result;
        }
        for (String element : elements = body.split(",")) {
            String[] keyValue = (element = element.trim()).split("=");
            if (keyValue.length != 2) {
                throw new IllegalArgumentException(String.format("Incorrect map: %s", map));
            }
            String key = keyValue[0].trim();
            String value = keyValue[1].trim();
            result.put(keyParser.apply(key), valueParser.apply(value));
        }
        return result;
    }

    private static <T> T getObject(Map<?, ?> map, String name, T defaultValue, Function<String, T> valueParser) {
        Object option;
        if (map != null && (option = map.get(name)) != null) {
            return valueParser.apply(option.toString());
        }
        return defaultValue;
    }

    @NotNull
    public static HostAndPort parseHostAndPort(@NotNull String hostAndPortStr) {
        HostAndPort hostAndPort = HostAndPort.from(hostAndPortStr);
        String host = hostAndPort.getHost();
        String adjustedHost = Utils.adjustHost(host);
        if (adjustedHost.equals(host)) {
            return hostAndPort;
        }
        return new HostAndPort(adjustedHost, hostAndPort.getPort());
    }

    @NotNull
    public static String adjustHost(@NotNull String host) {
        String adjustedHost = host.trim();
        if ("localhost".equalsIgnoreCase(adjustedHost)) {
            return "127.0.0.1";
        }
        return adjustedHost;
    }

    public static int parseSqlDbIndex(@Nullable String db) throws SQLException {
        if (db == null) {
            throw new SQLException("Database should be specified.");
        }
        try {
            return Utils.parseDbIndex(db);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
    }

    public static int parseDbIndex(@NotNull String db) {
        try {
            return Integer.parseInt(db);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Database should be a number: %s.", db));
        }
    }

    @NotNull
    public static Predicate<RedisQuery> param(@NotNull Protocol.Keyword keyword) {
        return q -> q.containsParam(keyword);
    }

    @NotNull
    public static Predicate<RedisQuery> length(int length) {
        return q -> 1 + q.getParams().length == length;
    }

    @NotNull
    public static String getColumnTitle(@NotNull Protocol.Command command) {
        String lowerName = Utils.toLowerCase(command.name());
        if (lowerName.equals("zscore") || lowerName.equals("zmscore")) {
            return "score";
        }
        return lowerName;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String getName(@Nullable Rawable rawable) {
        if (rawable == null) {
            return null;
        }
        byte[] raw = rawable.getRaw();
        String text = raw == null ? "" : SafeEncoder.encode(raw);
        return Utils.getName(text);
    }

    @NotNull
    public static String getName(@NotNull String text) {
        return Utils.toUpperCase(text);
    }
}

