/*
 * Decompiled with CFR 0.152.
 */
package jdbc.types;

import java.util.HashMap;
import java.util.Map;
import jdbc.utils.Utils;

public class RedisColumnTypeHelper {
    public static final String OBJECT = "object";
    public static final String STRING = "string";
    public static final String LONG = "long";
    public static final String DOUBLE = "double";
    public static final String BOOLEAN = "boolean";
    public static final String BINARY = "binary";
    public static final String ARRAY = "array";
    public static final String MAP = "map";
    private static final Map<String, Integer> javaTypeMap = new HashMap<String, Integer>(){
        {
            this.put(RedisColumnTypeHelper.OBJECT, 2000);
            this.put(RedisColumnTypeHelper.STRING, 12);
            this.put(RedisColumnTypeHelper.LONG, -5);
            this.put(RedisColumnTypeHelper.DOUBLE, 8);
            this.put(RedisColumnTypeHelper.BOOLEAN, 16);
            this.put(RedisColumnTypeHelper.BINARY, -2);
            this.put(RedisColumnTypeHelper.ARRAY, 2003);
            this.put(RedisColumnTypeHelper.MAP, 2000);
        }
    };
    private static final Map<String, String> typeNameMap = new HashMap<String, String>(){
        {
            this.put(RedisColumnTypeHelper.OBJECT, "java.lang.Object");
            this.put(RedisColumnTypeHelper.STRING, "java.lang.String");
            this.put(RedisColumnTypeHelper.LONG, "java.lang.Long");
            this.put(RedisColumnTypeHelper.DOUBLE, "java.lang.Double");
            this.put(RedisColumnTypeHelper.BOOLEAN, "java.lang.Boolean");
            this.put(RedisColumnTypeHelper.BINARY, "[B");
            this.put(RedisColumnTypeHelper.ARRAY, "java.util.List");
            this.put(RedisColumnTypeHelper.MAP, "java.util.Map");
        }
    };

    private RedisColumnTypeHelper() {
    }

    public static int getJavaType(String typeName) {
        String lower = Utils.toLowerCase(typeName);
        if (javaTypeMap.containsKey(lower)) {
            return javaTypeMap.get(lower);
        }
        throw new IllegalArgumentException("Type name is not known: " + lower);
    }

    public static String getClassName(String typeName) {
        String lower = Utils.toLowerCase(typeName);
        if (typeNameMap.containsKey(lower)) {
            return typeNameMap.get(lower);
        }
        throw new IllegalArgumentException("Type name is not known: " + lower);
    }
}

