/*
 * Decompiled with CFR 0.152.
 */
package jdbc.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import jdbc.client.structures.result.SimpleType;
import jdbc.types.RedisColumnTypeHelper;
import org.jetbrains.annotations.NotNull;

public class RedisResultSetMetaData
implements ResultSetMetaData {
    private static final String NOT_APPLICABLE_TABLE_NAME = "";
    private static final String NOT_APPLICABLE_CATALOG = "";
    private static final int NOT_APPLICABLE_SCALE = 0;
    private static final int NOT_APPLICABLE_PRECISION = 0;
    private final List<ColumnMetaData> columnMetaDatas;

    public RedisResultSetMetaData(@NotNull List<ColumnMetaData> columnMetaDatas) {
        this.columnMetaDatas = columnMetaDatas;
    }

    public static ColumnMetaData createColumn(@NotNull String name, @NotNull String typeName) {
        return new ColumnMetaData(name, typeName);
    }

    public static ColumnMetaData createColumn(@NotNull String name, @NotNull SimpleType<?> type) {
        return new ColumnMetaData(name, type.getTypeName());
    }

    public int findColumn(String columnLabel) {
        for (int i = 0; i < this.columnMetaDatas.size(); ++i) {
            if (!this.columnMetaDatas.get(i).name.equals(columnLabel)) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnMetaDatas.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 0;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return 11;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.columnMetaDatas.get(column - 1).name;
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columnMetaDatas.get(column - 1).name;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getCatalogName(column);
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return 0;
    }

    @Override
    public int getScale(int column) throws SQLException {
        return 0;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.columnMetaDatas.get(column - 1).getJavaType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.columnMetaDatas.get(column - 1).typeName;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.columnMetaDatas.get(column - 1).getClassName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public static class ColumnMetaData {
        private final String name;
        private final String typeName;

        private ColumnMetaData(@NotNull String name, @NotNull String typeName) {
            this.name = name;
            this.typeName = typeName;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        public int getJavaType() {
            return RedisColumnTypeHelper.getJavaType(this.typeName);
        }

        public String getClassName() {
            return RedisColumnTypeHelper.getClassName(this.typeName);
        }
    }
}

