/*
 * Decompiled with CFR 0.152.
 */
package jdbc.resultset;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import jdbc.RedisStatement;
import jdbc.client.structures.query.ColumnHint;
import jdbc.client.structures.query.RedisQuery;
import jdbc.client.structures.result.RedisListResult;
import jdbc.client.structures.result.RedisResultBase;
import jdbc.client.structures.result.SimpleType;
import jdbc.resultset.RedisResultSetBase;
import jdbc.resultset.RedisResultSetMetaData;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;

public class RedisListResultSet
extends RedisResultSetBase<SimpleType<?>, List<Object>, Object> {
    public RedisListResultSet(RedisStatement statement, @NotNull RedisListResult result) {
        super(statement, result);
    }

    @Override
    @NotNull
    protected List<RedisResultSetMetaData.ColumnMetaData> createResultColumns(@NotNull RedisResultBase<SimpleType<?>, List<Object>> result) {
        RedisQuery query = result.getQuery();
        ColumnHint columnHint = query.getColumnHint();
        String resultColumnName = "value";
        if (columnHint != null && columnHint.getName().equals(resultColumnName)) {
            resultColumnName = Utils.getColumnTitle(query.getCommand());
        }
        return Collections.singletonList(RedisResultSetMetaData.createColumn(resultColumnName, result.getType()));
    }

    @Override
    @NotNull
    protected List<Object> createRows(@NotNull List<Object> result) {
        return result;
    }

    @Override
    protected Object getResultObject(@NotNull Object row, String columnLabel) throws SQLException {
        int columnIndex = this.findResultColumn(columnLabel);
        return columnIndex == 1 ? row : null;
    }
}

