/*
 * Decompiled with CFR 0.152.
 */
package jdbc.properties;

import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import jdbc.properties.RedisDefaultConfig;

public class RedisDriverPropertyInfoHelper {
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String DATABASE = "database";
    public static final String CONNECTION_TIMEOUT = "connectionTimeout";
    public static final String SOCKET_TIMEOUT = "socketTimeout";
    public static final String BLOCKING_SOCKET_TIMEOUT = "blockingSocketTimeout";
    public static final String CLIENT_NAME = "clientName";
    public static final String MAX_ATTEMPTS = "maxAttempts";
    public static final String SSL = "ssl";
    public static final String VERIFY_SERVER_CERTIFICATE = "verifyServerCertificate";
    public static final String HOST_AND_PORT_MAPPING = "hostAndPortMapping";
    public static final String HOST_AND_PORT_MAPPING_DEFAULT = null;
    public static final String VERIFY_CONNECTION_MODE = "verifyConnectionMode";
    public static final boolean VERIFY_CONNECTION_MODE_DEFAULT = true;
    private static final String[] booleanChoices = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};

    private RedisDriverPropertyInfoHelper() {
    }

    public static DriverPropertyInfo[] getPropertyInfo() {
        ArrayList<DriverPropertyInfo> propInfos = new ArrayList<DriverPropertyInfo>();
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, USER, RedisDefaultConfig.CONFIG.getUser(), "ACL user.");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, PASSWORD, RedisDefaultConfig.CONFIG.getPassword(), "Password.");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, DATABASE, String.valueOf(RedisDefaultConfig.CONFIG.getDatabase()), "Database.");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, CONNECTION_TIMEOUT, String.valueOf(RedisDefaultConfig.CONFIG.getConnectionTimeoutMillis()), "Connection timeout in milliseconds.");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, SOCKET_TIMEOUT, String.valueOf(RedisDefaultConfig.CONFIG.getSocketTimeoutMillis()), "Socket timeout in milliseconds.");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, BLOCKING_SOCKET_TIMEOUT, String.valueOf(RedisDefaultConfig.CONFIG.getBlockingSocketTimeoutMillis()), "Socket timeout (in milliseconds) to use during blocking operation. Default is '0', which means to block forever.");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, CLIENT_NAME, RedisDefaultConfig.CONFIG.getClientName(), "Client name.");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, MAX_ATTEMPTS, String.valueOf(RedisDefaultConfig.CONFIG.getMaxAttempts()), "Maximum number of attempts (cluster only).");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, SSL, String.valueOf(RedisDefaultConfig.CONFIG.isSsl()), "Enable SSL.", booleanChoices);
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, VERIFY_SERVER_CERTIFICATE, String.valueOf(RedisDefaultConfig.CONFIG.isVerifyServerCertificate()), "Configure a connection that uses SSL but does not verify the identity of the server.", booleanChoices);
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, HOST_AND_PORT_MAPPING, HOST_AND_PORT_MAPPING_DEFAULT, "Host and port mapping.");
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, VERIFY_CONNECTION_MODE, String.valueOf(true), "Verify that the mode specified for a connection in the URL prefix matches the server mode (standalone, cluster, sentinel).", booleanChoices);
        return propInfos.toArray(new DriverPropertyInfo[0]);
    }

    private static void addPropInfo(ArrayList<DriverPropertyInfo> propInfos, String propName, String defaultVal, String description) {
        RedisDriverPropertyInfoHelper.addPropInfo(propInfos, propName, defaultVal, description, null);
    }

    private static void addPropInfo(ArrayList<DriverPropertyInfo> propInfos, String propName, String defaultVal, String description, String[] choices) {
        DriverPropertyInfo newProp = new DriverPropertyInfo(propName, defaultVal);
        newProp.description = description;
        if (choices != null) {
            newProp.choices = choices;
        }
        propInfos.add(newProp);
    }
}

