/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.structures.result;

import java.util.function.Function;
import java.util.function.Predicate;
import jdbc.client.structures.query.RedisQuery;
import jdbc.client.structures.result.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectTypeField<T> {
    private final String name;
    private final SimpleType<?> simpleType;
    private final Function<T, ?> getter;
    private final Predicate<RedisQuery> isPresent;

    <S> ObjectTypeField(@NotNull String name, @NotNull SimpleType<S> simpleType, @NotNull Function<T, S> getter, @Nullable Predicate<RedisQuery> isPresent) {
        this.name = name;
        this.simpleType = simpleType;
        this.getter = getter;
        this.isPresent = isPresent;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public SimpleType<?> getSimpleType() {
        return this.simpleType;
    }

    @NotNull
    public Function<T, ?> getGetter() {
        return this.getter;
    }

    public boolean isPresent(@NotNull RedisQuery query) {
        return this.isPresent == null || this.isPresent.test(query);
    }
}

