/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.structures.result;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.Predicate;
import jdbc.client.helpers.result.parser.converter.type.TypeFactory;
import jdbc.client.structures.query.RedisQuery;
import jdbc.client.structures.result.ObjectTypeField;
import jdbc.client.structures.result.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectType<T>
extends ArrayList<ObjectTypeField<T>> {
    private final ObjectTypeField<T> mainField;

    public ObjectType(@NotNull String mainFieldName) {
        this.mainField = new ObjectTypeField<Object>(mainFieldName, TypeFactory.STRING, e -> null, null);
        this.add(this.mainField);
    }

    public ObjectType() {
        this.mainField = null;
    }

    public <S> void add(@NotNull String name, @NotNull SimpleType<S> simpleType, @NotNull Function<T, S> getter, @Nullable Predicate<RedisQuery> isPresent) {
        this.add(new ObjectTypeField<T>(name, simpleType, getter, isPresent));
    }

    public <S> void add(@NotNull String name, @NotNull SimpleType<S> simpleType, @NotNull Function<T, S> getter) {
        this.add(name, simpleType, getter, (Predicate<RedisQuery>)null);
    }

    public <S, R> void add(@NotNull String name, @NotNull SimpleType<S> simpleType, @NotNull Function<T, R> getter, @NotNull Function<R, S> converter, @Nullable Predicate<RedisQuery> isPresent) {
        this.add(name, simpleType, converter.compose(getter), isPresent);
    }

    public <S, R> void add(@NotNull String name, @NotNull SimpleType<S> simpleType, @NotNull Function<T, R> getter, @NotNull Function<R, S> converter) {
        this.add(name, simpleType, getter, converter, null);
    }

    @Nullable
    public ObjectTypeField<T> getMainField() {
        return this.mainField;
    }
}

