/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.structures.query;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import jdbc.client.structures.query.ColumnHint;
import jdbc.client.structures.query.CompositeCommand;
import jdbc.client.structures.query.NodeHint;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.Protocol;

public class RedisQuery {
    private final CompositeCommand compositeCommand;
    private final String[] params;
    private Set<String> paramsSet;
    private final ColumnHint columnHint;
    private final NodeHint nodeHint;
    private final boolean isBlocking;

    public RedisQuery(@NotNull CompositeCommand compositeCommand, @NotNull String[] params, @Nullable ColumnHint columnHint, @Nullable NodeHint nodeHint, boolean isBlocking) {
        this.compositeCommand = compositeCommand;
        this.params = params;
        this.columnHint = columnHint;
        this.nodeHint = nodeHint;
        this.isBlocking = isBlocking;
    }

    @NotNull
    public CompositeCommand getCompositeCommand() {
        return this.compositeCommand;
    }

    @NotNull
    public Protocol.Command getCommand() {
        return this.compositeCommand.getCommand();
    }

    @NotNull
    public String[] getParams() {
        return this.params;
    }

    @Nullable
    public ColumnHint getColumnHint() {
        return this.columnHint;
    }

    @Nullable
    public NodeHint getNodeHint() {
        return this.nodeHint;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Nullable
    public String getSampleKey() {
        return null;
    }

    public boolean containsParam(@NotNull Protocol.Keyword paramKeyword) {
        if (this.paramsSet == null) {
            this.paramsSet = Arrays.stream(this.params).map(Utils::toUpperCase).collect(Collectors.toSet());
        }
        return this.paramsSet.contains(paramKeyword.name());
    }
}

