/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.structures.query;

import java.util.Objects;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.Rawable;

public class CompositeCommand {
    private final Protocol.Command command;
    private final String keyword;

    public CompositeCommand(@NotNull Protocol.Command command, @Nullable Rawable keyword) {
        this.command = command;
        this.keyword = Utils.getName(keyword);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CompositeCommand)) {
            return false;
        }
        CompositeCommand c2 = (CompositeCommand)o;
        return Objects.equals(c2.command, this.command) && Objects.equals(c2.keyword, this.keyword);
    }

    public int hashCode() {
        return this.command.hashCode() ^ (this.keyword == null ? 0 : this.keyword.hashCode());
    }

    @NotNull
    public Protocol.Command getCommand() {
        return this.command;
    }

    public String toString() {
        return this.keyword == null ? this.command.name() : String.format("%s %s", this.command.name(), this.keyword);
    }

    public static CompositeCommand create(@NotNull Protocol.Command command, @Nullable Rawable keyword) {
        return new CompositeCommand(command, keyword);
    }

    public static CompositeCommand create(@NotNull Protocol.Command command) {
        return CompositeCommand.create(command, null);
    }
}

