/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.impl.standalone;

import java.sql.SQLException;
import java.util.Properties;
import jdbc.client.impl.RedisJedisURIBase;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.HostAndPort;

public class RedisJedisURI
extends RedisJedisURIBase {
    public static final String PREFIX = "jdbc:redis://";
    private HostAndPort hostAndPort;

    public static boolean acceptsURL(String url) {
        return url != null && url.startsWith(PREFIX);
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return PREFIX;
    }

    public RedisJedisURI(String url, Properties info) throws SQLException {
        super(url, info);
    }

    @Override
    protected void setHostAndPort(@NotNull String hostAndPortBlock) {
        String host = "127.0.0.1";
        int port = 6379;
        if (!hostAndPortBlock.isEmpty()) {
            String[] hostAndPortParts = hostAndPortBlock.split(":", 2);
            if (hostAndPortParts.length == 1) {
                host = hostAndPortParts[0];
            } else {
                host = hostAndPortParts[0];
                port = Integer.parseInt(hostAndPortParts[1]);
            }
        }
        this.hostAndPort = new HostAndPort(Utils.adjustHost(host), port);
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }
}

