/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.impl.standalone;

import java.sql.SQLException;
import jdbc.client.RedisMode;
import jdbc.client.impl.RedisClientBase;
import jdbc.client.impl.standalone.RedisJedisURI;
import jdbc.client.structures.query.RedisQuery;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisException;

public class RedisJedisClient
extends RedisClientBase {
    private final Jedis jedis;

    public RedisJedisClient(@NotNull RedisJedisURI uri) throws SQLException {
        try {
            this.jedis = new Jedis(uri.getHostAndPort(), (JedisClientConfig)uri);
            this.jedis.connect();
        }
        catch (JedisException e) {
            throw RedisJedisClient.sqlWrap(e);
        }
    }

    public RedisJedisClient(@NotNull Connection connection) throws SQLException {
        try {
            this.jedis = new Jedis(connection);
        }
        catch (JedisException e) {
            throw RedisJedisClient.sqlWrap(e);
        }
    }

    @Override
    protected synchronized Object executeImpl(@NotNull RedisQuery query) {
        Protocol.Command command = query.getCommand();
        String[] params = query.getParams();
        return query.isBlocking() ? this.jedis.sendBlockingCommand((ProtocolCommand)command, params) : this.jedis.sendCommand((ProtocolCommand)command, params);
    }

    @Override
    protected synchronized String setDatabase(int index) {
        return this.jedis.select(index);
    }

    @Override
    public synchronized String getDatabase() {
        return Integer.toString(this.jedis.getDB());
    }

    @Override
    protected synchronized void doClose() {
        this.jedis.close();
    }

    @Override
    @NotNull
    public RedisMode getMode() {
        return RedisMode.STANDALONE;
    }
}

