/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.impl.cluster;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jdbc.client.impl.RedisJedisURIBase;
import jdbc.properties.RedisDefaultConfig;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.HostAndPort;

public class RedisJedisClusterURI
extends RedisJedisURIBase {
    public static final String PREFIX = "jdbc:redis:cluster://";
    private Set<HostAndPort> nodes;
    private int maxAttempts;

    public static boolean acceptsURL(String url) {
        return url != null && url.startsWith(PREFIX);
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return PREFIX;
    }

    public RedisJedisClusterURI(String url, Properties info) throws SQLException {
        super(url, info);
    }

    @Override
    protected void setHostAndPort(@NotNull String nodesBlock) {
        String[] nodesParts;
        HashSet<HostAndPort> nodes = new HashSet<HostAndPort>();
        for (String nodeBlock : nodesParts = nodesBlock.split(",")) {
            String host = "127.0.0.1";
            int port = 6379;
            if (!nodeBlock.isEmpty()) {
                String[] nodeParts = nodeBlock.split(":", 2);
                if (nodeParts.length == 1) {
                    host = nodeParts[0];
                } else {
                    host = nodeParts[0];
                    port = Integer.parseInt(nodeParts[1]);
                }
            }
            nodes.add(new HostAndPort(Utils.adjustHost(host), port));
        }
        this.nodes = nodes;
    }

    @Override
    protected void setCommonParameters(@NotNull Map<String, String> parameters, @Nullable Properties info) {
        super.setCommonParameters(parameters, info);
        this.maxAttempts = this.getInt(parameters, info, "maxAttempts", RedisDefaultConfig.CONFIG.getMaxAttempts());
    }

    public Set<HostAndPort> getNodes() {
        return this.nodes;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }
}

