/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.impl.cluster;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jdbc.client.RedisMode;
import jdbc.client.impl.RedisClientBase;
import jdbc.client.impl.RedisJedisURIBase;
import jdbc.client.impl.cluster.RedisJedisClusterURI;
import jdbc.client.impl.standalone.RedisJedisClient;
import jdbc.client.structures.query.NodeHint;
import jdbc.client.structures.query.RedisKeyPatternQuery;
import jdbc.client.structures.query.RedisQuery;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.JedisClusterHashTag;

public class RedisJedisClusterClient
extends RedisClientBase {
    private static final Set<Protocol.Command> UNSUPPORTED_COMMANDS = new HashSet<Protocol.Command>();
    private final JedisCluster jedisCluster;

    public RedisJedisClusterClient(@NotNull RedisJedisClusterURI uri) throws SQLException {
        try {
            this.jedisCluster = new JedisCluster(uri.getNodes(), (JedisClientConfig)uri, uri.getMaxAttempts(), (GenericObjectPoolConfig<Connection>)new RedisClientBase.SingleConnectionPoolConfig());
            RedisJedisClusterClient.checkClusterNodes(this.jedisCluster, uri.getHostAndPortMapper());
        }
        catch (JedisException e) {
            throw RedisJedisClusterClient.sqlWrap(e);
        }
    }

    private static void checkClusterNodes(@NotNull JedisCluster cluster, @Nullable RedisJedisURIBase.CompleteHostAndPortMapper hostAndPortMapper) throws JedisConnectionException {
        if (hostAndPortMapper == null) {
            return;
        }
        Set<String> nodeKeys = cluster.getClusterNodes().keySet();
        for (String nodeKey : nodeKeys) {
            HostAndPort nodeHostAndPort = HostAndPort.from(nodeKey);
            hostAndPortMapper.getHostAndPort(nodeHostAndPort);
        }
    }

    @Override
    public Object execute(@NotNull RedisQuery query) throws SQLException {
        NodeHint nodeHint = query.getNodeHint();
        if (nodeHint != null) {
            return this.execute(nodeHint.getHostAndPort(), query);
        }
        return super.execute(query);
    }

    private synchronized Object execute(@NotNull HostAndPort nodeHostAndPort, @NotNull RedisQuery query) throws SQLException {
        Connection nodeConnection = this.getNodeConnection(nodeHostAndPort);
        try (RedisJedisClient nodeClient = new RedisJedisClient(nodeConnection);){
            Object object = nodeClient.execute(query);
            return object;
        }
    }

    @NotNull
    private synchronized Connection getNodeConnection(@NotNull HostAndPort nodeHostAndPort) throws SQLException {
        Connection nodeConnection;
        String nodeKey = JedisClusterInfoCache.getNodeKey(nodeHostAndPort);
        Map<String, ConnectionPool> nodes = this.jedisCluster.getClusterNodes();
        ConnectionPool nodePool = nodes.get(nodeKey);
        Connection connection = nodeConnection = nodePool != null ? nodePool.getResource() : null;
        if (nodeConnection == null) {
            throw new SQLException(String.format("Cluster node not found: %s.", nodeHostAndPort));
        }
        return nodeConnection;
    }

    @Override
    protected Object executeImpl(@NotNull RedisKeyPatternQuery query) throws SQLException {
        RedisJedisClusterClient.checkSupportInClusterMode(query);
        return super.executeImpl(query);
    }

    private static void checkSupportInClusterMode(@NotNull RedisKeyPatternQuery query) throws SQLException {
        String keyPattern = query.getKeyPattern();
        if (keyPattern == null || !JedisClusterHashTag.isClusterCompliantMatchPattern(keyPattern)) {
            throw new SQLException(String.format("Cluster mode only supports the %s command with a pattern containing a hash-tag (curly-brackets enclosed string).", query.getCommand()));
        }
    }

    @Override
    protected synchronized Object executeImpl(@NotNull RedisQuery query) throws SQLException {
        RedisJedisClusterClient.checkSupportInClusterMode(query);
        String sampleKey = query.getSampleKey();
        Protocol.Command command = query.getCommand();
        String[] params = query.getParams();
        if (query.isBlocking()) {
            return sampleKey != null ? this.jedisCluster.sendBlockingCommand(sampleKey, (ProtocolCommand)command, params) : this.jedisCluster.sendBlockingCommand((ProtocolCommand)command, params);
        }
        return sampleKey != null ? this.jedisCluster.sendCommand(sampleKey, (ProtocolCommand)command, params) : this.jedisCluster.sendCommand((ProtocolCommand)command, params);
    }

    private static void checkSupportInClusterMode(@NotNull RedisQuery query) throws SQLException {
        Protocol.Command command = query.getCommand();
        if (UNSUPPORTED_COMMANDS.contains(command)) {
            throw new SQLException(String.format("Cluster mode does not support the %s command.", command));
        }
    }

    @Override
    protected String setDatabase(int index) {
        if (index == 0) {
            return "OK";
        }
        throw new JedisDataException("ERR DB index is out of range");
    }

    @Override
    public String getDatabase() {
        return "0";
    }

    @Override
    public synchronized void doClose() {
        this.jedisCluster.close();
    }

    @Override
    @NotNull
    public RedisMode getMode() {
        return RedisMode.CLUSTER;
    }

    static {
        UNSUPPORTED_COMMANDS.add(Protocol.Command.DBSIZE);
        UNSUPPORTED_COMMANDS.add(Protocol.Command.WAIT);
    }
}

