/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import jdbc.properties.RedisDefaultConfig;
import jdbc.utils.SSLUtils;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.HostAndPortMapper;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;

public abstract class RedisJedisURIBase
implements JedisClientConfig {
    private String user;
    private String password;
    private int database;
    private int connectionTimeout;
    private int socketTimeout;
    private int blockingSocketTimeout;
    private String clientName;
    private boolean ssl;
    private SSLSocketFactory sslSocketFactory;
    private CompleteHostAndPortMapper hostAndPortMapper;

    protected RedisJedisURIBase(String url, Properties info) throws SQLException {
        String hostAndPortBlock;
        String uri = this.extractURI(url);
        String authBlock = "";
        int atIndex = uri.indexOf(64);
        if (atIndex >= 0) {
            authBlock = uri.substring(0, atIndex);
            uri = uri.substring(atIndex + 1);
        }
        this.setAuth(authBlock, info);
        int slashIndex = uri.indexOf(47);
        int questionIndex = uri.indexOf(63);
        if (slashIndex >= 0) {
            hostAndPortBlock = uri.substring(0, slashIndex);
            uri = uri.substring(slashIndex + 1);
        } else if (questionIndex >= 0) {
            hostAndPortBlock = uri.substring(0, questionIndex);
            uri = uri.substring(questionIndex + 1);
        } else {
            hostAndPortBlock = uri;
            uri = "";
        }
        this.setHostAndPort(hostAndPortBlock);
        String databaseBlock = "";
        if (slashIndex >= 0) {
            questionIndex = uri.indexOf(63);
            if (questionIndex >= 0) {
                databaseBlock = uri.substring(0, questionIndex);
                uri = uri.substring(questionIndex + 1);
            } else {
                databaseBlock = uri;
                uri = "";
            }
        }
        this.setDatabase(databaseBlock, info);
        String parametersBlock = "";
        if (questionIndex >= 0) {
            parametersBlock = uri;
        }
        this.setParameters(parametersBlock, info);
        this.setHostAndPortMapping(info);
    }

    @NotNull
    private String extractURI(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Empty URL");
        }
        String prefix = this.getPrefix();
        if (!url.startsWith(prefix)) {
            throw new IllegalArgumentException(String.format("Incorrect URL: URL needs to start with %s", prefix));
        }
        return url.replaceFirst(prefix, "");
    }

    @NotNull
    protected abstract String getPrefix();

    private void setAuth(@NotNull String authBlock, Properties info) {
        String user = RedisDefaultConfig.CONFIG.getUser();
        String password = RedisDefaultConfig.CONFIG.getPassword();
        if (!authBlock.isEmpty()) {
            String[] authParts = authBlock.split(":", 2);
            if (authParts.length == 1) {
                password = authParts[0];
            } else {
                user = authParts[0];
                password = authParts[1];
            }
        }
        this.user = Utils.getString(info, "user", user);
        this.password = Utils.getString(info, "password", password);
    }

    protected abstract void setHostAndPort(@NotNull String var1);

    private void setDatabase(@NotNull String databaseBlock, Properties info) {
        int database = RedisDefaultConfig.CONFIG.getDatabase();
        if (!databaseBlock.isEmpty()) {
            database = Utils.parseDbIndex(databaseBlock);
        }
        this.database = Utils.getInt(info, "database", database);
    }

    private void setParameters(@NotNull String parametersBlock, Properties info) throws SQLException {
        String[] parametersParts;
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String parameterBlock : parametersParts = parametersBlock.split("&")) {
            String[] nodeParts;
            if (parameterBlock.isEmpty() || (nodeParts = parameterBlock.split("=", 2)).length != 2) continue;
            parameters.putIfAbsent(nodeParts[0], nodeParts[1]);
        }
        this.setCommonParameters(parameters, info);
        this.setSSLParameters(parameters, info);
    }

    protected void setCommonParameters(@NotNull Map<String, String> parameters, Properties info) {
        this.connectionTimeout = this.getInt(parameters, info, "connectionTimeout", RedisDefaultConfig.CONFIG.getConnectionTimeoutMillis());
        this.socketTimeout = this.getInt(parameters, info, "socketTimeout", RedisDefaultConfig.CONFIG.getSocketTimeoutMillis());
        this.blockingSocketTimeout = this.getInt(parameters, info, "blockingSocketTimeout", RedisDefaultConfig.CONFIG.getBlockingSocketTimeoutMillis());
        this.clientName = this.getString(parameters, info, "clientName", RedisDefaultConfig.CONFIG.getClientName());
    }

    private void setSSLParameters(@NotNull Map<String, String> parameters, Properties info) throws SSLUtils.SSLParamsException {
        boolean verifyServerCertificate;
        this.ssl = this.getBoolean(parameters, info, "ssl", RedisDefaultConfig.CONFIG.isSsl());
        if (this.ssl && !(verifyServerCertificate = this.getBoolean(parameters, info, "verifyServerCertificate", RedisDefaultConfig.CONFIG.isVerifyServerCertificate()))) {
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", "");
            String keyStoreUrl = System.getProperty("javax.net.ssl.keyStore", "");
            if (!Utils.isNullOrEmpty(keyStoreUrl)) {
                try {
                    new URL(keyStoreUrl);
                }
                catch (MalformedURLException e) {
                    keyStoreUrl = "file:" + keyStoreUrl;
                }
            }
            SSLContext context = SSLUtils.getTrustEverybodySSLContext(keyStoreUrl, keyStoreType, keyStorePassword);
            this.sslSocketFactory = context.getSocketFactory();
        }
    }

    protected String getString(Map<String, String> parameters, Properties info, String name, String defaultValue) {
        String parameter = Utils.getString(parameters, name, defaultValue);
        return Utils.getString(info, name, parameter);
    }

    protected int getInt(Map<String, String> parameters, Properties info, String name, int defaultValue) {
        int parameter = Utils.getInt(parameters, name, defaultValue);
        return Utils.getInt(info, name, parameter);
    }

    protected boolean getBoolean(Map<String, String> parameters, Properties info, String name, boolean defaultValue) {
        boolean parameter = Utils.getBoolean(parameters, name, defaultValue);
        return Utils.getBoolean(info, name, parameter);
    }

    private void setHostAndPortMapping(Properties info) {
        Map<HostAndPort, HostAndPort> mapping = Utils.getMap(info, "hostAndPortMapping", Utils::parseHostAndPort, Utils::parseHostAndPort);
        this.hostAndPortMapper = mapping == null ? null : new CompleteHostAndPortMapper(mapping);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public int getConnectionTimeoutMillis() {
        return this.connectionTimeout;
    }

    @Override
    public int getSocketTimeoutMillis() {
        return this.socketTimeout;
    }

    @Override
    public int getBlockingSocketTimeoutMillis() {
        return this.blockingSocketTimeout;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public CompleteHostAndPortMapper getHostAndPortMapper() {
        return this.hostAndPortMapper;
    }

    public static class CompleteHostAndPortMapper
    implements HostAndPortMapper {
        private final Map<HostAndPort, HostAndPort> mapping;

        public CompleteHostAndPortMapper(@NotNull Map<HostAndPort, HostAndPort> mapping) {
            this.mapping = mapping;
        }

        @Override
        public HostAndPort getHostAndPort(HostAndPort hap) throws JedisConnectionException {
            if (hap == null) {
                return null;
            }
            HostAndPort mappedHap = this.mapping.get(hap);
            if (mappedHap == null) {
                if (this.mapping.containsValue(hap)) {
                    return hap;
                }
                throw new JedisConnectionException(String.format("Port forwarding is not specified for %s.", hap));
            }
            return mappedHap;
        }
    }
}

