/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.impl;

import java.sql.SQLException;
import jdbc.client.RedisClient;
import jdbc.client.helpers.query.RedisQueryHelper;
import jdbc.client.helpers.result.RedisResultHelper;
import jdbc.client.structures.query.RedisKeyPatternQuery;
import jdbc.client.structures.query.RedisQuery;
import jdbc.client.structures.query.RedisSetDatabaseQuery;
import jdbc.client.structures.result.RedisResult;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.ConnectionPoolConfig;
import redis.clients.jedis.exceptions.JedisException;

public abstract class RedisClientBase
implements RedisClient {
    @Override
    public final RedisResult execute(String sql) throws SQLException {
        try {
            RedisQuery query = RedisQueryHelper.parseQuery(sql);
            Object data = this.execute(query);
            return RedisResultHelper.parseResult(query, data);
        }
        catch (JedisException e) {
            throw RedisClientBase.sqlWrap(e);
        }
    }

    public Object execute(@NotNull RedisQuery query) throws SQLException {
        if (query instanceof RedisSetDatabaseQuery) {
            return this.executeImpl((RedisSetDatabaseQuery)query);
        }
        if (query instanceof RedisKeyPatternQuery) {
            return this.executeImpl((RedisKeyPatternQuery)query);
        }
        return this.executeImpl(query);
    }

    private Object executeImpl(@NotNull RedisSetDatabaseQuery query) {
        return this.setDatabase(query.getDbIndex());
    }

    protected Object executeImpl(@NotNull RedisKeyPatternQuery query) throws SQLException {
        return this.executeImpl((RedisQuery)query);
    }

    protected abstract Object executeImpl(@NotNull RedisQuery var1) throws SQLException;

    @Override
    public final void setDatabase(String db) throws SQLException {
        try {
            this.setDatabase(Utils.parseSqlDbIndex(db));
        }
        catch (JedisException e) {
            throw RedisClientBase.sqlWrap(e);
        }
    }

    protected abstract String setDatabase(int var1);

    @Override
    public final void close() throws SQLException {
        try {
            this.doClose();
        }
        catch (JedisException e) {
            throw RedisClientBase.sqlWrap(e);
        }
    }

    protected abstract void doClose();

    protected static SQLException sqlWrap(@NotNull JedisException e) {
        Throwable[] suppressed;
        if (e.getCause() == null && (suppressed = e.getSuppressed()) != null && suppressed.length == 1) {
            return new SQLException(e.getMessage(), suppressed[0]);
        }
        return new SQLException(e);
    }

    protected static class SingleConnectionPoolConfig
    extends ConnectionPoolConfig {
        public SingleConnectionPoolConfig() {
            this.setMaxTotal(1);
        }
    }
}

