/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.result.parser.encoder;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdbc.client.helpers.result.parser.encoder.ListEncoder;
import jdbc.client.helpers.result.parser.encoder.MapEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.Module;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.resps.AccessControlLogEntry;
import redis.clients.jedis.resps.AccessControlUser;
import redis.clients.jedis.resps.CommandDocument;
import redis.clients.jedis.resps.CommandInfo;
import redis.clients.jedis.resps.FunctionStats;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.KeyedZSetElement;
import redis.clients.jedis.resps.LibraryInfo;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.resps.Slowlog;
import redis.clients.jedis.resps.StreamConsumersInfo;
import redis.clients.jedis.resps.StreamEntry;
import redis.clients.jedis.resps.StreamFullInfo;
import redis.clients.jedis.resps.StreamGroupInfo;
import redis.clients.jedis.resps.StreamInfo;
import redis.clients.jedis.resps.StreamPendingEntry;
import redis.clients.jedis.resps.StreamPendingSummary;
import redis.clients.jedis.resps.Tuple;
import redis.clients.jedis.util.KeyValue;

public class EncoderFactory {
    public static final ListEncoder<Object> OBJECT = new ElementListEncoder<Object>(){

        @Override
        @NotNull
        protected Builder<Object> getBuilder() {
            return BuilderFactory.ENCODED_OBJECT;
        }

        @Override
        @NotNull
        protected Builder<List<Object>> getListBuilder() {
            return BuilderFactory.ENCODED_OBJECT_LIST;
        }
    };
    public static final ListEncoder<String> STRING = new ElementListEncoder<String>(){

        @Override
        @NotNull
        protected Builder<String> getBuilder() {
            return BuilderFactory.STRING;
        }

        @Override
        @NotNull
        protected Builder<List<String>> getListBuilder() {
            return BuilderFactory.STRING_LIST;
        }
    };
    public static final ListEncoder<Long> LONG = new ElementListEncoder<Long>(){

        @Override
        @NotNull
        protected Builder<Long> getBuilder() {
            return BuilderFactory.LONG;
        }

        @Override
        @NotNull
        protected Builder<List<Long>> getListBuilder() {
            return BuilderFactory.LONG_LIST;
        }
    };
    public static final ListEncoder<Double> DOUBLE = new ElementListEncoder<Double>(){

        @Override
        @NotNull
        protected Builder<Double> getBuilder() {
            return BuilderFactory.DOUBLE;
        }

        @Override
        @NotNull
        protected Builder<List<Double>> getListBuilder() {
            return BuilderFactory.DOUBLE_LIST;
        }
    };
    public static final ListEncoder<Boolean> BOOLEAN = new ElementListEncoder<Boolean>(){

        @Override
        @NotNull
        protected Builder<Boolean> getBuilder() {
            return BuilderFactory.BOOLEAN;
        }

        @Override
        @NotNull
        protected Builder<List<Boolean>> getListBuilder() {
            return BuilderFactory.BOOLEAN_LIST;
        }
    };
    public static final ListEncoder<byte[]> BYTE_ARRAY = new ElementListEncoder<byte[]>(){

        @Override
        @NotNull
        protected Builder<byte[]> getBuilder() {
            return BuilderFactory.BYTE_ARRAY;
        }

        @Override
        @NotNull
        protected Builder<List<byte[]>> getListBuilder() {
            return BuilderFactory.BYTE_ARRAY_LIST;
        }
    };
    public static final MapEncoder<Object> OBJECT_MAP = new SimpleMapEncoder<Object>(){

        @Override
        @NotNull
        protected Builder<Map<String, Object>> getMapBuilder() {
            return BuilderFactory.ENCODED_OBJECT_MAP;
        }
    };
    public static final MapEncoder<String> STRING_MAP = new SimpleMapEncoder<String>(){

        @Override
        @NotNull
        protected Builder<Map<String, String>> getMapBuilder() {
            return BuilderFactory.STRING_MAP;
        }
    };
    public static final ListEncoder<KeyedListElement> KEYED_STRING = new ElementListEncoder<KeyedListElement>(){

        @Override
        @NotNull
        protected Builder<KeyedListElement> getBuilder() {
            return BuilderFactory.KEYED_LIST_ELEMENT;
        }
    };
    public static final ListEncoder<Tuple> TUPLE = new SimpleListEncoder<Tuple>(){

        @Override
        @NotNull
        protected Builder<List<Tuple>> getListBuilder() {
            return BuilderFactory.TUPLE_LIST;
        }
    };
    public static final ListEncoder<KeyedZSetElement> KEYED_TUPLE = new ElementListEncoder<KeyedZSetElement>(){

        @Override
        @NotNull
        protected Builder<KeyedZSetElement> getBuilder() {
            return BuilderFactory.KEYED_ZSET_ELEMENT;
        }
    };
    public static final ListEncoder<GeoCoordinate> GEO_COORDINATE = new SimpleListEncoder<GeoCoordinate>(){

        @Override
        @NotNull
        protected Builder<List<GeoCoordinate>> getListBuilder() {
            return BuilderFactory.GEO_COORDINATE_LIST;
        }
    };
    public static final ListEncoder<GeoRadiusResponse> GEORADIUS_RESPONSE = new SimpleListEncoder<GeoRadiusResponse>(){

        @Override
        @NotNull
        protected Builder<List<GeoRadiusResponse>> getListBuilder() {
            return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT;
        }
    };
    public static final ListEncoder<Module> MODULE = new SimpleListEncoder<Module>(){

        @Override
        @NotNull
        protected Builder<List<Module>> getListBuilder() {
            return BuilderFactory.MODULE_LIST;
        }
    };
    public static final ListEncoder<AccessControlUser> ACCESS_CONTROL_USER = new ElementListEncoder<AccessControlUser>(){

        @Override
        @NotNull
        protected Builder<AccessControlUser> getBuilder() {
            return BuilderFactory.ACCESS_CONTROL_USER;
        }
    };
    public static final ListEncoder<AccessControlLogEntry> ACCESS_CONTROL_LOG_ENTRY = new SimpleListEncoder<AccessControlLogEntry>(){

        @Override
        @NotNull
        protected Builder<List<AccessControlLogEntry>> getListBuilder() {
            return BuilderFactory.ACCESS_CONTROL_LOG_ENTRY_LIST;
        }
    };
    public static final MapEncoder<CommandDocument> COMMAND_DOCUMENT = new SimpleMapEncoder<CommandDocument>(){

        @Override
        @NotNull
        protected Builder<Map<String, CommandDocument>> getMapBuilder() {
            return BuilderFactory.COMMAND_DOCS_RESPONSE;
        }
    };
    public static final MapEncoder<CommandInfo> COMMAND_INFO = new SimpleMapEncoder<CommandInfo>(){

        @Override
        @NotNull
        protected Builder<Map<String, CommandInfo>> getMapBuilder() {
            return BuilderFactory.COMMAND_INFO_RESPONSE;
        }
    };
    public static final ListEncoder<FunctionStats> FUNCTION_STATS = new ElementListEncoder<FunctionStats>(){

        @Override
        @NotNull
        protected Builder<FunctionStats> getBuilder() {
            return FunctionStats.FUNCTION_STATS_BUILDER;
        }
    };
    public static final ListEncoder<LibraryInfo> LIBRARY_INFO = new SimpleListEncoder<LibraryInfo>(){

        @Override
        @NotNull
        protected Builder<List<LibraryInfo>> getListBuilder() {
            return BuilderFactory.LIBRARY_LIST;
        }
    };
    public static final ListEncoder<Slowlog> SLOW_LOG = new SimpleListEncoder<Slowlog>(){
        private final Builder<List<Slowlog>> SLOW_LOG_LIST = new Builder<List<Slowlog>>(){

            @Override
            public List<Slowlog> build(Object data) {
                return Slowlog.from(BuilderFactory.RAW_OBJECT_LIST.build(data));
            }

            public String toString() {
                return "List<SlowLog>";
            }
        };

        @Override
        @NotNull
        protected Builder<List<Slowlog>> getListBuilder() {
            return this.SLOW_LOG_LIST;
        }
    };
    public static final ListEncoder<StreamEntryID> STREAM_ENTRY_ID = new ElementListEncoder<StreamEntryID>(){

        @Override
        @NotNull
        protected Builder<StreamEntryID> getBuilder() {
            return BuilderFactory.STREAM_ENTRY_ID;
        }

        @Override
        @NotNull
        protected Builder<List<StreamEntryID>> getListBuilder() {
            return BuilderFactory.STREAM_ENTRY_ID_LIST;
        }
    };
    public static final ListEncoder<StreamEntry> STREAM_ENTRY = new SimpleListEncoder<StreamEntry>(){

        @Override
        @NotNull
        protected Builder<List<StreamEntry>> getListBuilder() {
            return BuilderFactory.STREAM_ENTRY_LIST;
        }
    };
    public static final ListEncoder<Map.Entry<String, List<StreamEntry>>> STREAM_READ_ENTRY = new SimpleListEncoder<Map.Entry<String, List<StreamEntry>>>(){

        @Override
        @NotNull
        protected Builder<List<Map.Entry<String, List<StreamEntry>>>> getListBuilder() {
            return BuilderFactory.STREAM_READ_RESPONSE;
        }
    };
    public static final ListEncoder<StreamConsumersInfo> STREAM_CONSUMER_INFO = new SimpleListEncoder<StreamConsumersInfo>(){

        @Override
        @NotNull
        protected Builder<List<StreamConsumersInfo>> getListBuilder() {
            return BuilderFactory.STREAM_CONSUMERS_INFO_LIST;
        }
    };
    public static final ListEncoder<StreamGroupInfo> STREAM_GROUP_INFO = new SimpleListEncoder<StreamGroupInfo>(){

        @Override
        @NotNull
        protected Builder<List<StreamGroupInfo>> getListBuilder() {
            return BuilderFactory.STREAM_GROUP_INFO_LIST;
        }
    };
    public static final ListEncoder<StreamInfo> STREAM_INFO = new ElementListEncoder<StreamInfo>(){

        @Override
        @NotNull
        protected Builder<StreamInfo> getBuilder() {
            return BuilderFactory.STREAM_INFO;
        }
    };
    public static final ListEncoder<StreamFullInfo> STREAM_INFO_FULL = new ElementListEncoder<StreamFullInfo>(){

        @Override
        @NotNull
        protected Builder<StreamFullInfo> getBuilder() {
            return BuilderFactory.STREAM_INFO_FULL;
        }
    };
    public static final ListEncoder<StreamPendingEntry> STREAM_PENDING_ENTRY = new SimpleListEncoder<StreamPendingEntry>(){

        @Override
        @NotNull
        protected Builder<List<StreamPendingEntry>> getListBuilder() {
            return BuilderFactory.STREAM_PENDING_ENTRY_LIST;
        }
    };
    public static final ListEncoder<StreamPendingSummary> STREAM_PENDING_SUMMARY = new ElementListEncoder<StreamPendingSummary>(){

        @Override
        @NotNull
        protected Builder<StreamPendingSummary> getBuilder() {
            return BuilderFactory.STREAM_PENDING_SUMMARY;
        }
    };
    public static final ListEncoder<KeyValue<String, List<String>>> KEYED_STRING_LIST = new ElementListEncoder<KeyValue<String, List<String>>>(){

        @Override
        @NotNull
        protected Builder<KeyValue<String, List<String>>> getBuilder() {
            return BuilderFactory.KEYED_STRING_LIST;
        }

        @Override
        @NotNull
        protected Builder<List<KeyValue<String, List<String>>>> getListBuilder() {
            return BuilderFactory.KEYED_STRING_LIST_LIST;
        }

        @Override
        protected boolean isElementList(@NotNull Object data) {
            if (!super.isElementList(data)) {
                return false;
            }
            List dataList = (List)data;
            return dataList.isEmpty() || dataList.get(0) instanceof List;
        }
    };
    public static final ListEncoder<KeyValue<String, List<Tuple>>> KEYED_TUPLE_LIST = new ElementListEncoder<KeyValue<String, List<Tuple>>>(){

        @Override
        @NotNull
        protected Builder<KeyValue<String, List<Tuple>>> getBuilder() {
            return BuilderFactory.KEYED_TUPLE_LIST;
        }
    };
    public static final ListEncoder<ScanResult<String>> STRING_SCAN_RESULT = new ElementListEncoder<ScanResult<String>>(){

        @Override
        @NotNull
        protected Builder<ScanResult<String>> getBuilder() {
            return BuilderFactory.SCAN_RESPONSE;
        }

        @Override
        public String toString() {
            return "ScanResult<String>";
        }
    };
    public static final ListEncoder<ScanResult<Tuple>> TUPLE_SCAN_RESULT = new ElementListEncoder<ScanResult<Tuple>>(){

        @Override
        @NotNull
        protected Builder<ScanResult<Tuple>> getBuilder() {
            return BuilderFactory.ZSCAN_RESPONSE;
        }

        @Override
        public String toString() {
            return "ScanResult<Tuple>";
        }
    };
    public static final ListEncoder<ScanResult<Map.Entry<String, String>>> ENTRY_SCAN_RESULT = new ElementListEncoder<ScanResult<Map.Entry<String, String>>>(){

        @Override
        @NotNull
        protected Builder<ScanResult<Map.Entry<String, String>>> getBuilder() {
            return BuilderFactory.HSCAN_RESPONSE;
        }

        @Override
        public String toString() {
            return "ScanResult<Map.Entry<String, String>>";
        }
    };

    private EncoderFactory() {
    }

    private static abstract class SimpleMapEncoder<T>
    extends MapEncoder<T> {
        private SimpleMapEncoder() {
        }

        @NotNull
        protected abstract Builder<Map<String, T>> getMapBuilder();

        @Override
        @NotNull
        public final Map<String, T> encode(Object data) {
            if (data == null) {
                return Collections.emptyMap();
            }
            return this.getMapBuilder().build(data);
        }

        public String toString() {
            return this.getMapBuilder().toString();
        }
    }

    private static abstract class SimpleListEncoder<T>
    extends ListEncoder<T> {
        private SimpleListEncoder() {
        }

        @NotNull
        protected abstract Builder<List<T>> getListBuilder();

        @Override
        @NotNull
        public final List<T> encode(Object data) {
            if (data == null) {
                return Collections.emptyList();
            }
            return this.getListBuilder().build(data);
        }

        public String toString() {
            return this.getListBuilder().toString();
        }
    }

    private static abstract class ElementListEncoder<T>
    extends ListEncoder<T> {
        private ElementListEncoder() {
        }

        @NotNull
        protected abstract Builder<T> getBuilder();

        @Nullable
        protected Builder<List<T>> getListBuilder() {
            return null;
        }

        protected boolean isElementList(@NotNull Object data) {
            return this.getListBuilder() != null && data instanceof List;
        }

        @Override
        @NotNull
        public List<T> encode(@Nullable Object data) {
            if (data == null) {
                return Collections.singletonList(null);
            }
            if (this.isElementList(data)) {
                return Objects.requireNonNull(this.getListBuilder()).build(data);
            }
            return Collections.singletonList(this.getBuilder().build(data));
        }

        public String toString() {
            return String.format("List<%s>", this.getBuilder());
        }
    }
}

