/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.result.parser.converter.type;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdbc.client.helpers.result.parser.converter.ConverterFactory;
import jdbc.client.structures.result.ObjectType;
import jdbc.client.structures.result.SimpleType;
import jdbc.utils.Utils;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.Module;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.resps.AccessControlLogEntry;
import redis.clients.jedis.resps.AccessControlUser;
import redis.clients.jedis.resps.CommandDocument;
import redis.clients.jedis.resps.CommandInfo;
import redis.clients.jedis.resps.FunctionStats;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.KeyedZSetElement;
import redis.clients.jedis.resps.LibraryInfo;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.resps.Slowlog;
import redis.clients.jedis.resps.StreamConsumerFullInfo;
import redis.clients.jedis.resps.StreamConsumersInfo;
import redis.clients.jedis.resps.StreamEntry;
import redis.clients.jedis.resps.StreamFullInfo;
import redis.clients.jedis.resps.StreamGroupFullInfo;
import redis.clients.jedis.resps.StreamGroupInfo;
import redis.clients.jedis.resps.StreamInfo;
import redis.clients.jedis.resps.StreamPendingEntry;
import redis.clients.jedis.resps.StreamPendingSummary;
import redis.clients.jedis.resps.Tuple;
import redis.clients.jedis.util.KeyValue;

public class TypeFactory {
    public static final SimpleType<Object> OBJECT = new SimpleType("object");
    public static final SimpleType<String> STRING = new SimpleType("string");
    public static final SimpleType<Integer> INT = new SimpleType("long");
    public static final SimpleType<Long> LONG = new SimpleType("long");
    public static final SimpleType<Double> DOUBLE = new SimpleType("double");
    public static final SimpleType<Boolean> BOOLEAN = new SimpleType("boolean");
    public static final SimpleType<byte[]> BYTE_ARRAY = new SimpleType("binary");
    public static final SimpleType<List<?>> LIST = new SimpleType("array");
    public static final SimpleType<Map<String, ?>> MAP = new SimpleType("map");
    public static final ObjectType<KeyedListElement> KEYED_STRING = new ObjectType<KeyedListElement>(){
        {
            this.add("key", STRING, AbstractMap.SimpleImmutableEntry::getKey);
            this.add("value", STRING, KeyedListElement::getElement);
        }
    };
    public static final ObjectType<Tuple> TUPLE = new ObjectType<Tuple>(){
        {
            this.add("value", STRING, Tuple::getElement);
            this.add("score", DOUBLE, Tuple::getScore);
        }
    };
    public static final ObjectType<KeyedZSetElement> KEYED_TUPLE = new ObjectType<KeyedZSetElement>(){
        {
            this.add("key", STRING, KeyedZSetElement::getKey);
            this.add("value", STRING, Tuple::getElement);
            this.add("score", DOUBLE, Tuple::getScore);
        }
    };
    public static final ObjectType<GeoCoordinate> GEO_COORDINATE = new ObjectType<GeoCoordinate>(){
        {
            this.add("longitude", DOUBLE, GeoCoordinate::getLongitude);
            this.add("latitude", DOUBLE, GeoCoordinate::getLatitude);
        }
    };
    public static final ObjectType<GeoRadiusResponse> GEORADIUS_RESPONSE = new ObjectType<GeoRadiusResponse>(){
        {
            this.add("member", STRING, GeoRadiusResponse::getMemberByString);
            this.add("distance", DOUBLE, GeoRadiusResponse::getDistance, Utils.param(Protocol.Keyword.WITHDIST));
            this.add("coordinate", MAP, GeoRadiusResponse::getCoordinate, ConverterFactory.GEO_COORDINATE::convert, Utils.param(Protocol.Keyword.WITHCOORD));
            this.add("raw-score", LONG, GeoRadiusResponse::getRawScore, Utils.param(Protocol.Keyword.WITHHASH));
        }
    };
    public static final ObjectType<Module> MODULE = new ObjectType<Module>(){
        {
            this.add("name", STRING, Module::getName);
            this.add("version", INT, Module::getVersion);
        }
    };
    public static final ObjectType<AccessControlUser> ACCESS_CONTROL_USER = new ObjectType<AccessControlUser>(){
        {
            this.add("flags", LIST, AccessControlUser::getFlags);
            this.add("keys", LIST, AccessControlUser::getKeys);
            this.add("passwords", LIST, AccessControlUser::getPassword);
            this.add("commands", STRING, AccessControlUser::getCommands);
        }
    };
    public static final ObjectType<AccessControlLogEntry> ACCESS_CONTROL_LOG_ENTRY = new ObjectType<AccessControlLogEntry>(){
        {
            this.add("count", LONG, AccessControlLogEntry::getCount);
            this.add("reason", STRING, AccessControlLogEntry::getReason);
            this.add("context", STRING, AccessControlLogEntry::getContext);
            this.add("object", STRING, AccessControlLogEntry::getObject);
            this.add("username", STRING, AccessControlLogEntry::getUsername);
            this.add("age-seconds", STRING, AccessControlLogEntry::getAgeSeconds);
            this.add("client-info", MAP, AccessControlLogEntry::getClientInfo);
        }
    };
    public static final ObjectType<CommandDocument> COMMAND_DOCUMENT = new ObjectType<CommandDocument>("command-name"){
        {
            this.add("summary", STRING, CommandDocument::getSummary);
            this.add("since", STRING, CommandDocument::getSince);
            this.add("group", STRING, CommandDocument::getGroup);
            this.add("complexity", STRING, CommandDocument::getComplexity);
            this.add("history", LIST, CommandDocument::getHistory);
        }
    };
    public static final ObjectType<CommandInfo> COMMAND_INFO = new ObjectType<CommandInfo>("command-name"){
        {
            this.add("arity", LONG, CommandInfo::getArity);
            this.add("flags", LIST, CommandInfo::getFlags);
            this.add("firstKey", LONG, CommandInfo::getFirstKey);
            this.add("lastKey", LONG, CommandInfo::getLastKey);
            this.add("step", LONG, CommandInfo::getStep);
            this.add("acl-categories", LIST, CommandInfo::getAclCategories);
            this.add("tips", LIST, CommandInfo::getTips);
            this.add("subcommands", LIST, CommandInfo::getSubcommands);
        }
    };
    public static final ObjectType<FunctionStats> FUNCTION_STATS = new ObjectType<FunctionStats>(){
        {
            this.add("running-script", MAP, FunctionStats::getRunningScript);
            this.add("engines", MAP, FunctionStats::getEngines);
        }
    };
    public static final ObjectType<LibraryInfo> LIBRARY_INFO = new ObjectType<LibraryInfo>(){
        {
            this.add("library-name", STRING, LibraryInfo::getLibraryName);
            this.add("engine", STRING, LibraryInfo::getEngine);
            this.add("functions", LIST, LibraryInfo::getFunctions);
            this.add("library-code", STRING, LibraryInfo::getLibraryCode, Utils.param(Protocol.Keyword.WITHCODE));
        }
    };
    public static final ObjectType<Slowlog> SLOW_LOG = new ObjectType<Slowlog>(){
        {
            this.add("id", LONG, Slowlog::getId);
            this.add("timestamp", LONG, Slowlog::getTimeStamp);
            this.add("execution-time", LONG, Slowlog::getExecutionTime);
            this.add("args", LIST, Slowlog::getArgs);
            this.add("client-ip-port", STRING, Slowlog::getClientIpPort, ConverterFactory.HOST_AND_PORT::convert);
            this.add("client-name", STRING, Slowlog::getClientName);
        }
    };
    public static final ObjectType<StreamEntry> STREAM_ENTRY = new ObjectType<StreamEntry>(){
        {
            this.add("id", STRING, e -> (String)ConverterFactory.STREAM_ENTRY_ID.convert(e.getID()));
            this.add("fields", MAP, StreamEntry::getFields);
        }
    };
    public static final ObjectType<Map.Entry<String, List<StreamEntry>>> STREAM_READ_ENTRY = new ObjectType<Map.Entry<String, List<StreamEntry>>>(){
        {
            this.add("key", STRING, Map.Entry::getKey);
            this.add("entries", LIST, Map.Entry::getValue, ConverterFactory.STREAM_ENTRY::convertList);
        }
    };
    public static final ObjectType<StreamConsumersInfo> STREAM_CONSUMER_INFO = new ObjectType<StreamConsumersInfo>(){
        {
            this.add("name", STRING, StreamConsumersInfo::getName);
            this.add("idle", LONG, StreamConsumersInfo::getIdle);
            this.add("pending", LONG, StreamConsumersInfo::getPending);
        }
    };
    public static final ObjectType<StreamConsumerFullInfo> STREAM_CONSUMER_INFO_FULL = new ObjectType<StreamConsumerFullInfo>(){
        {
            this.add("name", STRING, StreamConsumerFullInfo::getName);
            this.add("seen-time", LONG, StreamConsumerFullInfo::getSeenTime);
            this.add("pel-count", LONG, StreamConsumerFullInfo::getPelCount);
            this.add("pending", LIST, StreamConsumerFullInfo::getPending);
        }
    };
    public static final ObjectType<StreamGroupInfo> STREAM_GROUP_INFO = new ObjectType<StreamGroupInfo>(){
        {
            this.add("name", STRING, StreamGroupInfo::getName);
            this.add("consumers", LONG, StreamGroupInfo::getConsumers);
            this.add("pending", LONG, StreamGroupInfo::getPending);
            this.add("last-delivered-id", STRING, StreamGroupInfo::getLastDeliveredId, ConverterFactory.STREAM_ENTRY_ID::convert);
        }
    };
    public static final ObjectType<StreamGroupFullInfo> STREAM_GROUP_INFO_FULL = new ObjectType<StreamGroupFullInfo>(){
        {
            this.add("name", STRING, StreamGroupFullInfo::getName);
            this.add("consumers", LIST, StreamGroupFullInfo::getConsumers, ConverterFactory.STREAM_CONSUMER_INFO_FULL::convertList);
            this.add("pending", LIST, StreamGroupFullInfo::getPending);
            this.add("pel-count", LONG, StreamGroupFullInfo::getPelCount);
            this.add("last-delivered-id", STRING, StreamGroupFullInfo::getLastDeliveredId, ConverterFactory.STREAM_ENTRY_ID::convert);
        }
    };
    public static final ObjectType<StreamInfo> STREAM_INFO = new ObjectType<StreamInfo>(){
        {
            this.add("length", LONG, StreamInfo::getLength);
            this.add("radix-tree-keys", LONG, StreamInfo::getRadixTreeKeys);
            this.add("radix-tree-nodes", LONG, StreamInfo::getRadixTreeNodes);
            this.add("groups", LONG, StreamInfo::getGroups);
            this.add("last-generated-id", STRING, StreamInfo::getLastGeneratedId, ConverterFactory.STREAM_ENTRY_ID::convert);
            this.add("first-entry", MAP, StreamInfo::getFirstEntry, ConverterFactory.STREAM_ENTRY::convert);
            this.add("last-entry", MAP, StreamInfo::getLastEntry, ConverterFactory.STREAM_ENTRY::convert);
        }
    };
    public static final ObjectType<StreamFullInfo> STREAM_INFO_FULL = new ObjectType<StreamFullInfo>(){
        {
            this.add("length", LONG, StreamFullInfo::getLength);
            this.add("radix-tree-keys", LONG, StreamFullInfo::getRadixTreeKeys);
            this.add("radix-tree-nodes", LONG, StreamFullInfo::getRadixTreeNodes);
            this.add("groups", LIST, StreamFullInfo::getGroups, ConverterFactory.STREAM_GROUP_INFO_FULL::convertList);
            this.add("last-generated-id", STRING, StreamFullInfo::getLastGeneratedId, ConverterFactory.STREAM_ENTRY_ID::convert);
            this.add("entries", LIST, StreamFullInfo::getEntries, ConverterFactory.STREAM_ENTRY::convertList);
        }
    };
    public static final ObjectType<StreamPendingEntry> STREAM_PENDING_ENTRY = new ObjectType<StreamPendingEntry>(){
        {
            this.add("id", STRING, StreamPendingEntry::getID, ConverterFactory.STREAM_ENTRY_ID::convert);
            this.add("consumer-name", STRING, StreamPendingEntry::getConsumerName);
            this.add("idle-time", LONG, StreamPendingEntry::getIdleTime);
            this.add("delivered-times", LONG, StreamPendingEntry::getDeliveredTimes);
        }
    };
    public static final ObjectType<StreamPendingSummary> STREAM_PENDING_SUMMARY = new ObjectType<StreamPendingSummary>(){
        {
            this.add("total", LONG, StreamPendingSummary::getTotal);
            this.add("min-id", STRING, StreamPendingSummary::getMinId, ConverterFactory.STREAM_ENTRY_ID::convert);
            this.add("max-id", STRING, StreamPendingSummary::getMaxId, ConverterFactory.STREAM_ENTRY_ID::convert);
            this.add("consumer-message-count", MAP, StreamPendingSummary::getConsumerMessageCount);
        }
    };
    public static final ObjectType<KeyValue<String, List<String>>> KEYED_STRING_LIST = new KeyedListType<String>(){

        @Override
        protected Function<List<String>, List<?>> getValuesConverter() {
            return ConverterFactory.STRING::convertList;
        }
    };
    public static final ObjectType<KeyValue<String, List<Tuple>>> KEYED_TUPLE_LIST = new KeyedListType<Tuple>(){

        @Override
        protected Function<List<Tuple>, List<?>> getValuesConverter() {
            return ConverterFactory.TUPLE::convertList;
        }
    };
    public static final ObjectType<ScanResult<String>> STRING_SCAN_RESULT = new ScanResultType<String>(){

        @Override
        protected Function<List<String>, List<?>> getResultsConverter() {
            return ConverterFactory.STRING::convertList;
        }
    };
    public static final ObjectType<ScanResult<Tuple>> TUPLE_SCAN_RESULT = new ScanResultType<Tuple>(){

        @Override
        protected Function<List<Tuple>, List<?>> getResultsConverter() {
            return ConverterFactory.TUPLE::convertList;
        }
    };
    public static final ObjectType<Map.Entry<String, String>> ENTRY = new ObjectType<Map.Entry<String, String>>(){
        {
            this.add("field", STRING, Map.Entry::getKey);
            this.add("value", STRING, Map.Entry::getValue);
        }
    };
    public static final ObjectType<ScanResult<Map.Entry<String, String>>> ENTRY_SCAN_RESULT = new ScanResultType<Map.Entry<String, String>>(){

        @Override
        protected Function<List<Map.Entry<String, String>>, List<?>> getResultsConverter() {
            return ConverterFactory.ENTRY::convertList;
        }
    };

    private TypeFactory() {
    }

    private static abstract class ScanResultType<T>
    extends ObjectType<ScanResult<T>> {
        protected ScanResultType() {
            this.add("cursor", STRING, ScanResult::getCursor);
            this.add("results", LIST, ScanResult::getResult, this.getResultsConverter());
        }

        protected abstract Function<List<T>, List<?>> getResultsConverter();
    }

    private static abstract class KeyedListType<T>
    extends ObjectType<KeyValue<String, List<T>>> {
        protected KeyedListType() {
            this.add("key", STRING, AbstractMap.SimpleImmutableEntry::getKey);
            this.add("values", LIST, AbstractMap.SimpleImmutableEntry::getValue, this.getValuesConverter());
        }

        protected abstract Function<List<T>, List<?>> getValuesConverter();
    }
}

