/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.result.parser.converter;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import jdbc.client.helpers.result.parser.converter.Converter;
import jdbc.client.structures.result.ObjectType;
import jdbc.client.structures.result.ObjectTypeField;
import org.jetbrains.annotations.NotNull;

public abstract class ObjectConverter<T>
extends Converter<T, Map<String, Object>, List<Map<String, Object>>> {
    public abstract ObjectType<T> getObjectType();

    @Override
    @NotNull
    protected final Map<String, Object> convertImpl(@NotNull T encoded) {
        return this.getObjectType().stream().map(t -> new AbstractMap.SimpleImmutableEntry(t.getName(), t.getGetter().apply(encoded))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @NotNull
    protected final Map<String, Object> convertEntryImpl(@NotNull Map.Entry<String, T> encoded) {
        Object converted = this.convertImpl((Object)encoded.getValue());
        ObjectTypeField<T> mainField = this.getObjectType().getMainField();
        if (mainField != null) {
            converted.put(mainField.getName(), encoded.getKey());
        }
        return converted;
    }

    @Override
    @NotNull
    protected final List<Map<String, Object>> convertMapImpl(@NotNull Map<String, T> encoded) {
        return encoded.entrySet().stream().map(this::convertEntryImpl).collect(Collectors.toList());
    }
}

