/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.result.parser.converter;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class Converter<T, V, MV> {
    @Contract(value="null -> null; !null -> !null")
    public final V convert(T encoded) {
        return encoded != null ? (V)this.convertImpl(encoded) : null;
    }

    @NotNull
    protected abstract V convertImpl(@NotNull T var1);

    @Contract(value="null -> null; !null -> !null")
    public final List<V> convertList(List<T> encoded) {
        return encoded != null ? this.convertListImpl(encoded) : null;
    }

    @NotNull
    protected List<V> convertListImpl(@NotNull List<T> encoded) {
        return encoded.stream().map(this::convert).collect(Collectors.toList());
    }

    @Contract(value="null -> null; !null -> !null")
    public final MV convertMap(Map<String, T> encoded) {
        return encoded != null ? (MV)this.convertMapImpl(encoded) : null;
    }

    @NotNull
    protected abstract MV convertMapImpl(@NotNull Map<String, T> var1);
}

