/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.result.parser;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import jdbc.client.helpers.result.parser.ResultParser;
import jdbc.client.structures.query.RedisQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResultParserWrapper {
    private final ResultParser resultParser;
    private final Predicate<RedisQuery> isApplicable;

    private ResultParserWrapper(@NotNull ResultParser resultParser, @Nullable Predicate<RedisQuery> isApplicable) {
        this.resultParser = resultParser;
        this.isApplicable = isApplicable;
    }

    @NotNull
    public ResultParser getResultParser() {
        return this.resultParser;
    }

    public boolean isApplicable(@NotNull RedisQuery query) {
        return this.isApplicable == null || this.isApplicable.test(query);
    }

    public static ResultParserWrapper wrap(@NotNull ResultParser resultParser, @Nullable Predicate<RedisQuery> isApplicable) {
        return new ResultParserWrapper(resultParser, isApplicable);
    }

    public static ResultParserWrapper wrap(@NotNull ResultParser resultParser) {
        return ResultParserWrapper.wrap(resultParser, null);
    }

    public static List<ResultParserWrapper> wrapList(@NotNull ResultParser resultParser, @Nullable Predicate<RedisQuery> isApplicable) {
        return Collections.singletonList(ResultParserWrapper.wrap(resultParser, isApplicable));
    }

    public static List<ResultParserWrapper> wrapList(@NotNull ResultParser resultParser) {
        return ResultParserWrapper.wrapList(resultParser, null);
    }
}

