/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.result.parser;

import java.util.List;
import java.util.Map;
import jdbc.client.helpers.result.parser.ResultParser;
import jdbc.client.helpers.result.parser.converter.ConverterFactory;
import jdbc.client.helpers.result.parser.converter.ObjectConverter;
import jdbc.client.helpers.result.parser.converter.SimpleConverter;
import jdbc.client.helpers.result.parser.encoder.EncoderFactory;
import jdbc.client.helpers.result.parser.encoder.ListEncoder;
import jdbc.client.helpers.result.parser.encoder.MapEncoder;
import jdbc.client.structures.query.RedisQuery;
import jdbc.client.structures.result.ObjectType;
import jdbc.client.structures.result.RedisListResult;
import jdbc.client.structures.result.RedisMapResult;
import jdbc.client.structures.result.RedisObjectResult;
import jdbc.client.structures.result.SimpleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.Module;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.resps.AccessControlLogEntry;
import redis.clients.jedis.resps.AccessControlUser;
import redis.clients.jedis.resps.CommandDocument;
import redis.clients.jedis.resps.CommandInfo;
import redis.clients.jedis.resps.FunctionStats;
import redis.clients.jedis.resps.GeoRadiusResponse;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.KeyedZSetElement;
import redis.clients.jedis.resps.LibraryInfo;
import redis.clients.jedis.resps.ScanResult;
import redis.clients.jedis.resps.Slowlog;
import redis.clients.jedis.resps.StreamConsumersInfo;
import redis.clients.jedis.resps.StreamEntry;
import redis.clients.jedis.resps.StreamFullInfo;
import redis.clients.jedis.resps.StreamGroupInfo;
import redis.clients.jedis.resps.StreamInfo;
import redis.clients.jedis.resps.StreamPendingEntry;
import redis.clients.jedis.resps.StreamPendingSummary;
import redis.clients.jedis.resps.Tuple;
import redis.clients.jedis.util.KeyValue;

public class ResultParserFactory {
    public static final ResultParser OBJECT = new ListResultParser<Object, Object>(){

        @Override
        @NotNull
        protected ListEncoder<Object> getBuilder() {
            return EncoderFactory.OBJECT;
        }

        @Override
        @NotNull
        protected SimpleConverter<Object, Object> getConverter() {
            return ConverterFactory.OBJECT;
        }
    };
    public static final ResultParser STRING = new ListResultParser<String, String>(){

        @Override
        @NotNull
        protected ListEncoder<String> getBuilder() {
            return EncoderFactory.STRING;
        }

        @Override
        @NotNull
        protected SimpleConverter<String, String> getConverter() {
            return ConverterFactory.STRING;
        }
    };
    public static final ResultParser LONG = new ListResultParser<Long, Long>(){

        @Override
        @NotNull
        protected ListEncoder<Long> getBuilder() {
            return EncoderFactory.LONG;
        }

        @Override
        @NotNull
        protected SimpleConverter<Long, Long> getConverter() {
            return ConverterFactory.LONG;
        }
    };
    public static final ResultParser DOUBLE = new ListResultParser<Double, Double>(){

        @Override
        @NotNull
        protected ListEncoder<Double> getBuilder() {
            return EncoderFactory.DOUBLE;
        }

        @Override
        @NotNull
        protected SimpleConverter<Double, Double> getConverter() {
            return ConverterFactory.DOUBLE;
        }
    };
    public static final ResultParser BOOLEAN = new ListResultParser<Boolean, Boolean>(){

        @Override
        @NotNull
        protected ListEncoder<Boolean> getBuilder() {
            return EncoderFactory.BOOLEAN;
        }

        @Override
        @NotNull
        protected SimpleConverter<Boolean, Boolean> getConverter() {
            return ConverterFactory.BOOLEAN;
        }
    };
    public static final ResultParser BYTE_ARRAY = new ListResultParser<byte[], byte[]>(){

        @Override
        @NotNull
        protected ListEncoder<byte[]> getBuilder() {
            return EncoderFactory.BYTE_ARRAY;
        }

        @Override
        @NotNull
        protected SimpleConverter<byte[], byte[]> getConverter() {
            return ConverterFactory.BYTE_ARRAY;
        }
    };
    public static final ResultParser OBJECT_MAP = new MapResultParser<Object, Object>(){

        @Override
        @NotNull
        protected MapEncoder<Object> getBuilder() {
            return EncoderFactory.OBJECT_MAP;
        }

        @Override
        @NotNull
        protected SimpleConverter<Object, Object> getConverter() {
            return ConverterFactory.OBJECT;
        }
    };
    public static final ResultParser STRING_MAP = new MapResultParser<String, String>(){

        @Override
        @NotNull
        protected MapEncoder<String> getBuilder() {
            return EncoderFactory.STRING_MAP;
        }

        @Override
        @NotNull
        protected SimpleConverter<String, String> getConverter() {
            return ConverterFactory.STRING;
        }
    };
    public static final ResultParser KEYED_STRING = new ObjectListResultParser<KeyedListElement>(){

        @Override
        @NotNull
        protected ListEncoder<KeyedListElement> getBuilder() {
            return EncoderFactory.KEYED_STRING;
        }

        @Override
        @NotNull
        protected ObjectConverter<KeyedListElement> getConverter() {
            return ConverterFactory.KEYED_STRING;
        }
    };
    public static final ResultParser TUPLE = new ObjectListResultParser<Tuple>(){

        @Override
        @NotNull
        protected ListEncoder<Tuple> getBuilder() {
            return EncoderFactory.TUPLE;
        }

        @Override
        @NotNull
        protected ObjectConverter<Tuple> getConverter() {
            return ConverterFactory.TUPLE;
        }
    };
    public static final ResultParser KEYED_TUPLE = new ObjectListResultParser<KeyedZSetElement>(){

        @Override
        @NotNull
        protected ListEncoder<KeyedZSetElement> getBuilder() {
            return EncoderFactory.KEYED_TUPLE;
        }

        @Override
        @NotNull
        protected ObjectConverter<KeyedZSetElement> getConverter() {
            return ConverterFactory.KEYED_TUPLE;
        }
    };
    public static final ResultParser GEO_COORDINATE = new ObjectListResultParser<GeoCoordinate>(){

        @Override
        @NotNull
        protected ListEncoder<GeoCoordinate> getBuilder() {
            return EncoderFactory.GEO_COORDINATE;
        }

        @Override
        @NotNull
        protected ObjectConverter<GeoCoordinate> getConverter() {
            return ConverterFactory.GEO_COORDINATE;
        }
    };
    public static final ResultParser GEORADIUS_RESPONSE = new ObjectListResultParser<GeoRadiusResponse>(){

        @Override
        @NotNull
        protected ListEncoder<GeoRadiusResponse> getBuilder() {
            return EncoderFactory.GEORADIUS_RESPONSE;
        }

        @Override
        @NotNull
        protected ObjectConverter<GeoRadiusResponse> getConverter() {
            return ConverterFactory.GEORADIUS_RESPONSE;
        }
    };
    public static final ResultParser MODULE = new ObjectListResultParser<Module>(){

        @Override
        @NotNull
        protected ListEncoder<Module> getBuilder() {
            return EncoderFactory.MODULE;
        }

        @Override
        @NotNull
        protected ObjectConverter<Module> getConverter() {
            return ConverterFactory.MODULE;
        }
    };
    public static final ResultParser ACCESS_CONTROL_USER = new ObjectListResultParser<AccessControlUser>(){

        @Override
        @NotNull
        protected ListEncoder<AccessControlUser> getBuilder() {
            return EncoderFactory.ACCESS_CONTROL_USER;
        }

        @Override
        @NotNull
        protected ObjectConverter<AccessControlUser> getConverter() {
            return ConverterFactory.ACCESS_CONTROL_USER;
        }
    };
    public static final ResultParser ACCESS_CONTROL_LOG_ENTRY = new ObjectListResultParser<AccessControlLogEntry>(){

        @Override
        @NotNull
        protected ListEncoder<AccessControlLogEntry> getBuilder() {
            return EncoderFactory.ACCESS_CONTROL_LOG_ENTRY;
        }

        @Override
        @NotNull
        protected ObjectConverter<AccessControlLogEntry> getConverter() {
            return ConverterFactory.ACCESS_CONTROL_LOG_ENTRY;
        }
    };
    public static final ResultParser COMMAND_DOCUMENT = new ObjectMapResultParser<CommandDocument>(){

        @Override
        @NotNull
        protected MapEncoder<CommandDocument> getBuilder() {
            return EncoderFactory.COMMAND_DOCUMENT;
        }

        @Override
        @NotNull
        protected ObjectConverter<CommandDocument> getConverter() {
            return ConverterFactory.COMMAND_DOCUMENT;
        }
    };
    public static final ResultParser COMMAND_INFO = new ObjectMapResultParser<CommandInfo>(){

        @Override
        @NotNull
        protected MapEncoder<CommandInfo> getBuilder() {
            return EncoderFactory.COMMAND_INFO;
        }

        @Override
        @NotNull
        protected ObjectConverter<CommandInfo> getConverter() {
            return ConverterFactory.COMMAND_INFO;
        }
    };
    public static final ResultParser FUNCTION_STATS = new ObjectListResultParser<FunctionStats>(){

        @Override
        @NotNull
        protected ListEncoder<FunctionStats> getBuilder() {
            return EncoderFactory.FUNCTION_STATS;
        }

        @Override
        @NotNull
        protected ObjectConverter<FunctionStats> getConverter() {
            return ConverterFactory.FUNCTION_STATS;
        }
    };
    public static final ResultParser LIBRARY_INFO = new ObjectListResultParser<LibraryInfo>(){

        @Override
        @NotNull
        protected ListEncoder<LibraryInfo> getBuilder() {
            return EncoderFactory.LIBRARY_INFO;
        }

        @Override
        @NotNull
        protected ObjectConverter<LibraryInfo> getConverter() {
            return ConverterFactory.LIBRARY_INFO;
        }
    };
    public static final ResultParser SLOW_LOG = new ObjectListResultParser<Slowlog>(){

        @Override
        @NotNull
        protected ListEncoder<Slowlog> getBuilder() {
            return EncoderFactory.SLOW_LOG;
        }

        @Override
        @NotNull
        protected ObjectConverter<Slowlog> getConverter() {
            return ConverterFactory.SLOW_LOG;
        }
    };
    public static final ResultParser STREAM_ENTRY_ID = new ListResultParser<StreamEntryID, String>(){

        @Override
        @NotNull
        protected ListEncoder<StreamEntryID> getBuilder() {
            return EncoderFactory.STREAM_ENTRY_ID;
        }

        @Override
        @NotNull
        protected SimpleConverter<StreamEntryID, String> getConverter() {
            return ConverterFactory.STREAM_ENTRY_ID;
        }
    };
    public static final ResultParser STREAM_ENTRY = new ObjectListResultParser<StreamEntry>(){

        @Override
        @NotNull
        protected ListEncoder<StreamEntry> getBuilder() {
            return EncoderFactory.STREAM_ENTRY;
        }

        @Override
        @NotNull
        protected ObjectConverter<StreamEntry> getConverter() {
            return ConverterFactory.STREAM_ENTRY;
        }
    };
    public static final ResultParser STREAM_READ = new ObjectListResultParser<Map.Entry<String, List<StreamEntry>>>(){

        @Override
        @NotNull
        protected ListEncoder<Map.Entry<String, List<StreamEntry>>> getBuilder() {
            return EncoderFactory.STREAM_READ_ENTRY;
        }

        @Override
        @NotNull
        protected ObjectConverter<Map.Entry<String, List<StreamEntry>>> getConverter() {
            return ConverterFactory.STREAM_READ_ENTRY;
        }
    };
    public static final ResultParser STREAM_CONSUMER_INFO = new ObjectListResultParser<StreamConsumersInfo>(){

        @Override
        @NotNull
        protected ListEncoder<StreamConsumersInfo> getBuilder() {
            return EncoderFactory.STREAM_CONSUMER_INFO;
        }

        @Override
        @NotNull
        protected ObjectConverter<StreamConsumersInfo> getConverter() {
            return ConverterFactory.STREAM_CONSUMER_INFO;
        }
    };
    public static final ResultParser STREAM_GROUP_INFO = new ObjectListResultParser<StreamGroupInfo>(){

        @Override
        @NotNull
        protected ListEncoder<StreamGroupInfo> getBuilder() {
            return EncoderFactory.STREAM_GROUP_INFO;
        }

        @Override
        @NotNull
        protected ObjectConverter<StreamGroupInfo> getConverter() {
            return ConverterFactory.STREAM_GROUP_INFO;
        }
    };
    public static final ResultParser STREAM_INFO = new ObjectListResultParser<StreamInfo>(){

        @Override
        @NotNull
        protected ListEncoder<StreamInfo> getBuilder() {
            return EncoderFactory.STREAM_INFO;
        }

        @Override
        @NotNull
        protected ObjectConverter<StreamInfo> getConverter() {
            return ConverterFactory.STREAM_INFO;
        }
    };
    public static final ResultParser STREAM_INFO_FULL = new ObjectListResultParser<StreamFullInfo>(){

        @Override
        @NotNull
        protected ListEncoder<StreamFullInfo> getBuilder() {
            return EncoderFactory.STREAM_INFO_FULL;
        }

        @Override
        @NotNull
        protected ObjectConverter<StreamFullInfo> getConverter() {
            return ConverterFactory.STREAM_INFO_FULL;
        }
    };
    public static final ResultParser STREAM_PENDING_ENTRY = new ObjectListResultParser<StreamPendingEntry>(){

        @Override
        @NotNull
        protected ListEncoder<StreamPendingEntry> getBuilder() {
            return EncoderFactory.STREAM_PENDING_ENTRY;
        }

        @Override
        @NotNull
        protected ObjectConverter<StreamPendingEntry> getConverter() {
            return ConverterFactory.STREAM_PENDING_ENTRY;
        }
    };
    public static final ResultParser STREAM_PENDING_SUMMARY = new ObjectListResultParser<StreamPendingSummary>(){

        @Override
        @NotNull
        protected ListEncoder<StreamPendingSummary> getBuilder() {
            return EncoderFactory.STREAM_PENDING_SUMMARY;
        }

        @Override
        @NotNull
        protected ObjectConverter<StreamPendingSummary> getConverter() {
            return ConverterFactory.STREAM_PENDING_SUMMARY;
        }
    };
    public static final ResultParser KEYED_STRING_LIST = new ObjectListResultParser<KeyValue<String, List<String>>>(){

        @Override
        @NotNull
        protected ListEncoder<KeyValue<String, List<String>>> getBuilder() {
            return EncoderFactory.KEYED_STRING_LIST;
        }

        @Override
        @NotNull
        protected ObjectConverter<KeyValue<String, List<String>>> getConverter() {
            return ConverterFactory.KEYED_STRING_LIST;
        }
    };
    public static final ResultParser KEYED_TUPLE_LIST = new ObjectListResultParser<KeyValue<String, List<Tuple>>>(){

        @Override
        @NotNull
        protected ListEncoder<KeyValue<String, List<Tuple>>> getBuilder() {
            return EncoderFactory.KEYED_TUPLE_LIST;
        }

        @Override
        @NotNull
        protected ObjectConverter<KeyValue<String, List<Tuple>>> getConverter() {
            return ConverterFactory.KEYED_TUPLE_LIST;
        }
    };
    public static final ResultParser STRING_SCAN_RESULT = new ObjectListResultParser<ScanResult<String>>(){

        @Override
        @NotNull
        protected ListEncoder<ScanResult<String>> getBuilder() {
            return EncoderFactory.STRING_SCAN_RESULT;
        }

        @Override
        @NotNull
        protected ObjectConverter<ScanResult<String>> getConverter() {
            return ConverterFactory.STRING_SCAN_RESULT;
        }
    };
    public static final ResultParser TUPLE_SCAN_RESULT = new ObjectListResultParser<ScanResult<Tuple>>(){

        @Override
        @NotNull
        protected ListEncoder<ScanResult<Tuple>> getBuilder() {
            return EncoderFactory.TUPLE_SCAN_RESULT;
        }

        @Override
        @NotNull
        protected ObjectConverter<ScanResult<Tuple>> getConverter() {
            return ConverterFactory.TUPLE_SCAN_RESULT;
        }
    };
    public static final ResultParser ENTRY_SCAN_RESULT = new ObjectListResultParser<ScanResult<Map.Entry<String, String>>>(){

        @Override
        @NotNull
        protected ListEncoder<ScanResult<Map.Entry<String, String>>> getBuilder() {
            return EncoderFactory.ENTRY_SCAN_RESULT;
        }

        @Override
        @NotNull
        protected ObjectConverter<ScanResult<Map.Entry<String, String>>> getConverter() {
            return ConverterFactory.ENTRY_SCAN_RESULT;
        }
    };

    private static abstract class ObjectMapResultParser<T>
    implements ResultParser {
        private ObjectMapResultParser() {
        }

        @NotNull
        protected abstract MapEncoder<T> getBuilder();

        @NotNull
        protected abstract ObjectConverter<T> getConverter();

        @NotNull
        protected final ObjectType<T> getType() {
            return this.getConverter().getObjectType();
        }

        @Override
        @NotNull
        public final RedisObjectResult parse(@NotNull RedisQuery query, @Nullable Object data) {
            Map encoded = (Map)this.getBuilder().encode(data);
            List converted = (List)this.getConverter().convertMap(encoded);
            return new RedisObjectResult(query, this.getType(), converted);
        }
    }

    private static abstract class ObjectListResultParser<T>
    implements ResultParser {
        private ObjectListResultParser() {
        }

        @NotNull
        protected abstract ListEncoder<T> getBuilder();

        @NotNull
        protected abstract ObjectConverter<T> getConverter();

        @NotNull
        protected final ObjectType<T> getType() {
            return this.getConverter().getObjectType();
        }

        @Override
        @NotNull
        public final RedisObjectResult parse(@NotNull RedisQuery query, @Nullable Object data) {
            List encoded = (List)this.getBuilder().encode(data);
            List<Map<String, Object>> converted = this.getConverter().convertList(encoded);
            return new RedisObjectResult(query, this.getType(), converted);
        }
    }

    private static abstract class MapResultParser<T, S>
    implements ResultParser {
        private MapResultParser() {
        }

        @NotNull
        protected abstract MapEncoder<T> getBuilder();

        @NotNull
        protected abstract SimpleConverter<T, S> getConverter();

        @NotNull
        protected final SimpleType<S> getType() {
            return this.getConverter().getSimpleType();
        }

        @Override
        @NotNull
        public final RedisMapResult parse(@NotNull RedisQuery query, @Nullable Object data) {
            Map encoded = (Map)this.getBuilder().encode(data);
            Map converted = (Map)this.getConverter().convertMap(encoded);
            return new RedisMapResult(query, this.getType(), converted);
        }
    }

    private static abstract class ListResultParser<T, S>
    implements ResultParser {
        private ListResultParser() {
        }

        @NotNull
        protected abstract ListEncoder<T> getBuilder();

        @NotNull
        protected abstract SimpleConverter<T, S> getConverter();

        @NotNull
        protected final SimpleType<S> getType() {
            return this.getConverter().getSimpleType();
        }

        @Override
        @NotNull
        public final RedisListResult parse(@NotNull RedisQuery query, @Nullable Object data) {
            List encoded = (List)this.getBuilder().encode(data);
            List<Object> converted = this.getConverter().convertList(encoded);
            return new RedisListResult(query, this.getType(), converted);
        }
    }
}

