/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.result;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import jdbc.client.helpers.result.parser.ResultParser;
import jdbc.client.helpers.result.parser.ResultParserFactory;
import jdbc.client.helpers.result.parser.ResultParserWrapper;
import jdbc.client.structures.query.CompositeCommand;
import jdbc.client.structures.query.RedisQuery;
import jdbc.client.structures.result.RedisResult;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.Protocol;

public class RedisResultHelper {
    private static final Map<CompositeCommand, List<ResultParserWrapper>> RESULT_PARSERS = new HashMap<CompositeCommand, List<ResultParserWrapper>>(){
        {
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.CAT), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.DELUSER), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.DRYRUN), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.GENPASS), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.GETUSER), ResultParserWrapper.wrapList(ResultParserFactory.ACCESS_CONTROL_USER));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.LIST), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.LOAD), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.LOG), ResultParserWrapper.wrapList(ResultParserFactory.ACCESS_CONTROL_LOG_ENTRY));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.SAVE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.SETUSER), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.USERS), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ACL, Protocol.Keyword.WHOAMI), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.APPEND), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.AUTH), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.BGREWRITEAOF), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.BGSAVE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.BITCOUNT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.BITFIELD), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.BITFIELD_RO), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.BITOP), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.BITPOS), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.BLMOVE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.BLMPOP), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_STRING_LIST));
            this.put(CompositeCommand.create(Protocol.Command.BLPOP), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_STRING));
            this.put(CompositeCommand.create(Protocol.Command.BRPOP), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_STRING));
            this.put(CompositeCommand.create(Protocol.Command.BRPOPLPUSH), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.BZMPOP), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_TUPLE_LIST));
            this.put(CompositeCommand.create(Protocol.Command.BZPOPMAX), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_TUPLE));
            this.put(CompositeCommand.create(Protocol.Command.BZPOPMIN), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_TUPLE));
            this.put(CompositeCommand.create(Protocol.Command.CLIENT, Protocol.Keyword.GETNAME), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.CLIENT, Protocol.Keyword.ID), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.CLIENT, Protocol.Keyword.INFO), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.CLIENT, Protocol.Keyword.KILL), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.STRING, Utils.length(3)), ResultParserWrapper.wrap(ResultParserFactory.LONG)));
            this.put(CompositeCommand.create(Protocol.Command.CLIENT, Protocol.Keyword.LIST), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.CLIENT, Protocol.Keyword.PAUSE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.CLIENT, Protocol.Keyword.SETNAME), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.CLIENT, Protocol.Keyword.UNBLOCK), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.COMMAND, Protocol.Keyword.COUNT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.COMMAND, Protocol.Keyword.DOCS), ResultParserWrapper.wrapList(ResultParserFactory.COMMAND_DOCUMENT));
            this.put(CompositeCommand.create(Protocol.Command.COMMAND, Protocol.Keyword.GETKEYS), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.COMMAND, Protocol.Keyword.GETKEYSANDFLAGS), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_STRING_LIST));
            this.put(CompositeCommand.create(Protocol.Command.COMMAND, Protocol.Keyword.INFO), ResultParserWrapper.wrapList(ResultParserFactory.COMMAND_INFO));
            this.put(CompositeCommand.create(Protocol.Command.COMMAND, Protocol.Keyword.LIST), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.CONFIG, Protocol.Keyword.GET), ResultParserWrapper.wrapList(ResultParserFactory.STRING_MAP));
            this.put(CompositeCommand.create(Protocol.Command.CONFIG, Protocol.Keyword.RESETSTAT), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.CONFIG, Protocol.Keyword.REWRITE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.CONFIG, Protocol.Keyword.SET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.COPY), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.DBSIZE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.DECR), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.DECRBY), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.DEL), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.DISCARD), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.DUMP), ResultParserWrapper.wrapList(ResultParserFactory.BYTE_ARRAY));
            this.put(CompositeCommand.create(Protocol.Command.ECHO), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.EVAL), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT));
            this.put(CompositeCommand.create(Protocol.Command.EVAL_RO), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT));
            this.put(CompositeCommand.create(Protocol.Command.EVALSHA), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT));
            this.put(CompositeCommand.create(Protocol.Command.EVAL_RO), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT));
            this.put(CompositeCommand.create(Protocol.Command.EXEC), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT));
            this.put(CompositeCommand.create(Protocol.Command.EXISTS), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.EXPIRE), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.EXPIREAT), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.EXPIRETIME), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.FCALL), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT));
            this.put(CompositeCommand.create(Protocol.Command.FCALL_RO), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT));
            this.put(CompositeCommand.create(Protocol.Command.FLUSHALL), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.FLUSHDB), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.FUNCTION, Protocol.Keyword.DELETE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.FUNCTION, Protocol.Keyword.DUMP), ResultParserWrapper.wrapList(ResultParserFactory.BYTE_ARRAY));
            this.put(CompositeCommand.create(Protocol.Command.FUNCTION, Protocol.Keyword.FLUSH), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.FUNCTION, Protocol.Keyword.KILL), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.FUNCTION, Protocol.Keyword.LIST), ResultParserWrapper.wrapList(ResultParserFactory.LIBRARY_INFO));
            this.put(CompositeCommand.create(Protocol.Command.FUNCTION, Protocol.Keyword.LOAD), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.FUNCTION, Protocol.Keyword.STATS), ResultParserWrapper.wrapList(ResultParserFactory.FUNCTION_STATS));
            this.put(CompositeCommand.create(Protocol.Command.GEOADD), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.GEODIST), ResultParserWrapper.wrapList(ResultParserFactory.DOUBLE));
            this.put(CompositeCommand.create(Protocol.Command.GEOHASH), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.GEOPOS), ResultParserWrapper.wrapList(ResultParserFactory.GEO_COORDINATE));
            this.put(CompositeCommand.create(Protocol.Command.GEORADIUS), ResultParserWrapper.wrapList(ResultParserFactory.GEORADIUS_RESPONSE));
            this.put(CompositeCommand.create(Protocol.Command.GEORADIUS_RO), ResultParserWrapper.wrapList(ResultParserFactory.GEORADIUS_RESPONSE));
            this.put(CompositeCommand.create(Protocol.Command.GEORADIUSBYMEMBER), ResultParserWrapper.wrapList(ResultParserFactory.GEORADIUS_RESPONSE));
            this.put(CompositeCommand.create(Protocol.Command.GEORADIUSBYMEMBER_RO), ResultParserWrapper.wrapList(ResultParserFactory.GEORADIUS_RESPONSE));
            this.put(CompositeCommand.create(Protocol.Command.GEOSEARCH), ResultParserWrapper.wrapList(ResultParserFactory.GEORADIUS_RESPONSE));
            this.put(CompositeCommand.create(Protocol.Command.GEOSEARCHSTORE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.GET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.GETBIT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.GETDEL), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.GETEX), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.GETRANGE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.GETSET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.HDEL), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.HEXISTS), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.HGET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.HGETALL), ResultParserWrapper.wrapList(ResultParserFactory.STRING_MAP));
            this.put(CompositeCommand.create(Protocol.Command.HINCRBY), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.HINCRBYFLOAT), ResultParserWrapper.wrapList(ResultParserFactory.DOUBLE));
            this.put(CompositeCommand.create(Protocol.Command.HKEYS), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.HLEN), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.HRANDFIELD), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.STRING_MAP, Utils.param(Protocol.Keyword.WITHVALUES)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.HSCAN), ResultParserWrapper.wrapList(ResultParserFactory.ENTRY_SCAN_RESULT));
            this.put(CompositeCommand.create(Protocol.Command.HSET), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.HSETNX), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.HSTRLEN), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.HVALS), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.INCR), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.INCRBY), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.INCRBYFLOAT), ResultParserWrapper.wrapList(ResultParserFactory.DOUBLE));
            this.put(CompositeCommand.create(Protocol.Command.INFO), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.KEYS), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.LASTSAVE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.LINDEX), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.LINSERT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.LLEN), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.LMOVE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.LMPOP), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_STRING_LIST));
            this.put(CompositeCommand.create(Protocol.Command.LOLWUT), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.LPOP), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.LPOS), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.LPUSH), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.LPUSHX), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.LRANGE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.LREM), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.LSET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.LTRIM), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MEMORY, Protocol.Keyword.DOCTOR), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MEMORY, Protocol.Keyword.PURGE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MEMORY, Protocol.Keyword.STATS), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT_MAP));
            this.put(CompositeCommand.create(Protocol.Command.MEMORY, Protocol.Keyword.USAGE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.MGET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MIGRATE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MODULE, Protocol.Keyword.LIST), ResultParserWrapper.wrapList(ResultParserFactory.MODULE));
            this.put(CompositeCommand.create(Protocol.Command.MODULE, Protocol.Keyword.LOAD), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MODULE, Protocol.Keyword.UNLOAD), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MONITOR), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MOVE), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.MSET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.MSETNX), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.MULTI), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.OBJECT, Protocol.Keyword.ENCODING), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.OBJECT, Protocol.Keyword.FREQ), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.OBJECT, Protocol.Keyword.IDLETIME), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.OBJECT, Protocol.Keyword.REFCOUNT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.PERSIST), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.PEXPIRE), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.PEXPIREAT), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.PEXPIRETIME), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.PFADD), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.PFCOUNT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.PFMERGE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.PING), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.PSETEX), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.PTTL), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.PUBLISH), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.PUBSUB, Protocol.Keyword.CHANNELS), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.PUBSUB, Protocol.Keyword.NUMPAT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.QUIT), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.RANDOMKEY), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.RENAME), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.RENAMENX), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.REPLICAOF), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.RESTORE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ROLE), ResultParserWrapper.wrapList(ResultParserFactory.OBJECT));
            this.put(CompositeCommand.create(Protocol.Command.RPOP), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.RPOPLPUSH), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.RPUSH), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.RPUSHX), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SADD), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SCAN), ResultParserWrapper.wrapList(ResultParserFactory.STRING_SCAN_RESULT));
            this.put(CompositeCommand.create(Protocol.Command.SCARD), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SCRIPT, Protocol.Keyword.EXISTS), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.SCRIPT, Protocol.Keyword.FLUSH), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SCRIPT, Protocol.Keyword.KILL), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SCRIPT, Protocol.Keyword.LOAD), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SDIFF), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SDIFFSTORE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SETBIT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SETEX), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SETNX), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.SETRANGE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SHUTDOWN), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SINTER), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SINTERCARD), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SINTERSTORE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SISMEMBER), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.SLAVEOF), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SLOWLOG, Protocol.Keyword.GET), ResultParserWrapper.wrapList(ResultParserFactory.SLOW_LOG));
            this.put(CompositeCommand.create(Protocol.Command.SLOWLOG, Protocol.Keyword.LEN), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SLOWLOG, Protocol.Keyword.RESET), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SMEMBERS), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SMISMEMBER), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.SMOVE), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.SORT), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.LONG, Utils.param(Protocol.Keyword.STORE)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.SORT_RO), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SPOP), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SRANDMEMBER), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SREM), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SSCAN), ResultParserWrapper.wrapList(ResultParserFactory.STRING_SCAN_RESULT));
            this.put(CompositeCommand.create(Protocol.Command.STRLEN), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SUBSTR), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SUNION), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.SUNIONSTORE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.SWAPDB), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.TIME), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.TOUCH), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.TTL), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.TYPE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.UNLINK), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.UNWATCH), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.WAIT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.WATCH), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.XACK), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.XADD), ResultParserWrapper.wrapList(ResultParserFactory.STREAM_ENTRY_ID));
            this.put(CompositeCommand.create(Protocol.Command.XCLAIM), ResultParserWrapper.wrapList(ResultParserFactory.STREAM_ENTRY));
            this.put(CompositeCommand.create(Protocol.Command.XDEL), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.XGROUP, Protocol.Keyword.CREATE), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.XGROUP, Protocol.Keyword.CREATECONSUMER), ResultParserWrapper.wrapList(ResultParserFactory.BOOLEAN));
            this.put(CompositeCommand.create(Protocol.Command.XGROUP, Protocol.Keyword.DELCONSUMER), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.XGROUP, Protocol.Keyword.DESTROY), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.XGROUP, Protocol.Keyword.SETID), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.XINFO, Protocol.Keyword.CONSUMERS), ResultParserWrapper.wrapList(ResultParserFactory.STREAM_CONSUMER_INFO));
            this.put(CompositeCommand.create(Protocol.Command.XINFO, Protocol.Keyword.GROUPS), ResultParserWrapper.wrapList(ResultParserFactory.STREAM_GROUP_INFO));
            this.put(CompositeCommand.create(Protocol.Command.XINFO, Protocol.Keyword.STREAM), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.STREAM_INFO_FULL, Utils.param(Protocol.Keyword.FULL)), ResultParserWrapper.wrap(ResultParserFactory.STREAM_INFO)));
            this.put(CompositeCommand.create(Protocol.Command.XLEN), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.XPENDING), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.STREAM_PENDING_SUMMARY, Utils.length(3)), ResultParserWrapper.wrap(ResultParserFactory.STREAM_PENDING_ENTRY)));
            this.put(CompositeCommand.create(Protocol.Command.XRANGE), ResultParserWrapper.wrapList(ResultParserFactory.STREAM_ENTRY));
            this.put(CompositeCommand.create(Protocol.Command.XREAD), ResultParserWrapper.wrapList(ResultParserFactory.STREAM_READ));
            this.put(CompositeCommand.create(Protocol.Command.XREADGROUP), ResultParserWrapper.wrapList(ResultParserFactory.STREAM_READ));
            this.put(CompositeCommand.create(Protocol.Command.XREVRANGE), ResultParserWrapper.wrapList(ResultParserFactory.STREAM_ENTRY));
            this.put(CompositeCommand.create(Protocol.Command.XTRIM), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZADD), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZCARD), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZCOUNT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZDIFF), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.TUPLE, Utils.param(Protocol.Keyword.WITHSCORES)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.ZDIFFSTORE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZINCRBY), ResultParserWrapper.wrapList(ResultParserFactory.DOUBLE));
            this.put(CompositeCommand.create(Protocol.Command.ZINTER), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.TUPLE, Utils.param(Protocol.Keyword.WITHSCORES)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.ZINTERCARD), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZINTERSTORE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZLEXCOUNT), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZMPOP), ResultParserWrapper.wrapList(ResultParserFactory.KEYED_TUPLE_LIST));
            this.put(CompositeCommand.create(Protocol.Command.ZMSCORE), ResultParserWrapper.wrapList(ResultParserFactory.DOUBLE));
            this.put(CompositeCommand.create(Protocol.Command.ZPOPMAX), ResultParserWrapper.wrapList(ResultParserFactory.TUPLE));
            this.put(CompositeCommand.create(Protocol.Command.ZPOPMIN), ResultParserWrapper.wrapList(ResultParserFactory.TUPLE));
            this.put(CompositeCommand.create(Protocol.Command.ZRANDMEMBER), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.TUPLE, Utils.param(Protocol.Keyword.WITHSCORES)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.ZRANGE), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.TUPLE, Utils.param(Protocol.Keyword.WITHSCORES)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.ZRANGEBYLEX), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ZRANGEBYSCORE), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.TUPLE, Utils.param(Protocol.Keyword.WITHSCORES)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.ZRANK), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZREM), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZREMRANGEBYRANK), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZREMRANGEBYSCORE), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZREVRANGE), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.TUPLE, Utils.param(Protocol.Keyword.WITHSCORES)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.ZREVRANGEBYLEX), ResultParserWrapper.wrapList(ResultParserFactory.STRING));
            this.put(CompositeCommand.create(Protocol.Command.ZREVRANGEBYSCORE), Arrays.asList(ResultParserWrapper.wrap(ResultParserFactory.TUPLE, Utils.param(Protocol.Keyword.WITHSCORES)), ResultParserWrapper.wrap(ResultParserFactory.STRING)));
            this.put(CompositeCommand.create(Protocol.Command.ZREVRANK), ResultParserWrapper.wrapList(ResultParserFactory.LONG));
            this.put(CompositeCommand.create(Protocol.Command.ZSCAN), ResultParserWrapper.wrapList(ResultParserFactory.TUPLE_SCAN_RESULT));
            this.put(CompositeCommand.create(Protocol.Command.ZSCORE), ResultParserWrapper.wrapList(ResultParserFactory.DOUBLE));
        }
    };

    private RedisResultHelper() {
    }

    @NotNull
    private static ResultParser getResultParser(@NotNull RedisQuery query) {
        Optional<ResultParserWrapper> wrapper;
        List<ResultParserWrapper> wrappers = RESULT_PARSERS.get(query.getCompositeCommand());
        if (wrappers != null && (wrapper = wrappers.stream().filter(p -> p.isApplicable(query)).findFirst()).isPresent()) {
            return wrapper.get().getResultParser();
        }
        return ResultParserFactory.OBJECT;
    }

    @NotNull
    public static RedisResult parseResult(@NotNull RedisQuery query, @Nullable Object data) {
        return RedisResultHelper.getResultParser(query).parse(query, data);
    }
}

