/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.query.parser.lexer;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Lexer {
    private static final String LINE_SEPARATOR = "\r|\n|\r\n";

    private Lexer() {
    }

    @NotNull
    public static List<List<String>> tokenize(@NotNull String sql) throws SQLException {
        ArrayList<List<String>> tokens = new ArrayList<List<String>>();
        for (String line : sql.split(LINE_SEPARATOR)) {
            ArrayList<String> lineTokens = new ArrayList<String>();
            State state = new None(null);
            char[] symbols = line.toCharArray();
            for (int i = 0; i <= symbols.length; ++i) {
                char symbol = i == symbols.length ? (char)'\u0000' : symbols[i];
                state = ((State)state).process(symbol);
                String token = state.token;
                if (token == null) continue;
                lineTokens.add(token);
            }
            if (!(state instanceof None)) {
                throw new SQLException("No closing quotation.");
            }
            tokens.add(lineTokens);
        }
        return tokens;
    }

    private static boolean isBlank(char c2) {
        return Character.isWhitespace(c2) || c2 == '\u0000';
    }

    private static boolean isQuote(char c2) {
        return c2 == '\'' || c2 == '\"';
    }

    private static boolean isEscaping(char c2) {
        return c2 == '\\';
    }

    private static class QuotedIdentifier
    extends Identifier {
        public final char quote;

        public QuotedIdentifier(char quote, @NotNull StringBuilder builder, char symbol, boolean isEscaped, @Nullable String token) {
            super(builder, symbol, isEscaped, token);
            this.quote = quote;
            if (isEscaped && (symbol == quote || Lexer.isEscaping(symbol))) {
                builder.deleteCharAt(builder.length() - 1);
            }
            if (symbol != '\u0000') {
                builder.append(symbol);
            }
        }

        public QuotedIdentifier(char quote, @Nullable String token) {
            this(quote, new StringBuilder(), '\u0000', false, token);
        }

        @Override
        @NotNull
        public State process(char symbol) {
            if (symbol == this.quote && !this.isEscaping) {
                return new None(this.builder.toString());
            }
            return new QuotedIdentifier(this.quote, this.builder, symbol, this.isEscaping, null);
        }
    }

    private static class PlainIdentifier
    extends Identifier {
        public PlainIdentifier(@NotNull StringBuilder builder, char symbol, boolean isEscaped, @Nullable String token) {
            super(builder, symbol, isEscaped, token);
            if (!this.isEscaping && symbol != '\u0000') {
                builder.append(symbol);
            }
        }

        public PlainIdentifier(char symbol, @Nullable String token) {
            this(new StringBuilder(), symbol, false, token);
        }

        @Override
        @NotNull
        public State process(char symbol) {
            if (Lexer.isBlank(symbol)) {
                return new None(this.builder.toString());
            }
            if (Lexer.isQuote(symbol) && !this.isEscaping) {
                new QuotedIdentifier(symbol, this.builder.toString());
            }
            return new PlainIdentifier(this.builder, symbol, this.isEscaping, null);
        }
    }

    private static abstract class Identifier
    extends State {
        public final StringBuilder builder;
        public final boolean isEscaping;

        public Identifier(@NotNull StringBuilder builder, char symbol, boolean isEscaped, @Nullable String token) {
            super(token);
            this.builder = builder;
            this.isEscaping = Lexer.isEscaping(symbol) && !isEscaped;
        }
    }

    private static class None
    extends State {
        public None(@Nullable String token) {
            super(token);
        }

        @Override
        @NotNull
        public State process(char symbol) {
            if (Lexer.isBlank(symbol)) {
                return new None(null);
            }
            if (Lexer.isQuote(symbol)) {
                return new QuotedIdentifier(symbol, null);
            }
            return new PlainIdentifier(symbol, null);
        }
    }

    private static abstract class State {
        public final String token;

        protected State(@Nullable String token) {
            this.token = token;
        }

        @NotNull
        public abstract State process(char var1);
    }
}

