/*
 * Decompiled with CFR 0.152.
 */
package jdbc.client.helpers.query.parser;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdbc.client.helpers.query.parser.lexer.Lexer;
import jdbc.client.structures.query.ColumnHint;
import jdbc.client.structures.query.CompositeCommand;
import jdbc.client.structures.query.NodeHint;
import jdbc.client.structures.query.RedisKeyPatternQuery;
import jdbc.client.structures.query.RedisQuery;
import jdbc.client.structures.query.RedisSetDatabaseQuery;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.args.Rawable;

public class QueryParser {
    private static final Map<String, Protocol.Command> COMMANDS = Arrays.stream(Protocol.Command.values()).collect(Collectors.toMap(Enum::name, v -> v));
    private static final Map<String, Protocol.Keyword> KEYWORDS = Arrays.stream(Protocol.Keyword.values()).collect(Collectors.toMap(Enum::name, v -> v));
    private static final Map<String, Protocol.ClusterKeyword> CLUSTER_KEYWORDS = Arrays.stream(Protocol.ClusterKeyword.values()).collect(Collectors.toMap(Enum::name, v -> v));
    private static final Set<Protocol.Command> BLOCKING_COMMANDS = new HashSet<Protocol.Command>();
    private static final Set<Protocol.Command> COMMANDS_WITH_KEYWORDS = new HashSet<Protocol.Command>();

    private QueryParser() {
    }

    @Nullable
    private static Protocol.Command getCommand(@NotNull String command) {
        return COMMANDS.get(Utils.getName(command));
    }

    @Nullable
    private static Rawable getKeyword(@NotNull String keyword) {
        String name = Utils.getName(keyword);
        Protocol.Keyword knownKeyword = KEYWORDS.get(name);
        if (knownKeyword != null) {
            return knownKeyword;
        }
        Protocol.ClusterKeyword clusterKeyword = CLUSTER_KEYWORDS.get(name);
        if (clusterKeyword != null) {
            return clusterKeyword;
        }
        return null;
    }

    @NotNull
    public static RedisQuery parse(@Nullable String sql) throws SQLException {
        if (sql == null) {
            throw new SQLException("Empty query.");
        }
        List<List<String>> tokens = Lexer.tokenize(sql);
        RawQuery rawQuery = QueryParser.createRawQuery(tokens);
        CommandLine commandLine = rawQuery.commandLine;
        Protocol.Command command = QueryParser.parseCommand(commandLine.command);
        Rawable commandKeyword = QueryParser.parseCommandKeyword(command, commandLine.params);
        CompositeCommand compositeCommand = new CompositeCommand(command, commandKeyword);
        ColumnHintLine columnHintLine = rawQuery.columnHintLine;
        ColumnHint columnHint = columnHintLine == null ? null : new ColumnHint(columnHintLine.name, columnHintLine.values);
        NodeHintLine nodeHintLine = rawQuery.nodeHintLine;
        NodeHint nodeHint = nodeHintLine == null || nodeHintLine.hostAndPort == null ? null : new NodeHint(nodeHintLine.hostAndPort);
        return QueryParser.createQuery(compositeCommand, commandLine.params, columnHint, nodeHint);
    }

    @NotNull
    private static Protocol.Command parseCommand(@NotNull String commandStr) throws SQLException {
        Protocol.Command command = QueryParser.getCommand(commandStr);
        if (command == null) {
            throw new SQLException(String.format("Query contains an unknown command: %s.", commandStr));
        }
        return command;
    }

    @Nullable
    private static Rawable parseCommandKeyword(@NotNull Protocol.Command command, @NotNull String[] params) throws SQLException {
        if (!COMMANDS_WITH_KEYWORDS.contains(command)) {
            return null;
        }
        String commandKeywordStr = Utils.getFirst(params);
        if (commandKeywordStr == null) {
            throw new SQLException(String.format("Query does not contain a keyword for the command %s.", command));
        }
        Rawable commandKeyword = QueryParser.getKeyword(commandKeywordStr);
        if (commandKeyword == null) {
            throw new SQLException(String.format("Query contains an unknown keyword for the command %s: %s.", command, commandKeywordStr));
        }
        return commandKeyword;
    }

    @NotNull
    private static RedisQuery createQuery(@NotNull CompositeCommand compositeCommand, @NotNull String[] params, @Nullable ColumnHint columnHint, @Nullable NodeHint nodeHint) throws SQLException {
        Protocol.Command command = compositeCommand.getCommand();
        boolean isBlocking = BLOCKING_COMMANDS.contains(command);
        if (command == Protocol.Command.SELECT && params.length == 1) {
            int dbIndex = Utils.parseSqlDbIndex(Utils.getFirst(params));
            return new RedisSetDatabaseQuery(compositeCommand, dbIndex, columnHint);
        }
        if (command == Protocol.Command.KEYS) {
            String pattern = Utils.getFirst(params);
            return new RedisKeyPatternQuery(compositeCommand, params, pattern, columnHint, nodeHint, isBlocking);
        }
        if (command == Protocol.Command.SCAN) {
            Integer matchIndex = Utils.getIndex(params, p -> Protocol.Keyword.MATCH.name().equalsIgnoreCase((String)p));
            String pattern = matchIndex == null || matchIndex == params.length - 1 ? null : params[matchIndex + 1];
            return new RedisKeyPatternQuery(compositeCommand, params, pattern, columnHint, nodeHint, isBlocking);
        }
        return new RedisQuery(compositeCommand, params, columnHint, nodeHint, BLOCKING_COMMANDS.contains(command));
    }

    @NotNull
    private static RawQuery createRawQuery(@NotNull List<List<String>> tokens) throws SQLException {
        List<Line> lines = tokens.stream().map(QueryParser::createLine).collect(Collectors.toList());
        List commandLines = lines.stream().map(l -> l instanceof CommandLine ? (CommandLine)l : null).filter(Objects::nonNull).collect(Collectors.toList());
        if (commandLines.isEmpty()) {
            throw new SQLException("Query should contain a command.");
        }
        if (commandLines.size() > 1) {
            throw new SQLException("Query can contain only one command.");
        }
        CommandLine commandLine = (CommandLine)commandLines.get(0);
        ColumnHintLine columnHintLine = QueryParser.getHintLine(lines, l -> l instanceof ColumnHintLine ? (ColumnHintLine)l : null, "column");
        NodeHintLine nodeHintLine = QueryParser.getHintLine(lines, l -> l instanceof NodeHintLine ? (NodeHintLine)l : null, "node");
        return new RawQuery(commandLine, columnHintLine, nodeHintLine);
    }

    @Nullable
    private static Line createLine(@NotNull List<String> lineTokens) {
        if (NodeHintLine.accepts(lineTokens)) {
            return new NodeHintLine(lineTokens);
        }
        if (ColumnHintLine.accepts(lineTokens)) {
            return new ColumnHintLine(lineTokens);
        }
        if (CommentLine.accepts(lineTokens)) {
            return new CommentLine(lineTokens);
        }
        if (CommandLine.accepts(lineTokens)) {
            return new CommandLine(lineTokens);
        }
        return null;
    }

    @Nullable
    private static <T extends HintLine> T getHintLine(@NotNull List<Line> lines, @NotNull Function<Line, T> lineMapper, @NotNull String hintType) throws SQLException {
        List hintLines = lines.stream().map(lineMapper).filter(Objects::nonNull).collect(Collectors.toList());
        if (hintLines.size() > 1) {
            throw new SQLException(String.format("Query can contain only one comment with %s hint.", hintType));
        }
        return (T)(hintLines.isEmpty() ? null : (HintLine)hintLines.get(0));
    }

    static {
        BLOCKING_COMMANDS.add(Protocol.Command.BLMOVE);
        BLOCKING_COMMANDS.add(Protocol.Command.BLMPOP);
        BLOCKING_COMMANDS.add(Protocol.Command.BLPOP);
        BLOCKING_COMMANDS.add(Protocol.Command.BRPOP);
        BLOCKING_COMMANDS.add(Protocol.Command.BRPOPLPUSH);
        BLOCKING_COMMANDS.add(Protocol.Command.BZMPOP);
        BLOCKING_COMMANDS.add(Protocol.Command.BZPOPMAX);
        BLOCKING_COMMANDS.add(Protocol.Command.BZPOPMIN);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.ACL);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.CLIENT);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.CLUSTER);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.COMMAND);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.CONFIG);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.FUNCTION);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.MEMORY);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.MODULE);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.OBJECT);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.PUBSUB);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.SCRIPT);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.SLOWLOG);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.XGROUP);
        COMMANDS_WITH_KEYWORDS.add(Protocol.Command.XINFO);
    }

    private static class NodeHintLine
    extends CommentLine
    implements HintLine {
        private static final String NODE_TOKEN = "node";
        private static final String SEPARATOR_TOKEN = "=";
        @Nullable
        public final HostAndPort hostAndPort;

        NodeHintLine(@NotNull List<String> tokens) {
            super(tokens);
            if (!NodeHintLine.accepts(tokens)) {
                throw new AssertionError((Object)String.format("Incorrect node hint tokens: %s.", tokens));
            }
            HostAndPort hostAndPort = null;
            try {
                hostAndPort = Utils.parseHostAndPort(tokens.get(3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hostAndPort = hostAndPort;
        }

        public static boolean accepts(@NotNull List<String> tokens) {
            return CommentLine.accepts(tokens) && tokens.size() == 4 && NODE_TOKEN.equalsIgnoreCase(tokens.get(1)) && SEPARATOR_TOKEN.equals(tokens.get(2));
        }
    }

    private static class ColumnHintLine
    extends CommentLine
    implements HintLine {
        private static final String SEPARATOR_TOKEN = ":";
        @NotNull
        public final String name;
        @NotNull
        public final String[] values;

        ColumnHintLine(@NotNull List<String> tokens) {
            super(tokens);
            if (!ColumnHintLine.accepts(tokens)) {
                throw new AssertionError((Object)String.format("Incorrect column hint tokens: %s.", tokens));
            }
            this.name = tokens.get(1);
            this.values = (String[])tokens.stream().skip(3L).toArray(String[]::new);
        }

        public static boolean accepts(@NotNull List<String> tokens) {
            return CommentLine.accepts(tokens) && tokens.size() >= 3 && SEPARATOR_TOKEN.equals(tokens.get(2));
        }
    }

    private static class CommentLine
    implements Line {
        private static final String COMMENT_TOKEN = "--";

        CommentLine(@NotNull List<String> tokens) {
            if (!CommentLine.accepts(tokens)) {
                throw new AssertionError((Object)String.format("Incorrect comment tokens: %s.", tokens));
            }
        }

        public static boolean accepts(@NotNull List<String> tokens) {
            return tokens.size() >= 1 && COMMENT_TOKEN.equals(tokens.get(0));
        }
    }

    private static class CommandLine
    implements Line {
        public final String command;
        public final String[] params;

        CommandLine(@NotNull List<String> tokens) {
            if (!CommandLine.accepts(tokens)) {
                throw new AssertionError((Object)String.format("Incorrect command tokens: %s.", tokens));
            }
            this.command = tokens.get(0);
            this.params = (String[])tokens.stream().skip(1L).toArray(String[]::new);
        }

        public static boolean accepts(@NotNull List<String> tokens) {
            return tokens.size() >= 1;
        }
    }

    private static interface HintLine
    extends Line {
    }

    private static interface Line {
    }

    private static class RawQuery {
        public final CommandLine commandLine;
        public final ColumnHintLine columnHintLine;
        public final NodeHintLine nodeHintLine;

        RawQuery(@NotNull CommandLine commandLine, @Nullable ColumnHintLine columnHintLine, @Nullable NodeHintLine nodeHintLine) {
            this.commandLine = commandLine;
            this.columnHintLine = columnHintLine;
            this.nodeHintLine = nodeHintLine;
        }
    }
}

