/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import jdbc.RedisConnection;
import jdbc.client.RedisClient;
import jdbc.client.structures.result.RedisListResult;
import jdbc.client.structures.result.RedisMapResult;
import jdbc.client.structures.result.RedisObjectResult;
import jdbc.client.structures.result.RedisResult;
import jdbc.resultset.RedisEmptyResultSet;
import jdbc.resultset.RedisListResultSet;
import jdbc.resultset.RedisMapResultSet;
import jdbc.resultset.RedisObjectResultSet;

public class RedisStatement
implements Statement {
    private final RedisConnection connection;
    private final RedisClient client;
    private boolean isClosed = false;
    private ResultSet resultSet;

    RedisStatement(RedisConnection connection, RedisClient client) {
        this.connection = connection;
        this.client = client;
    }

    private ResultSet createResultSet(RedisResult result) {
        if (result instanceof RedisListResult) {
            return new RedisListResultSet(this, (RedisListResult)result);
        }
        if (result instanceof RedisMapResult) {
            return new RedisMapResultSet(this, (RedisMapResult)result);
        }
        if (result instanceof RedisObjectResult) {
            return new RedisObjectResultSet(this, (RedisObjectResult)result);
        }
        return new RedisEmptyResultSet(this);
    }

    private ResultSet executeImpl(String sql) throws SQLException {
        RedisResult result = this.client.execute(sql);
        return this.createResultSet(result);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        return this.executeImpl(sql);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        this.executeImpl(sql);
        return 1;
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        this.resultSet = this.executeImpl(sql);
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        return this.getMoreResults(1);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkClosed();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        return new int[0];
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Statement was previously closed.");
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

