/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import jdbc.RedisConnection;
import jdbc.client.RedisClient;
import jdbc.client.RedisClientFactory;
import jdbc.properties.RedisDriverPropertyInfoHelper;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;

public class RedisDriver
implements Driver {
    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        RedisClient client = RedisClientFactory.create(url, info);
        if (client == null) {
            return null;
        }
        RedisConnection connection = new RedisConnection(this, client);
        try {
            RedisDriver.checkConnectionModeIfNeeded(info, connection);
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    private static void checkConnectionModeIfNeeded(Properties info, @NotNull RedisConnection connection) throws SQLException {
        if (!Utils.getBoolean(info, "verifyConnectionMode", true)) {
            return;
        }
        connection.checkMode();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return RedisClientFactory.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return RedisDriverPropertyInfoHelper.getPropertyInfo();
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new RedisDriver());
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

