/*
 * Decompiled with CFR 0.152.
 */
package jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import jdbc.RedisDatabaseMetaData;
import jdbc.RedisDriver;
import jdbc.RedisPreparedStatement;
import jdbc.RedisStatement;
import jdbc.client.RedisClient;
import jdbc.client.RedisClientFactory;
import jdbc.client.RedisMode;
import jdbc.utils.Utils;
import org.jetbrains.annotations.NotNull;

public class RedisConnection
implements Connection {
    private final RedisDriver driver;
    private final RedisClient client;
    private boolean isClosed = false;
    private boolean isReadOnly = false;
    private static final String UNKNOWN_SERVER_MODE_MESSAGE = "Unable to get the server mode using the \"INFO server\" command to check if the connection mode matches the server mode.";

    public RedisConnection(RedisDriver driver, RedisClient client) {
        this.driver = driver;
        this.client = client;
    }

    public void checkMode() throws SQLException {
        RedisMode serverMode;
        try {
            serverMode = this.getMetaData().getDatabaseProductMode();
        }
        catch (SQLException e) {
            throw new SQLException(UNKNOWN_SERVER_MODE_MESSAGE, e);
        }
        if (serverMode == null) {
            throw new SQLException(UNKNOWN_SERVER_MODE_MESSAGE);
        }
        RedisMode clientMode = this.client.getMode();
        if (clientMode != serverMode) {
            String serverURLPrefix = RedisClientFactory.getURLPrefix(serverMode);
            String urlFix = serverURLPrefix != null ? String.format("\nPlease change the URL prefix to \"%s\".", serverURLPrefix) : null;
            throw new SQLException(String.format("The connection mode \"%s\" does not match the server mode \"%s\".%s", Utils.toLowerCase(clientMode.name()), Utils.toLowerCase(serverMode.name()), urlFix));
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection was previously closed.");
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new RedisStatement(this, this.client);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return new RedisPreparedStatement(this, this.client, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Redis does not support SQL natively.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.client.close();
        }
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    @NotNull
    public RedisDatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new RedisDatabaseMetaData(this, this.driver);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.isReadOnly = true;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.isReadOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.client.setDatabase(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.client.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        try (Statement statement = this.createStatement();){
            statement.executeQuery("PING");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.setCatalog(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.getCatalog();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

