/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.theme;

import com.timestored.TimeStored;
import com.timestored.misc.InfoLink;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public AboutDialog(JFrame parentFrame, String title, Icon icon, String htmlTitle, String version) {
        super((Frame)parentFrame, title);
        this.setIconImage(icon.get().getImage());
        this.setMinimumSize(new Dimension(500, 400));
        JPanel logoPanel = new JPanel();
        logoPanel.add(new JLabel(icon.get()));
        logoPanel.add(Theme.getHtmlText(htmlTitle));
        logoPanel.setAlignmentX(0.5f);
        JLabel label = new JLabel("<html><h4>Version: " + version + "</h4></html>");
        label.setHorizontalAlignment(0);
        String txt = "QStudio Release Changes";
        JPanel timestoredLinkPanel = Theme.getVerticalBoxPanel();
        timestoredLinkPanel.add(label);
        timestoredLinkPanel.add(InfoLink.getLabel(txt, txt, TimeStored.Page.QSTUDIO_CHANGES.url(), true));
        timestoredLinkPanel.setAlignmentX(0.5f);
        Container cp = this.getContentPane();
        cp.setLayout(new BoxLayout(cp, 3));
        cp.add(logoPanel);
        cp.add(timestoredLinkPanel);
        cp.add(Theme.getSubHeader("Configuration Details:"));
        ScrollPane sp = new ScrollPane();
        final JTextArea textArea = Theme.getTextArea("name", this.getDetails());
        textArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!textArea.hasFocus()) {
                    textArea.requestFocusInWindow();
                    textArea.selectAll();
                }
            }
        });
        sp.add(textArea);
        cp.add(sp);
        this.pack();
        this.setLocationRelativeTo(parentFrame);
    }

    private String getDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append("version = 4.07");
        sb.append("\ncurrent dir = " + new File(".").getAbsolutePath());
        sb.append("\nJAVA_HOME = " + System.getenv("JAVA_HOME"));
        sb.append("\njava.version =" + System.getProperty("java.version"));
        sb.append("\nos.name =" + System.getProperty("os.name"));
        sb.append("\nuser.home =" + System.getProperty("user.home"));
        sb.append("\nuser.dir =" + System.getProperty("user.dir"));
        sb.append("\nPATH = " + System.getenv("PATH"));
        return sb.toString();
    }
}

